/*******************************************************************************
 * Copyright (c) 2009 xored software, Inc.  
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html  
 *
 * Contributors:
 *     xored software, Inc. - initial API and Implementation (Vladimir Belov)
 *******************************************************************************/

package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;

public class ForInStatement extends LoopStatement implements ISemicolonStatement {

	private Keyword forKeyword;
	private Keyword inKeyword;
	private Expression item;
	private Expression iterator;
	private int LP = -1;
	private int RP = -1;
	private int semic = -1;

	public ForInStatement(ASTNode parent) {
		super(parent);
	}

	public Expression getItem() {
		return this.item;
	}

	public void setItem(Expression item) {
		this.item = item;
	}

	public Expression getIterator() {
		return this.iterator;
	}

	public void setIterator(Expression iterator) {
		this.iterator = iterator;
	}

	public Keyword getForKeyword() {
		return this.forKeyword;
	}

	public void setForKeyword(Keyword keyword) {
		this.forKeyword = keyword;
	}

	public Keyword getInKeyword() {
		return this.inKeyword;
	}

	public void setInKeyword(Keyword keyword) {
		this.inKeyword = keyword;
	}

	public int getLP() {
		return this.LP;
	}

	public void setLP(int LP) {
		this.LP = LP;
	}

	public int getRP() {
		return this.RP;
	}

	public void setRP(int RP) {
		this.RP = RP;
	}

	public int getSemicolonPosition() {
		return this.semic;
	}

	public void setSemicolonPosition(int semic) {
		this.semic = semic;
	}

	public String toSourceString(String indentationString) {

		Assert.isTrue(sourceStart() >= 0);
		Assert.isTrue(sourceEnd() > 0);
		Assert.isTrue(LP > 0);
		Assert.isTrue(RP > 0);
		Assert.isTrue((getBody() != null && semic < 0)
				|| (getBody() == null && semic > -1));

		StringBuffer buffer = new StringBuffer();

		buffer.append(indentationString);
		buffer.append(Keywords.FOR);
		buffer.append(" (");
		buffer.append(getItem().toSourceString(indentationString));
		buffer.append(" ");
		buffer.append(Keywords.IN);
		buffer.append(" ");
		buffer.append(getIterator().toSourceString(indentationString));
		buffer.append(")");
		if (getBody() != null) {
			buffer.append("\n");
			buffer.append(getBody().toSourceString(indentationString));
			if (semic > -1)
				buffer.append(';');
		} else {
			if (semic > -1)
				buffer.append(';');
			buffer.append("\n");
		}

		return buffer.toString();
	}

}
