/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.actions.refactoring;

import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.internal.ui.actions.ActionUtil;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.actions.RenameModelElementAction;
import org.eclipse.dltk.internal.ui.refactoring.actions.RenameResourceAction;
import org.eclipse.dltk.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;

public class RenameAction
extends SelectionDispatchAction {
    private RenameModelElementAction fRenameScriptElement;
    private RenameResourceAction fRenameResource;
    private ScriptEditor fEditor;

    public RenameAction(IWorkbenchSite site) {
        super(site);
        this.setText(RefactoringMessages.RenameAction_text);
        this.fRenameScriptElement = new RenameModelElementAction(site);
        this.fRenameScriptElement.setText(this.getText());
        this.fRenameResource = new RenameResourceAction(site);
        this.fRenameResource.setText(this.getText());
        if (DLTKCore.DEBUG) {
            System.err.println("Add help support here...");
        }
    }

    public RenameAction(ScriptEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.fRenameScriptElement = new RenameModelElementAction(editor);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fRenameScriptElement.selectionChanged(event);
        if (this.fRenameResource != null) {
            this.fRenameResource.selectionChanged(event);
        }
        this.setEnabled(this.computeEnabledState());
    }

    public void update(ISelection selection) {
        this.fRenameScriptElement.update(selection);
        if (this.fRenameResource != null) {
            this.fRenameResource.update(selection);
        }
        this.setEnabled(this.computeEnabledState());
    }

    private boolean computeEnabledState() {
        if (this.fRenameResource != null) {
            return this.fRenameScriptElement.isEnabled() || this.fRenameResource.isEnabled();
        }
        return this.fRenameScriptElement.isEnabled();
    }

    public void run(IStructuredSelection selection) {
        if (this.fRenameScriptElement.isEnabled()) {
            this.fRenameScriptElement.run(selection);
        }
        if (this.fRenameResource != null && this.fRenameResource.isEnabled()) {
            this.fRenameResource.run(selection);
        }
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.getShell(), this.fEditor)) {
            return;
        }
        if (this.fRenameScriptElement.canRun()) {
            this.fRenameScriptElement.run(selection);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)RefactoringMessages.RenameAction_rename, (String)RefactoringMessages.RenameAction_unavailable);
        }
    }
}

