/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parsers.jruby;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.ast.ASTListNode;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.DLTKToken;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.BigNumericLiteral;
import org.eclipse.dltk.ast.expressions.BooleanLiteral;
import org.eclipse.dltk.ast.expressions.CallArgumentsList;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.expressions.FloatNumericLiteral;
import org.eclipse.dltk.ast.expressions.NilLiteral;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ast.expressions.StringLiteral;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.SimpleReference;
import org.eclipse.dltk.ast.references.VariableKind;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ruby.ast.RubyAliasExpression;
import org.eclipse.dltk.ruby.ast.RubyArrayExpression;
import org.eclipse.dltk.ruby.ast.RubyAssignment;
import org.eclipse.dltk.ruby.ast.RubyBacktickStringLiteral;
import org.eclipse.dltk.ruby.ast.RubyBeginExpression;
import org.eclipse.dltk.ruby.ast.RubyBinaryExpression;
import org.eclipse.dltk.ruby.ast.RubyBlock;
import org.eclipse.dltk.ruby.ast.RubyBreakExpression;
import org.eclipse.dltk.ruby.ast.RubyCallArgumentsList;
import org.eclipse.dltk.ruby.ast.RubyCaseStatement;
import org.eclipse.dltk.ruby.ast.RubyClassDeclaration;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.ast.RubyConstantDeclaration;
import org.eclipse.dltk.ruby.ast.RubyDAssgnExpression;
import org.eclipse.dltk.ruby.ast.RubyDRegexpExpression;
import org.eclipse.dltk.ruby.ast.RubyDSymbolExpression;
import org.eclipse.dltk.ruby.ast.RubyDVarExpression;
import org.eclipse.dltk.ruby.ast.RubyDefinedExpression;
import org.eclipse.dltk.ruby.ast.RubyDotExpression;
import org.eclipse.dltk.ruby.ast.RubyDynamicBackquoteStringExpression;
import org.eclipse.dltk.ruby.ast.RubyDynamicStringExpression;
import org.eclipse.dltk.ruby.ast.RubyEnsureExpression;
import org.eclipse.dltk.ruby.ast.RubyEvaluatableStringExpression;
import org.eclipse.dltk.ruby.ast.RubyForStatement2;
import org.eclipse.dltk.ruby.ast.RubyHashExpression;
import org.eclipse.dltk.ruby.ast.RubyHashPairExpression;
import org.eclipse.dltk.ruby.ast.RubyIfStatement;
import org.eclipse.dltk.ruby.ast.RubyMatch2Expression;
import org.eclipse.dltk.ruby.ast.RubyMatch3Expression;
import org.eclipse.dltk.ruby.ast.RubyMatchExpression;
import org.eclipse.dltk.ruby.ast.RubyMethodArgument;
import org.eclipse.dltk.ruby.ast.RubyMultipleAssignmentStatement;
import org.eclipse.dltk.ruby.ast.RubyNextExpression;
import org.eclipse.dltk.ruby.ast.RubyNotExpression;
import org.eclipse.dltk.ruby.ast.RubyRedoExpression;
import org.eclipse.dltk.ruby.ast.RubyRegexpExpression;
import org.eclipse.dltk.ruby.ast.RubyRescueBodyStatement;
import org.eclipse.dltk.ruby.ast.RubyRescueStatement;
import org.eclipse.dltk.ruby.ast.RubyRetryExpression;
import org.eclipse.dltk.ruby.ast.RubyReturnStatement;
import org.eclipse.dltk.ruby.ast.RubySelfReference;
import org.eclipse.dltk.ruby.ast.RubySingletonClassDeclaration;
import org.eclipse.dltk.ruby.ast.RubySingletonMethodDeclaration;
import org.eclipse.dltk.ruby.ast.RubySuperExpression;
import org.eclipse.dltk.ruby.ast.RubySymbolReference;
import org.eclipse.dltk.ruby.ast.RubyUndefStatement;
import org.eclipse.dltk.ruby.ast.RubyUntilStatement;
import org.eclipse.dltk.ruby.ast.RubyVariableKind;
import org.eclipse.dltk.ruby.ast.RubyWhenStatement;
import org.eclipse.dltk.ruby.ast.RubyWhileStatement;
import org.eclipse.dltk.ruby.ast.RubyYieldExpression;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.parser.JRubySourceParser;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefnNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.Node;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptNNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.RedoNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.RetryNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZArrayNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.lexer.yacc.SourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Visibility;

public class RubyASTBuildVisitor
implements NodeVisitor {
    protected static final boolean TRACE_RECOVERING = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.dltk.ruby.core/parsing/traceRecoveryWhenInterpretingAST"));
    private ModuleDeclaration module;
    private final char[] content;
    private StateManager states = new StateManager();

    protected ASTNode collectSingleNodeSafe(Node pathNode) {
        return this.collectSingleNodeSafe(pathNode, false);
    }

    protected ASTNode collectSingleNodeSafe(Node node, boolean allowZero) {
        ASTNode res = null;
        try {
            res = this.collectSingleNode0(node, allowZero);
        }
        catch (Throwable t) {
            if (JRubySourceParser.isSilentState()) {
                node.accept(this);
            }
            throw new RuntimeException(t);
        }
        return res;
    }

    protected ASTNode collectSingleNode0(Node node, boolean allowZero) {
        if (node == null) {
            return null;
        }
        CollectingState state = new CollectingState();
        this.states.push(state);
        node.accept(this);
        this.states.pop();
        ArrayList list = state.getList();
        if (list.size() == 1) {
            return (ASTNode)list.iterator().next();
        }
        if (node instanceof NewlineNode) {
            NewlineNode newlineNode = (NewlineNode)node;
            node = newlineNode.getNextNode();
        }
        if (list.size() > 1) {
            throw new RuntimeException("DLTKASTBuildVisitor.collectSingleStatement(): JRuby node " + node.getClass().getName() + " hasn't been converted into any DLTK AST node");
        }
        if (allowZero) {
            return null;
        }
        throw new RuntimeException("DLTKASTBuildVisitor.collectSingleStatement(): JRuby node " + node.getClass().getName() + " hasn't been converted into any DLTK AST node");
    }

    protected char[] getContent() {
        return this.content;
    }

    public RubyASTBuildVisitor(ModuleDeclaration module, char[] content) {
        this.module = module;
        this.content = content;
        this.states.push(new TopLevelState(this.module));
    }

    public Instruction visitAliasNode(AliasNode iVisited) {
        String oldName = iVisited.getOldName();
        String newName = iVisited.getNewName();
        ISourcePosition pos = iVisited.getPosition();
        RubyAliasExpression expr = new RubyAliasExpression(pos.getStartOffset(), pos.getEndOffset(), oldName, newName);
        this.states.peek().add(expr);
        return null;
    }

    public Instruction visitAndNode(AndNode iVisited) {
        ASTNode left = this.collectSingleNodeSafe(iVisited.getFirstNode());
        ASTNode right = this.collectSingleNodeSafe(iVisited.getSecondNode());
        RubyBinaryExpression b = new RubyBinaryExpression(left, 1007, right);
        this.states.peek().add(b);
        return null;
    }

    public Instruction visitArgsNode(ArgsNode iVisited) {
        if (iVisited.getOptArgs() != null) {
            iVisited.getOptArgs().accept(this);
        }
        return null;
    }

    public Instruction visitArgsCatNode(ArgsCatNode iVisited) {
        if (iVisited.getFirstNode() != null) {
            iVisited.getFirstNode().accept(this);
        }
        if (iVisited.getSecondNode() != null) {
            iVisited.getSecondNode().accept(this);
        }
        return null;
    }

    private List processListNode(ListNode node) {
        CollectingState coll = new CollectingState();
        this.states.push(coll);
        Iterator iterator = node.childNodes().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).accept(this);
        }
        this.states.pop();
        return coll.getList();
    }

    public Instruction visitArrayNode(ArrayNode iVisited) {
        List exprs = this.processListNode(iVisited);
        ISourcePosition position = iVisited.getPosition();
        RubyArrayExpression arr = new RubyArrayExpression();
        arr.setEnd(position.getEndOffset());
        arr.setStart(position.getStartOffset());
        arr.setChilds(exprs);
        this.states.peek().add((ASTNode)arr);
        return null;
    }

    public Instruction visitBackRefNode(BackRefNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        VariableReference ref = new VariableReference(pos.getStartOffset(), pos.getEndOffset(), "$" + iVisited.getType());
        this.states.peek().add((ASTNode)ref);
        return null;
    }

    public Instruction visitBeginNode(BeginNode iVisited) {
        ASTNode body = this.collectSingleNodeSafe(iVisited.getBodyNode());
        ISourcePosition pos = iVisited.getPosition();
        RubyBeginExpression e = new RubyBeginExpression(pos.getStartOffset(), pos.getEndOffset(), body);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitBlockArgNode(BlockArgNode iVisited) {
        return null;
    }

    public Instruction visitBlockNode(BlockNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        Block block = new Block(pos.getStartOffset(), pos.getEndOffset());
        this.states.push(new BlockState(block));
        Iterator iterator = iVisited.childNodes().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).accept(this);
        }
        this.states.pop();
        this.states.peek().add((ASTNode)block);
        return null;
    }

    public Instruction visitBlockPassNode(BlockPassNode iVisited) {
        this.collectSingleNodeSafe(iVisited.getArgsNode());
        ASTNode body = this.collectSingleNodeSafe(iVisited.getBodyNode());
        ISourcePosition pos = iVisited.getPosition();
        RubyBlock e = new RubyBlock(pos.getStartOffset(), pos.getEndOffset(), body);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitBreakNode(BreakNode iVisited) {
        ASTNode value = this.collectSingleNodeSafe(iVisited.getValueNode());
        ISourcePosition pos = iVisited.getPosition();
        RubyBreakExpression e = new RubyBreakExpression(pos.getStartOffset(), pos.getEndOffset(), value);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitConstDeclNode(ConstDeclNode iVisited) {
        int start;
        Node pathNode = iVisited.getConstNode();
        ASTNode pathResult = null;
        if (pathNode != null) {
            pathResult = this.collectSingleNodeSafe(pathNode);
        }
        ASTNode value = this.collectSingleNodeSafe(iVisited.getValueNode());
        ISourcePosition position = iVisited.getPosition();
        int end = start = position.getStartOffset();
        while (RubySyntaxUtils.isWhitespace(this.content[end])) {
            ++end;
        }
        while (RubySyntaxUtils.isNameChar(this.content[end])) {
            ++end;
        }
        SimpleReference name = new SimpleReference(start, end, iVisited.getName());
        RubyConstantDeclaration node = new RubyConstantDeclaration(pathResult, name, value);
        this.states.peek().add(node);
        return null;
    }

    public Instruction visitClassVarAsgnNode(ClassVarAsgnNode iVisited) {
        this.processVariableAssignment(iVisited, iVisited.getName(), RubyVariableKind.CLASS, iVisited.getValueNode());
        return null;
    }

    public Instruction visitClassVarDeclNode(ClassVarDeclNode iVisited) {
        this.processVariableAssignment(iVisited, iVisited.getName(), RubyVariableKind.CLASS, iVisited.getValueNode());
        return null;
    }

    public Instruction visitClassVarNode(ClassVarNode iVisited) {
        this.processVariableReference(iVisited, iVisited.getName(), RubyVariableKind.CLASS);
        return null;
    }

    private void fixCallOffsets(CallExpression callNode, String nameNode, int possibleDotPosition, int firstArgStart, int lastArgEnd) {
        int dotPosition = RubySyntaxUtils.skipWhitespaceForward(this.content, possibleDotPosition);
        if (dotPosition >= 0 && dotPosition < this.content.length && this.content[dotPosition] == '.') {
            this.fixFunctionCallOffsets(callNode, nameNode, dotPosition + 1, firstArgStart, lastArgEnd);
            return;
        }
        String methodName = nameNode;
        if (methodName != RubySyntaxUtils.ARRAY_GET_METHOD && methodName != RubySyntaxUtils.ARRAY_PUT_METHOD && TRACE_RECOVERING) {
            RubyPlugin.log("Ruby AST: non-dot-call not recognized, non-dot found at " + dotPosition + ", function name " + methodName);
        }
        int sourceEnd = callNode.sourceEnd() - 1;
        while (sourceEnd >= 0 && Character.isWhitespace(this.content[sourceEnd])) {
            --sourceEnd;
        }
        if (sourceEnd >= 0) {
            callNode.setEnd(sourceEnd + 1);
        }
    }

    private void fixFunctionCallOffsets(CallExpression callNode, String nameNode, int possibleNameStart, int firstArgStart, int lastArgEnd) {
        String methodName = nameNode;
        int nameStart = RubySyntaxUtils.skipWhitespaceForward(this.content, possibleNameStart);
        int nameEnd = nameStart + methodName.length();
        if (firstArgStart < 0) {
            int lParenOffset = RubySyntaxUtils.skipWhitespaceForward(this.content, nameEnd);
            if (lParenOffset >= 0 && this.content[lParenOffset] == '(') {
                int rParenOffset = RubySyntaxUtils.skipWhitespaceForward(this.content, lParenOffset + 1);
                if (rParenOffset >= 0 && this.content[rParenOffset] == ')') {
                    callNode.setEnd(rParenOffset + 1);
                } else {
                    if (TRACE_RECOVERING) {
                        RubyPlugin.log("Ruby AST: function call, empty args, no closing paren; opening paren at " + lParenOffset + ", function name " + methodName);
                    }
                    callNode.setEnd(lParenOffset - 1);
                }
            }
        } else {
            if (nameEnd > firstArgStart) {
                if (TRACE_RECOVERING) {
                    RubyPlugin.log("DLTKASTBuildVisitor.fixFunctionCallOffsets(" + methodName + "): nameEnd > firstArgStart");
                }
                return;
            }
            int lParenOffset = RubySyntaxUtils.skipWhitespaceForward(this.content, nameEnd, firstArgStart);
            if (lParenOffset >= 0 && this.content[lParenOffset] == '(') {
                if (lastArgEnd <= lParenOffset) {
                    if (TRACE_RECOVERING) {
                        RubyPlugin.log("DLTKASTBuildVisitor.fixFunctionCallOffsets(" + methodName + "): lastArgEnd <= lParenOffset");
                    }
                    return;
                }
                int rParenOffset = RubySyntaxUtils.skipWhitespaceForward(this.content, lastArgEnd);
                if (rParenOffset >= 0 && this.content[rParenOffset] == ')') {
                    callNode.setEnd(rParenOffset + 1);
                } else {
                    if (TRACE_RECOVERING) {
                        RubyPlugin.log("Ruby AST: function call, non-empty args, no closing paren; opening paren at " + lParenOffset + ", " + "last argument ending at " + lastArgEnd + ", function name " + methodName);
                    }
                    callNode.setEnd(lastArgEnd);
                }
            }
        }
        if (lastArgEnd >= 0 && callNode.sourceEnd() < lastArgEnd) {
            callNode.setEnd(lastArgEnd);
        }
    }

    public Instruction visitCallNode(CallNode iVisited) {
        ASTNode recv;
        String methodName = iVisited.getName();
        CollectingState collector = new CollectingState();
        Assert.isTrue((iVisited.getReceiverNode() != null ? 1 : 0) != 0);
        this.states.push(collector);
        iVisited.getReceiverNode().accept(this);
        this.states.pop();
        if (collector.getList().size() > 1 && TRACE_RECOVERING) {
            RubyPlugin.log("DLTKASTBuildVisitor.visitCallNode(" + methodName + "): receiver " + iVisited.getReceiverNode().getClass().getName() + " turned into multiple nodes");
        }
        if (collector.getList().size() < 1) {
            recv = new NumericLiteral(new DLTKToken(0, ""));
            recv.setStart(iVisited.getPosition().getStartOffset());
            recv.setEnd(iVisited.getPosition().getEndOffset() + 1);
        } else {
            recv = (ASTNode)collector.getList().get(0);
        }
        collector.reset();
        int argsStart = -1;
        int argsEnd = -1;
        RubyCallArgumentsList argList = new RubyCallArgumentsList();
        Node argsNode = iVisited.getArgsNode();
        if (argsNode != null) {
            this.states.push(new ArgumentsState(argList));
            if (argsNode instanceof ListNode) {
                ListNode arrayNode = (ListNode)argsNode;
                List list = arrayNode.childNodes();
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    node.accept(this);
                }
            } else {
                if (TRACE_RECOVERING) {
                    RubyPlugin.log("DLTKASTBuildVisitor.visitCallNode(" + methodName + ") - unknown args node type: " + argsNode.getClass().getName());
                }
                argsNode.accept(this);
            }
            this.states.pop();
            List children = argsNode.childNodes();
            if (children.size() > 0) {
                argsStart = ((Node)children.get(0)).getPosition().getStartOffset();
                argsEnd = ((Node)children.get(children.size() - 1)).getPosition().getEndOffset();
                List argListExprs = argList.getChilds();
                if (!argListExprs.isEmpty()) {
                    argsEnd = Math.max(argsEnd, ((ASTNode)argListExprs.get(argListExprs.size() - 1)).sourceEnd());
                }
            }
        }
        if (iVisited.getIterNode() != null) {
            ASTNode s = this.collectSingleNodeSafe(iVisited.getIterNode());
            argList.addNode(s);
        }
        argList.autosetOffsets();
        CallExpression c = new CallExpression(recv, methodName, (CallArgumentsList)argList);
        int receiverEnd = recv.sourceEnd();
        c.setStart(iVisited.getPosition().getStartOffset());
        c.setEnd(argsEnd >= 0 ? argsEnd : iVisited.getPosition().getEndOffset());
        this.fixCallOffsets(c, methodName, receiverEnd, argsStart, argsEnd);
        this.states.peek().add((ASTNode)c);
        return null;
    }

    public Instruction visitCaseNode(CaseNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        RubyCaseStatement statement = new RubyCaseStatement(pos.getStartOffset(), pos.getEndOffset());
        ASTNode caseTarget = this.collectSingleNodeSafe(iVisited.getCaseNode());
        statement.setTarget(caseTarget);
        Node caseBody = iVisited.getFirstWhenNode();
        ASTNode caseSt = this.collectSingleNodeSafe(caseBody);
        ArrayList<ASTNode> whens = new ArrayList<ASTNode>(1);
        while (caseBody instanceof WhenNode) {
            WhenNode whenNode = (WhenNode)caseBody;
            whens.add(caseSt);
            caseBody = whenNode.getNextCase();
            caseSt = this.collectSingleNodeSafe(caseBody);
        }
        statement.setWhens(whens);
        if (caseSt != null) {
            statement.setElseWhen(caseSt);
        }
        this.states.peek().add(statement);
        return null;
    }

    private static String colons2Name(Node cpathNode) {
        String name = "";
        while (cpathNode instanceof Colon2Node) {
            Colon2Node colon2Node = (Colon2Node)cpathNode;
            if (name.length() > 0) {
                name = "::" + name;
            }
            name = String.valueOf(colon2Node.getName()) + name;
            cpathNode = colon2Node.getLeftNode();
        }
        if (cpathNode instanceof Colon3Node) {
            Colon3Node colon3Node = (Colon3Node)cpathNode;
            if (name.length() > 0) {
                name = "::" + name;
            }
            name = "::" + colon3Node.getName() + name;
        } else if (cpathNode instanceof ConstNode) {
            ConstNode constNode = (ConstNode)cpathNode;
            if (name.length() > 0) {
                name = "::" + name;
            }
            name = String.valueOf(constNode.getName()) + name;
        }
        return name;
    }

    private ISourcePosition fixNamePosition(ISourcePosition pos) {
        int start = pos.getStartOffset();
        int end = pos.getEndOffset();
        while (end - 1 >= 0 && end - 1 > start && !RubySyntaxUtils.isNameChar(this.content[end - 1])) {
            --end;
        }
        if (end >= 0) {
            while (end < this.content.length && RubySyntaxUtils.isNameChar(this.content[end])) {
                ++end;
            }
        }
        return new SourcePosition(pos.getFile(), pos.getStartLine(), pos.getEndLine(), start, end);
    }

    private ISourcePosition fixBorders(ISourcePosition pos) {
        int start = pos.getStartOffset();
        int end = pos.getEndOffset();
        while (end - 1 >= 0 && !RubySyntaxUtils.isNameChar(this.content[end - 1])) {
            --end;
        }
        if (end >= 0) {
            while (end < this.content.length && RubySyntaxUtils.isNameChar(this.content[end])) {
                ++end;
            }
        }
        return new SourcePosition(pos.getFile(), pos.getStartLine(), pos.getEndLine(), start, end);
    }

    public Instruction visitClassNode(ClassNode iVisited) {
        Colon3Node cpathNode = iVisited.getCPath();
        Node superClassNode = iVisited.getSuperNode();
        ASTNode cpath = this.collectSingleNodeSafe(cpathNode);
        ASTNode supernode = this.collectSingleNodeSafe(superClassNode);
        ISourcePosition pos = iVisited.getCPath().getPosition();
        ISourcePosition cPos = iVisited.getPosition();
        cPos = this.fixNamePosition(cPos);
        pos = this.fixNamePosition(pos);
        RubyClassDeclaration type = new RubyClassDeclaration(supernode, cpath, null, cPos.getStartOffset(), cPos.getEndOffset());
        String name = String.copyValueOf(this.content, pos.getStartOffset(), pos.getEndOffset() - pos.getStartOffset());
        type.setName(name);
        this.states.peek().add((ASTNode)type);
        this.states.push(new ClassState(type));
        Node bodyNode = iVisited.getBodyNode();
        if (bodyNode != null) {
            pos = bodyNode.getPosition();
            int end = -1;
            while (bodyNode instanceof NewlineNode) {
                bodyNode = ((NewlineNode)bodyNode).getNextNode();
            }
            if (bodyNode instanceof BlockNode) {
                BlockNode blockNode = (BlockNode)bodyNode;
                end = blockNode.getLast().getPosition().getEndOffset() + 1;
            }
            pos = this.fixBorders(pos);
            Block bl = new Block(pos.getStartOffset(), end == -1 ? pos.getEndOffset() + 1 : end);
            type.setBody(bl);
            if (bodyNode instanceof BlockNode) {
                Iterator iterator = bodyNode.childNodes().iterator();
                while (iterator.hasNext()) {
                    Node n = (Node)iterator.next();
                    n.accept(this);
                }
            } else {
                bodyNode.accept(this);
            }
        }
        this.states.pop();
        return null;
    }

    public Instruction visitColon2Node(Colon2Node iVisited) {
        CollectingState collector = new CollectingState();
        this.states.push(collector);
        if (iVisited.getLeftNode() != null) {
            iVisited.getLeftNode().accept(this);
        }
        this.states.pop();
        int start = iVisited.getPosition().getStartOffset();
        int end = iVisited.getPosition().getEndOffset();
        ASTNode left = null;
        if (collector.list.size() == 1) {
            left = (ASTNode)collector.list.get(0);
        }
        String right = iVisited.getName();
        if (left != null) {
            RubyColonExpression colon = new RubyColonExpression(right, left);
            colon.setStart(start);
            colon.setEnd(end);
            this.states.peek().add(colon);
        } else {
            ConstantReference ref = new ConstantReference(start, end, right);
            this.states.peek().add((ASTNode)ref);
        }
        return null;
    }

    public Instruction visitColon3Node(Colon3Node iVisited) {
        ISourcePosition position = iVisited.getPosition();
        RubyColonExpression colon = new RubyColonExpression(iVisited.getName(), null);
        colon.setStart(position.getStartOffset());
        colon.setEnd(position.getEndOffset());
        this.states.peek().add(colon);
        return null;
    }

    public Instruction visitConstNode(ConstNode iVisited) {
        String name = iVisited.getName();
        ISourcePosition pos = iVisited.getPosition();
        pos = this.fixBorders(pos);
        this.states.peek().add((ASTNode)new ConstantReference(pos.getStartOffset(), pos.getEndOffset(), name));
        return null;
    }

    public Instruction visitDAsgnNode(DAsgnNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        ASTNode valueNode = this.collectSingleNodeSafe(iVisited.getValueNode(), true);
        RubyDAssgnExpression e = new RubyDAssgnExpression(pos.getStartOffset(), pos.getEndOffset(), iVisited.getName(), valueNode);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitDRegxNode(DRegexpNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        List list = this.processListNode(iVisited);
        RubyDRegexpExpression ex = new RubyDRegexpExpression(pos.getStartOffset(), pos.getEndOffset());
        ex.setChilds(list);
        this.states.peek().add((ASTNode)ex);
        return null;
    }

    public Instruction visitDStrNode(DStrNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        List list = this.processListNode(iVisited);
        RubyDynamicStringExpression ex = new RubyDynamicStringExpression(pos.getStartOffset(), pos.getEndOffset());
        ex.setChilds(list);
        this.states.peek().add((ASTNode)ex);
        return null;
    }

    public Instruction visitDSymbolNode(DSymbolNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        List list = this.processListNode(iVisited);
        RubyDSymbolExpression ex = new RubyDSymbolExpression(pos.getStartOffset(), pos.getEndOffset());
        ex.setChilds(list);
        this.states.peek().add((ASTNode)ex);
        return null;
    }

    public Instruction visitDVarNode(DVarNode iVisited) {
        String name = iVisited.getName();
        ISourcePosition pos = iVisited.getPosition();
        RubyDVarExpression e = new RubyDVarExpression(pos.getStartOffset(), pos.getEndOffset(), name);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitDXStrNode(DXStrNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        List list = this.processListNode(iVisited);
        RubyDynamicBackquoteStringExpression ex = new RubyDynamicBackquoteStringExpression(pos.getStartOffset(), pos.getEndOffset());
        ex.setChilds(list);
        this.states.peek().add((ASTNode)ex);
        return null;
    }

    public Instruction visitDefinedNode(DefinedNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        ASTNode value = this.collectSingleNodeSafe(iVisited.getExpressionNode());
        RubyDefinedExpression e = new RubyDefinedExpression(pos.getStartOffset(), pos.getEndOffset(), value);
        this.states.peek().add(e);
        return null;
    }

    private List processMethodArguments(ArgsNode args) {
        BlockArgNode blockArgNode;
        RubyMethodArgument aa;
        ArrayList<RubyMethodArgument> arguments = new ArrayList<RubyMethodArgument>();
        Arity arity = args.getArity();
        int endPos = args.getPosition().getStartOffset() - 1;
        if (arity.getValue() != 0) {
            ListNode optArgs;
            ListNode argsList = args.getArgs();
            if (argsList != null) {
                Iterator i = argsList.childNodes().iterator();
                while (i.hasNext()) {
                    Node nde = (Node)i.next();
                    if (!(nde instanceof ArgumentNode)) continue;
                    ArgumentNode a = (ArgumentNode)nde;
                    RubyMethodArgument aa2 = new RubyMethodArgument();
                    ISourcePosition argPos = this.fixNamePosition(a.getPosition());
                    if (argPos.getEndOffset() > endPos) {
                        endPos = argPos.getEndOffset();
                    }
                    aa2.set(new SimpleReference(argPos.getStartOffset(), argPos.getEndOffset(), a.getName()), null);
                    aa2.setModifier(0);
                    arguments.add(aa2);
                }
            }
            if ((optArgs = args.getOptArgs()) != null) {
                Iterator iterator = optArgs.childNodes().iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    if (obj instanceof LocalAsgnNode) {
                        LocalAsgnNode a = (LocalAsgnNode)obj;
                        RubyMethodArgument aa3 = new RubyMethodArgument();
                        ISourcePosition argPos = a.getPosition();
                        if (argPos.getEndOffset() > endPos) {
                            endPos = argPos.getEndOffset();
                        }
                        CollectingState coll = new CollectingState();
                        this.states.push(coll);
                        a.getValueNode().accept(this);
                        this.states.pop();
                        ASTNode defaultVal = null;
                        if (coll.list.size() == 1) {
                            Object object = coll.list.get(0);
                            defaultVal = (ASTNode)object;
                        }
                        aa3.set(new SimpleReference(argPos.getStartOffset(), argPos.getEndOffset(), a.getName()), defaultVal);
                        aa3.setModifier(0);
                        arguments.add(aa3);
                        continue;
                    }
                    System.err.println("unknown argument type!");
                }
            }
        }
        if (args.getRestArg() >= 0) {
            int vaStart = 0;
            int vaEnd = 0;
            IState s = this.states.peek();
            if (s instanceof MethodState) {
                int bodyStart = args.getPosition().getEndOffset();
                if (endPos >= 0 && endPos < bodyStart) {
                    while (endPos < bodyStart && this.content[endPos] != '*') {
                        ++endPos;
                    }
                    if (++endPos < this.content.length) {
                        vaStart = endPos - 1;
                        while (RubySyntaxUtils.isIdentifierCharacter(this.content[endPos])) {
                            ++endPos;
                        }
                        vaEnd = endPos;
                    }
                }
            }
            aa = new RubyMethodArgument();
            aa.set(new SimpleReference(vaStart + 1, vaEnd, String.copyValueOf(this.content, vaStart, vaEnd - vaStart)), null);
            aa.setModifier(1);
            arguments.add(aa);
        }
        if ((blockArgNode = args.getBlockArgNode()) != null) {
            ISourcePosition position = this.fixNamePosition(blockArgNode.getPosition());
            String baName = String.copyValueOf(this.content, position.getStartOffset() - 1, position.getEndOffset() - (position.getStartOffset() - 1));
            aa = new RubyMethodArgument();
            aa.set(new SimpleReference(position.getStartOffset(), position.getEndOffset(), baName), null);
            aa.setModifier(2);
            arguments.add(aa);
        }
        return arguments;
    }

    private void setMethodVisibility(MethodDeclaration method, Visibility visibility) {
        if (visibility.isPrivate()) {
            ASTUtils.setVisibility(method, 16);
        }
        if (visibility.isPublic()) {
            ASTUtils.setVisibility(method, 64);
        }
        if (visibility.isProtected()) {
            ASTUtils.setVisibility(method, 32);
        }
    }

    public Instruction visitDefnNode(DefnNode iVisited) {
        ArgsNode args;
        ArgumentNode nameNode = iVisited.getNameNode();
        ISourcePosition pos = this.fixNamePosition(nameNode.getPosition());
        ISourcePosition cPos = this.fixNamePosition(iVisited.getPosition());
        MethodDeclaration method = new MethodDeclaration(iVisited.getName(), pos.getStartOffset(), pos.getEndOffset(), cPos.getStartOffset(), cPos.getEndOffset());
        this.setMethodVisibility(method, iVisited.getVisibility());
        if (this.states.isClassLikeState()) {
            ClassLikeState classState = this.states.getClassLikeState();
            ASTUtils.setVisibility(method, classState.visibility);
        }
        this.states.peek().add((ASTNode)method);
        this.states.push(new MethodState(method));
        Node bodyNode = iVisited.getBodyNode();
        if (bodyNode != null) {
            ISourcePosition bodyPos = bodyNode.getPosition();
            method.getBody().setStart(bodyPos.getStartOffset());
            method.getBody().setEnd(bodyPos.getEndOffset());
            if (bodyNode instanceof BlockNode) {
                Iterator iterator = bodyNode.childNodes().iterator();
                while (iterator.hasNext()) {
                    Node n = (Node)iterator.next();
                    n.accept(this);
                }
            } else {
                bodyNode.accept(this);
            }
        }
        if ((args = iVisited.getArgsNode()) != null) {
            List arguments = this.processMethodArguments(args);
            method.acceptArguments(arguments);
        }
        this.states.pop();
        return null;
    }

    private ISourcePosition restoreMethodNamePosition(DefsNode node, int recvEnd) {
        int nameStart;
        ISourcePosition recvPos = node.getReceiverNode().getPosition();
        int pos = recvEnd;
        if (pos >= 0) {
            while (pos < this.content.length && this.content[pos] != '.' && this.content[pos] != ':') {
                ++pos;
            }
            if (this.content[pos] == ':') {
                ++pos;
            }
        }
        if (pos >= this.content.length || pos < 0) {
            return recvPos;
        }
        int nameEnd = nameStart = RubySyntaxUtils.skipWhitespaceForward(this.content, pos + 1);
        while (RubySyntaxUtils.isIdentifierCharacter(this.content[nameEnd])) {
            ++nameEnd;
        }
        return new SourcePosition(recvPos.getFile(), recvPos.getStartLine(), recvPos.getEndLine(), nameStart, nameEnd);
    }

    public Instruction visitDefsNode(DefsNode iVisited) {
        Node bodyNode;
        ASTNode receiverExpression = null;
        Node receiverNode = iVisited.getReceiverNode();
        CollectingState collectingState = new CollectingState();
        this.states.push(collectingState);
        receiverNode.accept(this);
        this.states.pop();
        if (collectingState.list.size() == 1) {
            Object obj = collectingState.list.get(0);
            receiverExpression = (ASTNode)obj;
        }
        ISourcePosition cPos = iVisited.getPosition();
        ISourcePosition namePos = this.restoreMethodNamePosition(iVisited, receiverExpression.sourceEnd());
        String name = iVisited.getName();
        RubySingletonMethodDeclaration method = new RubySingletonMethodDeclaration(name, namePos.getStartOffset(), namePos.getEndOffset(), cPos.getStartOffset(), cPos.getEndOffset(), receiverExpression);
        method.setModifier(128);
        ASTUtils.setVisibility(method, 64);
        if (this.states.isClassLikeState()) {
            ClassLikeState classState = this.states.getClassLikeState();
            ASTUtils.setVisibility(method, classState.visibility);
        }
        this.states.peek().add((ASTNode)method);
        this.states.push(new MethodState(method));
        ArgsNode args = iVisited.getArgsNode();
        if (args != null) {
            List list = this.processMethodArguments(args);
            method.acceptArguments(list);
        }
        if ((bodyNode = iVisited.getBodyNode()) != null) {
            if (bodyNode instanceof BlockNode) {
                Iterator iterator = bodyNode.childNodes().iterator();
                while (iterator.hasNext()) {
                    Node n = (Node)iterator.next();
                    n.accept(this);
                }
            } else {
                bodyNode.accept(this);
            }
        }
        this.states.pop();
        return null;
    }

    public Instruction visitDotNode(DotNode iVisited) {
        ASTNode begin = this.collectSingleNodeSafe(iVisited.getBeginNode());
        ASTNode end = this.collectSingleNodeSafe(iVisited.getEndNode());
        ISourcePosition pos = iVisited.getPosition();
        RubyDotExpression e = new RubyDotExpression(pos.getStartOffset(), pos.getEndOffset(), begin, end);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitEnsureNode(EnsureNode iVisited) {
        ASTNode body = this.collectSingleNodeSafe(iVisited.getBodyNode());
        ASTNode ensure = this.collectSingleNodeSafe(iVisited.getEnsureNode());
        ISourcePosition pos = iVisited.getPosition();
        RubyEnsureExpression e = new RubyEnsureExpression(pos.getStartOffset(), pos.getEndOffset(), ensure, body);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitEvStrNode(EvStrNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        ASTNode body = this.collectSingleNodeSafe(iVisited.getBody());
        RubyEvaluatableStringExpression e = new RubyEvaluatableStringExpression(pos.getStartOffset(), pos.getEndOffset(), body);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitFCallNode(FCallNode iVisited) {
        String methodName = iVisited.getName();
        if (this.states.isClassLikeState()) {
            if (methodName.equals("private")) {
                this.handleVisibilitySetter(iVisited, 16);
            } else if (methodName.equals("protected")) {
                this.handleVisibilitySetter(iVisited, 32);
            } else if (methodName.equals("public")) {
                this.handleVisibilitySetter(iVisited, 64);
            }
        }
        RubyCallArgumentsList argList = new RubyCallArgumentsList();
        Node argsNode = iVisited.getArgsNode();
        if (argsNode != null) {
            this.states.push(new ArgumentsState(argList));
            if (argsNode instanceof ListNode) {
                ListNode arrayNode = (ListNode)argsNode;
                List list = arrayNode.childNodes();
                Iterator iter = list.iterator();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    node.accept(this);
                }
            } else {
                if (TRACE_RECOVERING) {
                    RubyPlugin.log("DLTKASTBuildVisitor.visitFCallNode(" + methodName + ") - unknown args node type: " + argsNode.getClass().getName());
                }
                argsNode.accept(this);
            }
            this.states.pop();
        }
        if (iVisited.getIterNode() != null) {
            ASTNode s = this.collectSingleNodeSafe(iVisited.getIterNode());
            argList.addNode(s);
        }
        argList.autosetOffsets();
        CallExpression c = new CallExpression(null, methodName, (CallArgumentsList)argList);
        int funcNameStart = iVisited.getPosition().getStartOffset();
        c.setStart(funcNameStart);
        this.fixFunctionCallOffsets(c, methodName, funcNameStart, argList.sourceStart(), argList.sourceEnd());
        this.states.peek().add((ASTNode)c);
        return null;
    }

    private void handleVisibilitySetter(FCallNode node, int newVisibility) {
        if (this.states.isClassLikeState()) {
            ClassLikeState classState = this.states.getClassLikeState();
            Node argsNode = node.getArgsNode();
            if (argsNode instanceof ArrayNode) {
                ArrayNode argsArrayNode = (ArrayNode)argsNode;
                List args = argsArrayNode.childNodes();
                Iterator iter = args.iterator();
                while (iter.hasNext()) {
                    Node arg = (Node)iter.next();
                    if (!(arg instanceof SymbolNode)) continue;
                    SymbolNode symbolNode = (SymbolNode)arg;
                    String xmethodName = symbolNode.getName();
                    List statements = classState.type.getStatements();
                    Iterator statIter = statements.iterator();
                    while (statIter.hasNext()) {
                        MethodDeclaration methodDeclaration;
                        ASTNode statement = (ASTNode)statIter.next();
                        if (!(statement instanceof MethodDeclaration) || !(methodDeclaration = (MethodDeclaration)statement).getName().equals(xmethodName)) continue;
                        ASTUtils.setVisibility(methodDeclaration, newVisibility);
                    }
                }
            }
        }
    }

    public Instruction visitFalseNode(FalseNode iVisited) {
        ISourcePosition position = iVisited.getPosition();
        this.states.peek().add((ASTNode)new BooleanLiteral(position.getStartOffset(), position.getEndOffset(), false));
        return null;
    }

    public Instruction visitFlipNode(FlipNode iVisited) {
        return null;
    }

    public Instruction visitForNode(ForNode iVisited) {
        ASTNode listNode;
        ASTNode varNode = this.collectSingleNodeSafe(iVisited.getVarNode());
        ASTNode listSt = this.collectSingleNodeSafe(iVisited.getIterNode());
        if (!(listSt instanceof ASTListNode)) {
            ASTListNode list = new ASTListNode();
            list.addNode(listSt);
            listNode = list;
        } else {
            listNode = listSt;
        }
        ASTNode bodyNode = this.collectSingleNodeSafe(iVisited.getBodyNode());
        ISourcePosition pos = iVisited.getPosition();
        RubyForStatement2 statement = new RubyForStatement2(pos.getStartOffset(), pos.getEndOffset(), varNode, (ASTListNode)listNode, bodyNode);
        this.states.peek().add(statement);
        return null;
    }

    public Instruction visitGlobalAsgnNode(GlobalAsgnNode iVisited) {
        this.processVariableAssignment(iVisited, iVisited.getName(), RubyVariableKind.GLOBAL, iVisited.getValueNode());
        return null;
    }

    public Instruction visitGlobalVarNode(GlobalVarNode iVisited) {
        this.processVariableReference(iVisited, iVisited.getName(), RubyVariableKind.GLOBAL);
        return null;
    }

    public Instruction visitHashNode(HashNode iVisited) {
        ListNode listNode = iVisited.getListNode();
        List exprs = this.processListNode(listNode);
        ISourcePosition position = iVisited.getPosition();
        RubyHashExpression arr = new RubyHashExpression();
        arr.setStart(position.getStartOffset());
        arr.setEnd(position.getEndOffset());
        if (arr.sourceEnd() == arr.sourceStart() && listNode != null) {
            arr.setStart(listNode.getPosition().getStartOffset());
            arr.setEnd(listNode.getPosition().getEndOffset());
        }
        ArrayList<RubyHashPairExpression> hashPairs = new ArrayList<RubyHashPairExpression>();
        if (exprs.size() % 2 == 0) {
            Iterator i = exprs.iterator();
            while (i.hasNext()) {
                ASTNode key = (ASTNode)i.next();
                ASTNode value = (ASTNode)i.next();
                RubyHashPairExpression e = new RubyHashPairExpression(key.sourceStart(), value.sourceEnd(), key, value);
                hashPairs.add(e);
            }
        } else if (!JRubySourceParser.isSilentState()) {
            throw new RuntimeException("visitHashNode(): Unpaired hash!");
        }
        arr.setChilds(hashPairs);
        this.states.peek().add((ASTNode)arr);
        return null;
    }

    public Instruction visitInstAsgnNode(InstAsgnNode iVisited) {
        this.processVariableAssignment(iVisited, iVisited.getName(), RubyVariableKind.INSTANCE, iVisited.getValueNode());
        return null;
    }

    public Instruction visitInstVarNode(InstVarNode iVisited) {
        this.processVariableReference(iVisited, iVisited.getName(), RubyVariableKind.INSTANCE);
        return null;
    }

    public Instruction visitIfNode(IfNode iVisited) {
        ASTNode condition = this.collectSingleNodeSafe(iVisited.getCondition());
        ASTNode thenPart = this.collectSingleNodeSafe(iVisited.getThenBody());
        ASTNode elsePart = this.collectSingleNodeSafe(iVisited.getElseBody());
        RubyIfStatement res = new RubyIfStatement(condition, thenPart, elsePart);
        res.setStart(iVisited.getPosition().getStartOffset());
        res.setEnd(iVisited.getPosition().getEndOffset() + 1);
        this.states.peek().add(res);
        return null;
    }

    public Instruction visitIterNode(IterNode iVisited) {
        ASTNode bodyNode = this.collectSingleNodeSafe(iVisited.getBodyNode());
        ASTNode varNode = this.collectSingleNodeSafe(iVisited.getVarNode());
        ISourcePosition pos = iVisited.getPosition();
        RubyBlock block = new RubyBlock(pos.getStartOffset(), pos.getEndOffset(), bodyNode);
        block.addVar(varNode);
        this.states.peek().add(block);
        return null;
    }

    public Instruction visitLocalAsgnNode(LocalAsgnNode iVisited) {
        this.processVariableAssignment(iVisited, iVisited.getName(), RubyVariableKind.LOCAL, iVisited.getValueNode());
        return null;
    }

    private void processVariableAssignment(Node iVisited, String name, RubyVariableKind varKind, Node valueNode) {
        ISourcePosition pos = iVisited.getPosition();
        VariableReference left = new VariableReference(pos.getStartOffset(), pos.getStartOffset() + name.length(), name, (VariableKind)varKind);
        ASTNode right = this.collectSingleNodeSafe(valueNode);
        RubyAssignment assgn = new RubyAssignment((ASTNode)left, right);
        this.copyOffsets(assgn, iVisited);
        this.states.peek().add(assgn);
    }

    public Instruction visitLocalVarNode(LocalVarNode iVisited) {
        ISourcePosition pos = this.fixNamePosition(iVisited.getPosition());
        String varName = String.copyValueOf(this.content, pos.getStartOffset(), pos.getEndOffset() - pos.getStartOffset());
        this.processVariableReference(iVisited, varName, RubyVariableKind.LOCAL);
        return null;
    }

    private void processVariableReference(Node iVisited, String varName, RubyVariableKind varKind) {
        ISourcePosition pos2 = this.fixNamePosition(iVisited.getPosition());
        if (varName.endsWith("\r")) {
            varName = varName.substring(0, varName.length() - 1);
        }
        VariableReference node = new VariableReference(pos2.getStartOffset(), pos2.getEndOffset(), varName, (VariableKind)varKind);
        this.states.peek().add((ASTNode)node);
    }

    private void copyOffsets(ASTNode target, Node source) {
        ISourcePosition pos = source.getPosition();
        target.setStart(pos.getStartOffset());
        target.setEnd(pos.getEndOffset());
    }

    public Instruction visitMultipleAsgnNode(MultipleAsgnNode iVisited) {
        Node valueNode;
        Node argsNode;
        ISourcePosition pos = iVisited.getPosition();
        RubyMultipleAssignmentStatement s = new RubyMultipleAssignmentStatement(pos.getStartOffset(), pos.getEndOffset());
        ListNode headNode = iVisited.getHeadNode();
        if (headNode != null) {
            Iterator iterator = headNode.childNodes().iterator();
            while (iterator.hasNext()) {
                Node n = (Node)iterator.next();
                if (n instanceof LocalAsgnNode && ((LocalAsgnNode)n).getValueNode() == null) {
                    String name = ((LocalAsgnNode)n).getName();
                    ISourcePosition nPos = n.getPosition();
                    s.addLhs((ASTNode)new VariableReference(nPos.getStartOffset(), nPos.getEndOffset(), name, (VariableKind)RubyVariableKind.LOCAL));
                    continue;
                }
                ASTNode ss = this.collectSingleNodeSafe(n);
                s.addLhs(ss);
            }
        }
        if ((argsNode = iVisited.getArgsNode()) != null) {
            s.setLeftAsterix(this.collectSingleNodeSafe(argsNode), argsNode.getPosition().getStartOffset());
        }
        if ((valueNode = iVisited.getValueNode()) instanceof ArgsCatNode) {
            ArgsCatNode argsCatNode = (ArgsCatNode)valueNode;
            Node firstNode = argsCatNode.getFirstNode();
            if (firstNode instanceof ListNode) {
                ListNode list = (ListNode)firstNode;
                Iterator iterator = list.childNodes().iterator();
                while (iterator.hasNext()) {
                    Node nd = (Node)iterator.next();
                    s.addRhs(this.collectSingleNodeSafe(nd));
                }
            } else if (firstNode != null) {
                s.addRhs(this.collectSingleNodeSafe(firstNode));
            }
            Node secondNode = argsCatNode.getSecondNode();
            if (secondNode != null) {
                s.setRightAsterix(this.collectSingleNodeSafe(secondNode));
            }
        } else if (valueNode instanceof ListNode) {
            ListNode list = (ListNode)valueNode;
            Iterator iterator = list.childNodes().iterator();
            while (iterator.hasNext()) {
                Node nd = (Node)iterator.next();
                s.addRhs(this.collectSingleNodeSafe(nd));
            }
        } else if (valueNode != null) {
            s.addRhs(this.collectSingleNodeSafe(valueNode));
        }
        this.states.peek().add(s);
        return null;
    }

    public Instruction visitMatch2Node(Match2Node iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        ASTNode receiverNode = this.collectSingleNodeSafe(iVisited.getReceiverNode());
        ASTNode valueNode = this.collectSingleNodeSafe(iVisited.getValueNode());
        RubyMatch2Expression e = new RubyMatch2Expression(pos.getStartOffset(), pos.getEndOffset(), receiverNode, valueNode);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitMatch3Node(Match3Node iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        ASTNode receiverNode = this.collectSingleNodeSafe(iVisited.getReceiverNode());
        ASTNode valueNode = this.collectSingleNodeSafe(iVisited.getValueNode());
        RubyMatch3Expression e = new RubyMatch3Expression(pos.getStartOffset(), pos.getEndOffset(), receiverNode, valueNode);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitMatchNode(MatchNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        ASTNode regexp = this.collectSingleNodeSafe(iVisited.getRegexpNode());
        RubyMatchExpression e = new RubyMatchExpression(pos.getStartOffset(), pos.getEndOffset(), regexp);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitModuleNode(ModuleNode iVisited) {
        String name = "";
        Colon3Node cpathNode = iVisited.getCPath();
        if (cpathNode instanceof Colon2Node || cpathNode instanceof ConstNode) {
            name = RubyASTBuildVisitor.colons2Name(cpathNode);
        }
        ISourcePosition pos = iVisited.getCPath().getPosition();
        ISourcePosition cPos = iVisited.getPosition();
        cPos = this.fixNamePosition(cPos);
        pos = this.fixNamePosition(pos);
        TypeDeclaration type = new TypeDeclaration(name, pos.getStartOffset(), pos.getEndOffset(), cPos.getStartOffset(), cPos.getEndOffset());
        type.setModifier(1024);
        this.states.peek().add((ASTNode)type);
        this.states.push(new ModuleState(type));
        Node bodyNode = iVisited.getBodyNode();
        if (bodyNode != null) {
            pos = bodyNode.getPosition();
            int end = -1;
            while (bodyNode instanceof NewlineNode) {
                bodyNode = ((NewlineNode)bodyNode).getNextNode();
            }
            if (bodyNode instanceof BlockNode) {
                BlockNode blockNode = (BlockNode)bodyNode;
                end = blockNode.getLast().getPosition().getEndOffset();
            } else if (TRACE_RECOVERING) {
                RubyPlugin.log("DLTKASTBuildVisitor.visitModuleNode(" + name + "): unknown body type " + bodyNode.getClass().getName());
            }
            pos = this.fixBorders(pos);
            Block bl = new Block(pos.getStartOffset(), end == -1 ? pos.getEndOffset() : end);
            type.setBody(bl);
            bodyNode.accept(this);
        }
        this.states.pop();
        return null;
    }

    public Instruction visitNewlineNode(NewlineNode iVisited) {
        iVisited.getNextNode().accept(this);
        return null;
    }

    public Instruction visitNextNode(NextNode iVisited) {
        ISourcePosition position = iVisited.getPosition();
        RubyCallArgumentsList args = new RubyCallArgumentsList();
        Node valueNode = iVisited.getValueNode();
        if (valueNode != null) {
            ASTNode s = this.collectSingleNodeSafe(valueNode);
            args.addArgument(s, 0);
        }
        this.states.peek().add((ASTNode)new RubyNextExpression(position.getStartOffset(), position.getEndOffset(), args));
        return null;
    }

    public Instruction visitNilNode(NilNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        this.states.peek().add((ASTNode)new NilLiteral(pos.getStartOffset(), pos.getEndOffset()));
        return null;
    }

    public Instruction visitNotNode(NotNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        ASTNode expr = this.collectSingleNodeSafe(iVisited.getConditionNode());
        RubyNotExpression e = new RubyNotExpression(pos.getStartOffset(), pos.getEndOffset(), expr);
        this.states.peek().add(e);
        return null;
    }

    public Instruction visitNthRefNode(NthRefNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        this.states.peek().add((ASTNode)new VariableReference(pos.getStartOffset(), pos.getEndOffset(), "$" + iVisited.getMatchNumber(), (VariableKind)RubyVariableKind.GLOBAL));
        return null;
    }

    public Instruction visitOpElementAsgnNode(OpElementAsgnNode iVisited) {
        return null;
    }

    public Instruction visitOpAsgnNode(OpAsgnNode iVisited) {
        return null;
    }

    public Instruction visitOpAsgnAndNode(OpAsgnAndNode iVisited) {
        return null;
    }

    public Instruction visitOpAsgnOrNode(OpAsgnOrNode iVisited) {
        return null;
    }

    public Instruction visitOptNNode(OptNNode iVisited) {
        iVisited.getBodyNode().accept(this);
        return null;
    }

    public Instruction visitOrNode(OrNode iVisited) {
        ASTNode leftSt = this.collectSingleNodeSafe(iVisited.getFirstNode());
        ASTNode rightSt = this.collectSingleNodeSafe(iVisited.getSecondNode());
        RubyBinaryExpression b = new RubyBinaryExpression(leftSt, 1006, rightSt);
        this.states.peek().add(b);
        return null;
    }

    public Instruction visitPostExeNode(PostExeNode iVisited) {
        return null;
    }

    public Instruction visitRedoNode(RedoNode iVisited) {
        ISourcePosition position = iVisited.getPosition();
        this.states.peek().add((ASTNode)new RubyRedoExpression(position.getStartOffset(), position.getEndOffset()));
        return null;
    }

    public Instruction visitRescueBodyNode(RescueBodyNode iVisited) {
        ASTNode bodyNode = this.collectSingleNodeSafe(iVisited.getBodyNode());
        ASTNode exceptionNodes = this.collectSingleNodeSafe(iVisited.getExceptionNodes());
        RubyRescueBodyStatement optRescueNode = (RubyRescueBodyStatement)this.collectSingleNodeSafe(iVisited.getOptRescueNode());
        ISourcePosition pos = iVisited.getPosition();
        RubyRescueBodyStatement rescueStatement = new RubyRescueBodyStatement(pos.getStartOffset(), pos.getEndOffset(), bodyNode, exceptionNodes, optRescueNode);
        this.states.peek().add(rescueStatement);
        return null;
    }

    public Instruction visitRescueNode(RescueNode iVisited) {
        ASTNode bodyNode = this.collectSingleNodeSafe(iVisited.getBodyNode());
        ASTNode elseNode = this.collectSingleNodeSafe(iVisited.getElseNode());
        RubyRescueBodyStatement rescueNode = (RubyRescueBodyStatement)this.collectSingleNodeSafe(iVisited.getRescueNode());
        ISourcePosition pos = iVisited.getPosition();
        RubyRescueStatement rescueStatement = new RubyRescueStatement(pos.getStartOffset(), pos.getEndOffset(), bodyNode, elseNode, rescueNode);
        this.states.peek().add(rescueStatement);
        return null;
    }

    public Instruction visitRetryNode(RetryNode iVisited) {
        ISourcePosition position = iVisited.getPosition();
        this.states.peek().add((ASTNode)new RubyRetryExpression(position.getStartOffset(), position.getEndOffset()));
        return null;
    }

    public Instruction visitReturnNode(ReturnNode iVisited) {
        ISourcePosition position = iVisited.getPosition();
        ASTNode value = null;
        if (iVisited.getValueNode() != null) {
            value = this.collectSingleNodeSafe(iVisited.getValueNode());
        }
        RubyCallArgumentsList list = new RubyCallArgumentsList();
        if (value != null) {
            list.addArgument(value, 0);
        }
        this.states.peek().add(new RubyReturnStatement(list, position.getStartOffset(), position.getEndOffset()));
        return null;
    }

    public Instruction visitSClassNode(SClassNode iVisited) {
        String name = "";
        Node receiver = iVisited.getReceiverNode();
        if (receiver instanceof ConstNode) {
            name = "<< " + ((ConstNode)iVisited.getReceiverNode()).getName();
        } else if (receiver instanceof SelfNode) {
            name = "<< self";
        } else {
            int startOffset = receiver.getPosition().getStartOffset();
            int endOffset = receiver.getPosition().getEndOffset();
            name = "<< " + new String(String.copyValueOf(this.content, startOffset, endOffset - startOffset)).trim();
        }
        ISourcePosition pos = iVisited.getReceiverNode().getPosition();
        ISourcePosition cPos = iVisited.getPosition();
        RubySingletonClassDeclaration type = new RubySingletonClassDeclaration(name, pos.getStartOffset(), pos.getEndOffset(), cPos.getStartOffset(), cPos.getEndOffset());
        this.states.peek().add((ASTNode)type);
        CollectingState coll = new CollectingState();
        this.states.push(coll);
        receiver.accept(this);
        this.states.pop();
        if (coll.list.size() == 1 && coll.list.get(0) instanceof ASTNode) {
            Object obj = coll.list.get(0);
            type.setReceiver((ASTNode)obj);
            if (obj instanceof SimpleReference) {
                SimpleReference reference = (SimpleReference)obj;
                type.setName("<< " + reference.getName());
            }
        }
        this.states.push(new ClassState(type));
        Node bodyNode = iVisited.getBodyNode();
        if (bodyNode != null) {
            pos = bodyNode.getPosition();
            Block bl = new Block(pos.getStartOffset(), pos.getEndOffset() + 1);
            type.setBody(bl);
            bodyNode.accept(this);
        }
        this.states.pop();
        return null;
    }

    public Instruction visitSelfNode(SelfNode iVisited) {
        ISourcePosition position = this.fixNamePosition(iVisited.getPosition());
        this.states.peek().add((ASTNode)new RubySelfReference(position.getStartOffset(), position.getEndOffset()));
        return null;
    }

    public Instruction visitSplatNode(SplatNode iVisited) {
        Iterator iterator = iVisited.childNodes().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).accept(this);
        }
        return null;
    }

    public Instruction visitStrNode(StrNode iVisited) {
        String value = iVisited.getValue().toString();
        ISourcePosition position = iVisited.getPosition();
        if (value.length() == 0) {
            value = String.copyValueOf(this.content, position.getStartOffset(), position.getEndOffset() - position.getStartOffset());
        }
        this.states.peek().add((ASTNode)new StringLiteral(position.getStartOffset(), position.getEndOffset(), value));
        return null;
    }

    public Instruction visitSValueNode(SValueNode iVisited) {
        Iterator iterator = iVisited.childNodes().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).accept(this);
        }
        return null;
    }

    private CallArgumentsList processCallArguments(Node argsNode) {
        RubyCallArgumentsList argList = new RubyCallArgumentsList();
        this.states.push(new ArgumentsState(argList));
        if (argsNode instanceof ListNode) {
            ListNode arrayNode = (ListNode)argsNode;
            List list = arrayNode.childNodes();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                Node node = (Node)iter.next();
                node.accept(this);
            }
        } else if (argsNode instanceof ArgsCatNode) {
            ASTNode e;
            ArgsCatNode argsCatNode = (ArgsCatNode)argsNode;
            CallArgumentsList first = this.processCallArguments(argsCatNode.getFirstNode());
            CallArgumentsList second = this.processCallArguments(argsCatNode.getSecondNode());
            Iterator iterator = first.getChilds().iterator();
            while (iterator.hasNext()) {
                e = (ASTNode)iterator.next();
                argList.addNode(e);
            }
            iterator = second.getChilds().iterator();
            while (iterator.hasNext()) {
                e = (ASTNode)iterator.next();
                argList.addNode(e);
            }
        } else if (argsNode != null) {
            argsNode.accept(this);
        }
        this.states.pop();
        return argList;
    }

    public Instruction visitSuperNode(SuperNode iVisited) {
        Node argsNode = iVisited.getArgsNode();
        CallArgumentsList callArguments = this.processCallArguments(argsNode);
        Node iterNode = iVisited.getIterNode();
        ASTNode block = this.collectSingleNodeSafe(iterNode);
        ISourcePosition pos = iVisited.getPosition();
        RubySuperExpression expr = new RubySuperExpression(pos.getStartOffset(), pos.getEndOffset(), callArguments, block);
        this.states.peek().add(expr);
        return null;
    }

    public Instruction visitToAryNode(ToAryNode iVisited) {
        Iterator iterator = iVisited.childNodes().iterator();
        while (iterator.hasNext()) {
            ((Node)iterator.next()).accept(this);
        }
        return null;
    }

    public Instruction visitTrueNode(TrueNode iVisited) {
        ISourcePosition position = iVisited.getPosition();
        this.states.peek().add((ASTNode)new BooleanLiteral(position.getStartOffset(), position.getEndOffset(), true));
        return null;
    }

    public Instruction visitUndefNode(UndefNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        RubyUndefStatement s = new RubyUndefStatement(pos.getStartOffset(), pos.getEndOffset());
        this.states.peek().add(s);
        return null;
    }

    public Instruction visitUntilNode(UntilNode iVisited) {
        ASTNode condition = this.collectSingleNodeSafe(iVisited.getConditionNode());
        ASTNode body = this.collectSingleNodeSafe(iVisited.getBodyNode());
        ISourcePosition pos = iVisited.getPosition();
        RubyUntilStatement st = new RubyUntilStatement(condition, body);
        st.setStart(pos.getStartOffset());
        st.setEnd(pos.getEndOffset());
        this.states.peek().add(st);
        return null;
    }

    public Instruction visitVAliasNode(VAliasNode iVisited) {
        return null;
    }

    public Instruction visitVCallNode(VCallNode iVisited) {
        String methodName = iVisited.getName();
        if (this.states.isClassLikeState()) {
            ClassLikeState classState = this.states.getClassLikeState();
            if (methodName.equals("private")) {
                classState.visibility = 16;
            } else if (methodName.equals("protected")) {
                classState.visibility = 32;
            } else if (methodName.equals("public")) {
                classState.visibility = 64;
            }
        }
        ISourcePosition pos = iVisited.getPosition();
        int funcNameStart = pos.getStartOffset();
        CallExpression c = new CallExpression(null, methodName, CallArgumentsList.EMPTY);
        c.setStart(funcNameStart);
        c.setEnd(funcNameStart + methodName.length());
        this.states.peek().add((ASTNode)c);
        return null;
    }

    public Instruction visitWhenNode(WhenNode iVisited) {
        ISourcePosition position = iVisited.getPosition();
        RubyWhenStatement statement = new RubyWhenStatement(position.getStartOffset(), position.getEndOffset());
        ASTNode bodyStatement = this.collectSingleNodeSafe(iVisited.getBodyNode());
        ASTNode expressionsStatement = this.collectSingleNodeSafe(iVisited.getExpressionNodes());
        statement.setBody(bodyStatement);
        if (expressionsStatement instanceof ASTListNode) {
            ASTListNode list = (ASTListNode)expressionsStatement;
            statement.setExpressions(list.getChilds());
        } else if (expressionsStatement instanceof ASTNode) {
            ArrayList<ASTNode> list = new ArrayList<ASTNode>(1);
            list.add(expressionsStatement);
            statement.setExpressions(list);
        }
        this.states.peek().add(statement);
        return null;
    }

    public Instruction visitWhileNode(WhileNode iVisited) {
        ASTNode condition = this.collectSingleNodeSafe(iVisited.getConditionNode());
        ASTNode body = this.collectSingleNodeSafe(iVisited.getBodyNode());
        ISourcePosition pos = iVisited.getPosition();
        RubyWhileStatement st = new RubyWhileStatement(condition, body);
        st.setStart(pos.getStartOffset());
        st.setEnd(pos.getEndOffset());
        this.states.peek().add(st);
        return null;
    }

    public Instruction visitXStrNode(XStrNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        String value = iVisited.getValue().toString();
        RubyBacktickStringLiteral s = new RubyBacktickStringLiteral(pos.getStartOffset(), pos.getEndOffset(), value);
        this.states.peek().add((ASTNode)s);
        return null;
    }

    public Instruction visitYieldNode(YieldNode iVisited) {
        ISourcePosition position = iVisited.getPosition();
        RubyCallArgumentsList args = new RubyCallArgumentsList();
        Node valueNode = iVisited.getArgsNode();
        if (valueNode != null) {
            ASTNode s = this.collectSingleNodeSafe(valueNode);
            args.addArgument(s, 0);
        }
        this.states.peek().add((ASTNode)new RubyYieldExpression(position.getStartOffset(), position.getEndOffset(), args));
        return null;
    }

    public Instruction visitZArrayNode(ZArrayNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        RubyArrayExpression arr = new RubyArrayExpression();
        arr.setStart(pos.getStartOffset());
        arr.setEnd(pos.getEndOffset());
        this.states.peek().add((ASTNode)arr);
        return null;
    }

    public Instruction visitZSuperNode(ZSuperNode iVisited) {
        CallArgumentsList callArguments = new CallArgumentsList();
        Node iterNode = iVisited.getIterNode();
        ASTNode block = this.collectSingleNodeSafe(iterNode);
        ISourcePosition pos = iVisited.getPosition();
        RubySuperExpression expr = new RubySuperExpression(pos.getStartOffset(), pos.getEndOffset(), callArguments, block);
        this.states.peek().add(expr);
        return null;
    }

    public Instruction visitBignumNode(BignumNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        BigInteger value = iVisited.getValue();
        BigNumericLiteral literal = new BigNumericLiteral(pos.getStartOffset(), pos.getEndOffset(), value);
        this.states.peek().add((ASTNode)literal);
        return null;
    }

    public Instruction visitFixnumNode(FixnumNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        NumericLiteral node = new NumericLiteral(pos.getStartOffset(), pos.getEndOffset(), iVisited.getValue());
        this.states.peek().add((ASTNode)node);
        return null;
    }

    public Instruction visitFloatNode(FloatNode iVisited) {
        ISourcePosition pos = iVisited.getPosition();
        double value = iVisited.getValue();
        FloatNumericLiteral num = new FloatNumericLiteral(pos.getStartOffset(), pos.getEndOffset(), value);
        this.states.peek().add((ASTNode)num);
        return null;
    }

    public Instruction visitRegexpNode(RegexpNode iVisited) {
        Pattern pattern = iVisited.getPattern();
        ISourcePosition position = iVisited.getPosition();
        String value = iVisited.getValue().toString();
        RubyRegexpExpression e = new RubyRegexpExpression(position.getStartOffset(), position.getEndOffset(), value);
        e.setPattern(pattern);
        this.states.peek().add((ASTNode)e);
        return null;
    }

    public Instruction visitSymbolNode(SymbolNode iVisited) {
        ISourcePosition position = iVisited.getPosition();
        RubySymbolReference sr = new RubySymbolReference(position.getStartOffset(), position.getEndOffset(), iVisited.getName());
        this.states.peek().add((ASTNode)sr);
        return null;
    }

    public Instruction visitArgsPushNode(ArgsPushNode arg0) {
        return null;
    }

    public Instruction visitAttrAssignNode(AttrAssignNode arg0) {
        ASTNode receiver = this.collectSingleNodeSafe(arg0.getReceiverNode());
        CallArgumentsList list = this.processCallArguments(arg0.getArgsNode());
        CallExpression expr = new CallExpression(receiver, arg0.getName(), list);
        this.copyOffsets((ASTNode)expr, arg0);
        this.states.peek().add((ASTNode)expr);
        return null;
    }

    public Instruction visitRootNode(RootNode arg0) {
        Node bodyNode = arg0.getBodyNode();
        if (bodyNode instanceof BlockNode) {
            BlockNode blockNode = (BlockNode)bodyNode;
            Iterator iterator = blockNode.childNodes().iterator();
            while (iterator.hasNext()) {
                ((Node)iterator.next()).accept(this);
            }
        } else if (bodyNode != null) {
            bodyNode.accept(this);
        }
        return null;
    }

    protected static class ArgumentsState
    implements IState {
        private final RubyCallArgumentsList list;

        public ArgumentsState(RubyCallArgumentsList list) {
            this.list = list;
        }

        public void add(ASTNode s) {
            this.list.addArgument(s, 0);
        }
    }

    protected static class BlockState
    implements IState {
        public final Block block;

        public BlockState(Block block) {
            this.block = block;
        }

        public void add(ASTNode statement) {
            this.block.getStatements().add(statement);
        }
    }

    protected static abstract class ClassLikeState
    implements IState {
        public int visibility;
        public final TypeDeclaration type;

        public ClassLikeState(TypeDeclaration type) {
            this.type = type;
            this.visibility = 64;
        }

        public void add(ASTNode statement) {
            this.type.getStatements().add(statement);
        }
    }

    protected static class ClassState
    extends ClassLikeState {
        public ClassState(TypeDeclaration type) {
            super(type);
        }
    }

    protected static class CollectingState
    implements IState {
        private final ArrayList list = new ArrayList();

        public void add(ASTNode s) {
            this.list.add(s);
        }

        public ArrayList getList() {
            return this.list;
        }

        public void reset() {
            this.list.clear();
        }
    }

    protected static interface IState {
        public void add(ASTNode var1);
    }

    protected static class MethodState
    implements IState {
        private final MethodDeclaration method;

        public MethodState(MethodDeclaration method) {
            this.method = method;
        }

        public void add(ASTNode statement) {
            this.method.getStatements().add(statement);
        }
    }

    protected static class ModuleState
    extends ClassLikeState {
        public ModuleState(TypeDeclaration type) {
            super(type);
        }
    }

    private static class StateManager {
        private LinkedList states = new LinkedList();

        private StateManager() {
        }

        public IState peek() {
            return (IState)this.states.getLast();
        }

        public void pop() {
            this.states.removeLast();
        }

        public void push(IState state) {
            this.states.add(state);
        }

        public boolean isClassLikeState() {
            IState state = this.peek();
            if (state instanceof ClassLikeState) {
                return true;
            }
            if (state instanceof BlockState && this.states.size() > 1) {
                return this.states.get(1) instanceof ClassLikeState;
            }
            return false;
        }

        public ClassLikeState getClassLikeState() {
            Object blocksDeclaringState;
            IState state = this.peek();
            if (state instanceof ClassLikeState) {
                return (ClassLikeState)state;
            }
            if (state instanceof BlockState && this.states.size() > 1 && (blocksDeclaringState = this.states.get(1)) instanceof ClassLikeState) {
                return (ClassLikeState)blocksDeclaringState;
            }
            return null;
        }
    }

    protected static class TopLevelState
    implements IState {
        private final ModuleDeclaration module;

        public TopLevelState(ModuleDeclaration module) {
            this.module = module;
        }

        public void add(ASTNode statement) {
            this.module.getStatements().add(statement);
        }
    }
}

