/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.tclchecker;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class TclCheckerProblemDescription {
    private static final String MESSAGE_PROPERTIES = "tclchecker.properties";
    private static final String TYPE_POSTFIX = "_type";
    private static final String EXPLANATION_POSTFIX = "_explanation";
    public static final int ERROR = 0;
    private static final String ERROR_STR = "error";
    public static final int UPGRADE_ERROR = 1;
    private static final String UPGRADE_ERROR_STR = "upgrade error";
    public static final int WARNING = 2;
    private static final String WARNING_STR = "warning";
    public static final int NON_PORTABLE_WARNING = 3;
    private static final String NON_PORTABLE_WARNING_STR = "non-portable warning";
    public static final int UPGRADE_WARNING = 4;
    private static final String UPGRADE_WARNING_STR = "upgrade warning";
    public static final int PERFORMANCE_WARNING = 5;
    private static final String PERFORMANCE_WARNING_STR = "performance warning";
    public static final int USAGE_WARNING = 6;
    private static final String USAGE_WARNING_STR = "usage warning";
    private static Properties props;
    private int category;
    private String message;
    private String explanation;

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 65->71)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean isError(int category) {
        return category == 0 || category == 1;
    }

    public static boolean isWarning(int category) {
        return !TclCheckerProblemDescription.isError(category);
    }

    public static List getProblemIdentifiers() {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<Object> it = props.keySet().iterator();
        while (it.hasNext()) {
            String s = (String)it.next();
            int index = s.indexOf(TYPE_POSTFIX);
            if (index == -1) continue;
            list.add(s.substring(0, index));
        }
        return list;
    }

    public static String getProblemType(String messageId) {
        return props.getProperty(String.valueOf(messageId) + TYPE_POSTFIX);
    }

    public static String getProblemExplanation(String messageId) {
        return props.getProperty(String.valueOf(messageId) + EXPLANATION_POSTFIX);
    }

    public static int matchProblemCategory(String type) {
        if (type.equalsIgnoreCase(ERROR_STR)) {
            return 0;
        }
        if (type.equalsIgnoreCase(UPGRADE_ERROR_STR)) {
            return 1;
        }
        if (type.equalsIgnoreCase(WARNING_STR)) {
            return 2;
        }
        if (type.equalsIgnoreCase(NON_PORTABLE_WARNING_STR)) {
            return 3;
        }
        if (type.equalsIgnoreCase(UPGRADE_WARNING_STR)) {
            return 4;
        }
        if (type.equalsIgnoreCase(PERFORMANCE_WARNING_STR)) {
            return 5;
        }
        if (type.equalsIgnoreCase(USAGE_WARNING_STR)) {
            return 6;
        }
        return -1;
    }

    public static TclCheckerProblemDescription getProblemDescription(String messageId, String message) {
        int category = 0;
        String explanation = "";
        String type = TclCheckerProblemDescription.getProblemType(messageId);
        if (type == null) {
            if (messageId.indexOf("warn") != -1) {
                category = 2;
            }
        } else {
            category = TclCheckerProblemDescription.matchProblemCategory(type);
            explanation = TclCheckerProblemDescription.getProblemExplanation(messageId);
        }
        return new TclCheckerProblemDescription(category, message, explanation);
    }

    protected TclCheckerProblemDescription(int category, String message, String explanation) {
        this.category = category;
        this.message = message;
        this.explanation = explanation;
    }

    public int getCategory() {
        return this.category;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getMessage() {
        return this.message;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.category;
        result = 31 * result + (this.explanation == null ? 0 : this.explanation.hashCode());
        result = 31 * result + (this.message == null ? 0 : this.message.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TclCheckerProblemDescription other = (TclCheckerProblemDescription)obj;
        if (this.category != other.category) {
            return false;
        }
        if (this.explanation == null ? other.explanation != null : !this.explanation.equals(other.explanation)) {
            return false;
        }
        return !(this.message == null ? other.message != null : !this.message.equals(other.message));
    }
}

