/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.parser.mixin;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.dltk.ruby.internal.parser.mixin.IRubyMixinElement;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinVariable;

public class RubyObjectMixinClass
extends RubyMixinClass {
    public RubyObjectMixinClass(RubyMixinModel model, boolean meta) {
        super(model, "Object" + (meta ? "" : "%"), false);
    }

    public RubyMixinMethod[] findMethods(String prefix, boolean includeTopLevel) {
        ArrayList<IRubyMixinElement> mixinResult = new ArrayList<IRubyMixinElement>();
        if (includeTopLevel && prefix.length() > 0) {
            String[] keys = this.model.getRawModel().findKeys(String.valueOf(prefix) + "*");
            int i = 0;
            while (i < keys.length) {
                IRubyMixinElement createdRubyElement = this.model.createRubyElement(keys[i]);
                if (createdRubyElement instanceof RubyMixinMethod) {
                    mixinResult.add(createdRubyElement);
                }
                ++i;
            }
        }
        RubyMixinMethod[] methods = super.findMethods(prefix, false);
        mixinResult.addAll(Arrays.asList(methods));
        return mixinResult.toArray(new RubyMixinMethod[mixinResult.size()]);
    }

    public RubyMixinVariable[] getFields() {
        return new RubyMixinVariable[0];
    }

    public RubyMixinMethod getMethod(String name) {
        RubyMixinMethod method = super.getMethod(name);
        if (method != null) {
            return method;
        }
        IRubyMixinElement element = this.model.createRubyElement(name);
        if (element instanceof RubyMixinMethod) {
            return (RubyMixinMethod)element;
        }
        return null;
    }
}

