/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.codeassist.impl;

import java.util.Map;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ISearchableEnvironment;
import org.eclipse.dltk.internal.codeassist.impl.AssistOptions;
import org.eclipse.dltk.internal.compiler.impl.ITypeRequestor;
import org.eclipse.dltk.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.dltk.internal.compiler.lookup.SourceModuleScope;

public abstract class Engine
implements ITypeRequestor {
    public LookupEnvironment lookupEnvironment;
    protected ISearchableEnvironment nameEnvironment;
    protected SourceModuleScope unitScope;
    public AssistOptions options;
    protected static int EXACT_RULE = 8;

    public Engine(Map settings) {
        this.options = new AssistOptions(settings);
    }

    protected ASTNode parseBlockStatements(ModuleDeclaration unit, int position) {
        TypeDeclaration[] types = unit.getTypes();
        int length = types.length;
        int i = 0;
        while (i < length) {
            TypeDeclaration type = types[i];
            if (type.sourceStart() <= position && type.sourceEnd() >= position) {
                this.getParser().setSource(unit);
                return this.parseBlockStatements(type, unit, position);
            }
            ++i;
        }
        MethodDeclaration[] methods = unit.getFunctions();
        length = methods.length;
        int i2 = 0;
        while (i2 < length) {
            MethodDeclaration method = methods[i2];
            if (method.sourceStart() <= position && method.sourceEnd() >= position) {
                this.getParser().setSource(unit);
                return this.parseMethod(method, unit, position);
            }
            ++i2;
        }
        ASTNode[] nodes = unit.getNonTypeOrMethodNode();
        length = nodes.length;
        int i3 = 0;
        while (i3 < length) {
            ASTNode node = nodes[i3];
            if (node.sourceStart() <= position && node.sourceEnd() >= position) {
                this.getParser().setSource(unit);
                this.getParser().parseBlockStatements(node, unit, position);
                return node;
            }
            ++i3;
        }
        this.getParser().handleNotInElement(unit, position);
        return null;
    }

    private ASTNode parseBlockStatements(TypeDeclaration type, ModuleDeclaration unit, int position) {
        ASTNode node;
        MethodDeclaration[] methods;
        TypeDeclaration[] memberTypes = type.getTypes();
        if (memberTypes != null) {
            int length = memberTypes.length;
            int i = 0;
            while (i < length) {
                TypeDeclaration memberType = memberTypes[i];
                if (memberType.getNameStart() <= position && memberType.getNameEnd() >= position) {
                    this.getParser().handleNotInElement(memberType, position);
                }
                if (memberType.getBodyStart() <= position && memberType.sourceEnd() >= position) {
                    return this.parseBlockStatements(memberType, unit, position);
                }
                ++i;
            }
        }
        if ((methods = type.getMethods()) != null) {
            int length = methods.length;
            int i = 0;
            while (i < length) {
                MethodDeclaration method = methods[i];
                node = this.parseMethod(method, unit, position);
                if (node != null) {
                    return node;
                }
                ++i;
            }
        }
        ASTNode[] nodes = type.getNonTypeOrMethodNode();
        int length = nodes.length;
        int i = 0;
        while (i < length) {
            node = nodes[i];
            if (node.sourceStart() <= position && node.sourceEnd() >= position) {
                this.getParser().setSource(unit);
                this.getParser().parseBlockStatements(node, type, position);
                return node;
            }
            ++i;
        }
        this.getParser().handleNotInElement(type, position);
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: Engine: Add fields support.");
        }
        return null;
    }

    private ASTNode parseMethod(MethodDeclaration method, ModuleDeclaration unit, int position) {
        if (method != null) {
            if (method.sourceStart() > position) {
                return null;
            }
            if (method.sourceEnd() >= position) {
                this.getParser().parseBlockStatements(method, unit, position);
                return method;
            }
        }
        return null;
    }

    public abstract IAssistParser getParser();
}

