/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Permission;
import java.security.ProtectionDomain;
import java.util.Dictionary;
import java.util.Enumeration;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.BundleHost;
import org.eclipse.osgi.framework.internal.core.Constants;
import org.eclipse.osgi.framework.internal.core.Framework;
import org.eclipse.osgi.framework.internal.core.FrameworkProperties;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkEvent;

public class InternalSystemBundle
extends BundleHost
implements org.osgi.framework.launch.Framework {
    ProtectionDomain systemDomain;

    protected InternalSystemBundle(Framework framework) throws BundleException {
        super(framework.adaptor.createSystemBundleData(), framework);
        Constants.setInternalSymbolicName(this.bundledata.getSymbolicName());
        this.state = 4;
        this.context = this.createContext();
    }

    protected void load() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            this.systemDomain = this.getClass().getProtectionDomain();
        }
    }

    protected boolean reload(AbstractBundle newBundle) {
        return false;
    }

    protected void refresh() {
    }

    protected boolean unload() {
        return false;
    }

    protected void close() {
        this.context.close();
        this.context = null;
    }

    protected Class loadClass(String name, boolean checkPermission) throws ClassNotFoundException {
        if (checkPermission) {
            this.framework.checkAdminPermission(this, "class");
            this.checkValid();
        }
        return Class.forName(name);
    }

    public URL getResource(String name) {
        return null;
    }

    protected boolean isUnresolved() {
        return false;
    }

    public void start() {
        this.framework.checkAdminPermission(this, "execute");
    }

    public void start(int options) {
        this.framework.checkAdminPermission(this, "execute");
    }

    protected void resume() {
        this.framework.startLevelManager.initialize();
        this.loadInstalledBundles(this.framework.startLevelManager.getInstalledBundles(this.framework.bundles, false));
        try {
            this.framework.systemBundle.state = 8;
            this.framework.systemBundle.context.start();
            this.framework.publishBundleEvent(128, this.framework.systemBundle);
        }
        catch (BundleException be) {
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Bundle resume exception: " + be.getMessage());
                Debug.printStackTrace(be.getNestedException() == null ? be : be.getNestedException());
            }
            this.framework.publishFrameworkEvent(2, this.framework.systemBundle, be);
            throw new RuntimeException(be.getMessage());
        }
    }

    private void loadInstalledBundles(AbstractBundle[] installedBundles) {
        int i = 0;
        while (i < installedBundles.length) {
            AbstractBundle bundle = installedBundles[i];
            if (Debug.DEBUG_STARTLEVEL) {
                Debug.println("SLL: Trying to load bundle " + bundle);
            }
            bundle.load();
            ++i;
        }
    }

    public void stop() {
        this.framework.checkAdminPermission(this, "execute");
        if ((this.state & 0x28) != 0) {
            Thread shutdown = this.framework.secureAction.createThread(new Runnable(){

                public void run() {
                    try {
                        InternalSystemBundle.this.framework.close();
                    }
                    catch (Throwable t) {
                        InternalSystemBundle.this.framework.adaptor.handleRuntimeError(t);
                    }
                }
            }, "System Bundle Shutdown", this.framework.getContextFinder());
            shutdown.start();
        }
    }

    public void stop(int options) {
        this.stop();
    }

    protected void suspend() {
        this.framework.startLevelManager.shutdown();
        this.framework.startLevelManager.cleanup();
        this.framework.packageAdmin.cleanup();
        if (Debug.DEBUG_GENERAL) {
            Debug.println("->Framework shutdown");
        }
        this.framework.publishBundleEvent(4, this);
    }

    protected void suspend(boolean lock) {
    }

    public void update() {
        this.framework.checkAdminPermission(this, "lifecycle");
        if ((this.state & 0x28) != 0) {
            Thread restart = this.framework.secureAction.createThread(new Runnable(){

                public void run() {
                    int sl = InternalSystemBundle.this.framework.startLevelManager.getStartLevel();
                    FrameworkProperties.setProperty("osgi.framework.relaunch", "");
                    InternalSystemBundle.this.framework.shutdown(128);
                    InternalSystemBundle.this.framework.launch();
                    if (sl > 0) {
                        InternalSystemBundle.this.framework.startLevelManager.doSetStartLevel(sl);
                    }
                    FrameworkProperties.clearProperty("osgi.framework.relaunch");
                }
            }, "System Bundle Update", this.framework.getContextFinder());
            restart.start();
        }
    }

    public void update(InputStream in) {
        this.update();
        try {
            in.close();
        }
        catch (IOException iOException) {}
    }

    public void uninstall() throws BundleException {
        this.framework.checkAdminPermission(this, "lifecycle");
        throw new BundleException(Msg.BUNDLE_SYSTEMBUNDLE_UNINSTALL_EXCEPTION, 2);
    }

    public boolean hasPermission(Object permission) {
        if (this.systemDomain != null) {
            if (permission instanceof Permission) {
                return this.systemDomain.implies((Permission)permission);
            }
            return false;
        }
        return true;
    }

    protected void unresolvePermissions(AbstractBundle[] refreshedBundles) {
    }

    public Dictionary getHeaders(String localeString) {
        return new SystemBundleHeaders(super.getHeaders(localeString));
    }

    public void init() {
    }

    public FrameworkEvent waitForStop(long timeout) throws InterruptedException {
        return this.framework.waitForStop(timeout);
    }

    class SystemBundleHeaders
    extends Dictionary {
        private final Dictionary headers;

        public SystemBundleHeaders(Dictionary headers) {
            this.headers = headers;
        }

        public Enumeration elements() {
            return this.headers.elements();
        }

        public Object get(Object key) {
            if (!"Export-Package".equals(key)) {
                return this.headers.get(key);
            }
            String systemPackages = FrameworkProperties.getProperty("org.osgi.framework.system.packages");
            String results = (String)this.headers.get("Export-Package");
            if (systemPackages != null) {
                results = results != null ? String.valueOf(results) + ", " + systemPackages : systemPackages;
            }
            return results;
        }

        public boolean isEmpty() {
            return this.headers.isEmpty();
        }

        public Enumeration keys() {
            return this.headers.keys();
        }

        public Object put(Object key, Object value) {
            return this.headers.put(key, value);
        }

        public Object remove(Object key) {
            return this.headers.remove(key);
        }

        public int size() {
            return this.headers.size();
        }
    }
}

