/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.userinfo.impl;

import org.eclipse.actf.ai.navigator.userinfo.IUserInfoConstants;
import org.eclipse.actf.ai.navigator.userinfo.IUserInfoGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class AltTextEditor
implements IUserInfoGenerator,
IUserInfoConstants {
    public String toString(IUserInfoGenerator.Result result) {
        switch (result) {
            case CREATED: {
                return "AltTextEditor.Result.CREATED";
            }
            case REMOVED: {
                return "AltTextEditor.Result.REMOVED";
            }
            case CHANGED: {
                return "AltTextEditor.Result.CHANGED";
            }
            case ERROR: {
                return "AltTextEditor.Result.ERROR";
            }
        }
        return "";
    }

    private Node getExistingUserInfo(Node node) {
        Node c = node.getFirstChild();
        while (c != null) {
            String n;
            String ns = c.getNamespaceURI();
            if (ns != null && ns.equals("http://www.ibm.com/xmlns/prod/aiBrowser/fennec") && (n = c.getLocalName()).equals("altText")) {
                return c;
            }
            c = c.getNextSibling();
        }
        return null;
    }

    public IUserInfoGenerator.Result addUserInfo(Node node, String text) {
        Document doc = node.getOwnerDocument();
        Node info = this.getExistingUserInfo(node);
        if (text.length() > 0) {
            if (info == null) {
                info = node.appendChild(doc.createElementNS("http://www.ibm.com/xmlns/prod/aiBrowser/fennec", "altText"));
                info.setTextContent(text);
                return IUserInfoGenerator.Result.CREATED;
            }
            info.setTextContent(text);
            return IUserInfoGenerator.Result.CHANGED;
        }
        if (info != null) {
            node.removeChild(info);
            return IUserInfoGenerator.Result.REMOVED;
        }
        return IUserInfoGenerator.Result.NOTHING;
    }
}

