/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.extension;

import java.util.ArrayList;
import org.eclipse.actf.ai.navigator.IBrowserControl;
import org.eclipse.actf.ai.navigator.IManipulator;
import org.eclipse.actf.ai.navigator.INavigatorUI;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;

public class ManipulatorExtension {
    private static final String TAG_MANIPULATOR = "manipulator";
    private static final String ATTR_CLASS = "class";
    private static ManipulatorExtension[] cachedExtensions;
    private final IConfigurationElement configElement;
    private IManipulator manipulator;

    public static ManipulatorExtension[] getExtensions() {
        if (cachedExtensions != null) {
            return cachedExtensions;
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.actf.ai.navigator", "Navigation").getExtensions();
        ArrayList<ManipulatorExtension> l = new ArrayList<ManipulatorExtension>();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < configElements.length) {
                ManipulatorExtension ex = ManipulatorExtension.parseExtension(configElements[j], l.size());
                if (ex != null) {
                    l.add(ex);
                }
                ++j;
            }
            ++i;
        }
        cachedExtensions = l.toArray(new ManipulatorExtension[l.size()]);
        return cachedExtensions;
    }

    private static ManipulatorExtension parseExtension(IConfigurationElement configElement, int idx) {
        if (!configElement.getName().equals(TAG_MANIPULATOR)) {
            return null;
        }
        try {
            return new ManipulatorExtension(configElement);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void disposeExtensions() {
        if (cachedExtensions == null) {
            return;
        }
        int i = 0;
        while (i < cachedExtensions.length) {
            cachedExtensions[i].dispose();
            ++i;
        }
        cachedExtensions = null;
    }

    public static void setBrowserControl(IBrowserControl browserControl) {
        ManipulatorExtension[] exs = ManipulatorExtension.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getManipulator().setBrowserControl(browserControl);
            ++i;
        }
    }

    public static void setNavigator(INavigatorUI navigatorUI) {
        ManipulatorExtension[] exs = ManipulatorExtension.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getManipulator().setNavigator(navigatorUI);
            ++i;
        }
    }

    public static void setMode(IManipulator.Mode mode) {
        ManipulatorExtension[] exs = ManipulatorExtension.getExtensions();
        if (exs == null) {
            return;
        }
        int i = 0;
        while (i < exs.length) {
            exs[i].getManipulator().setMode(mode);
            ++i;
        }
    }

    private ManipulatorExtension(IConfigurationElement configElement) {
        this.configElement = configElement;
    }

    private IManipulator getManipulator() {
        if (this.manipulator != null) {
            return this.manipulator;
        }
        try {
            this.manipulator = (IManipulator)this.configElement.createExecutableExtension(ATTR_CLASS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.manipulator;
    }

    private void dispose() {
        if (this.manipulator == null) {
            return;
        }
        this.manipulator.dispose();
        this.manipulator = null;
    }
}

