/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.navigator.broker;

import java.lang.reflect.Method;
import org.eclipse.actf.ai.fennec.treemanager.ITreeManager;
import org.eclipse.actf.ai.navigator.broker.Mirror;
import org.eclipse.actf.ai.navigator.impl.NavigatorImpl;
import org.eclipse.actf.ai.navigator.impl.WebEventListener;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.ui.util.timer.Yield;

public class RequestBroker {
    public static final int SHOW_STATUS = 100;
    public static final int EVENT_NEW_URL = 101;
    public static final int EVENT_NEWPAGE_READY = 1000;
    public static final int EVENT_LOAD_STARTING = 1001;
    public static final int EVENT_WAIT_FOR_PROCESSING = 1200;
    public static final int EVENT_INFORMATION_UPDATED = 1201;
    public static final int EVENT_TREE_MODIFIED = 1202;
    public static final int EVENT_NOTIFICATION = 1203;
    public static final int EVENT_ALERT_MODAL = 1204;
    public static final int EVENT_AUTOMATIC_TRANSITION = 1205;
    private final WebEventListener webEventListener;
    private NavigatorImpl navigator;
    private IWebBrowserACTF webBrowser;
    private boolean enabled;
    private Method registerRequestBrokerMethod;
    private Method sendEventMethod;

    public void setNavigator(NavigatorImpl navigator, IWebBrowserACTF webBrowser) {
        this.navigator = navigator;
        this.webBrowser = webBrowser;
    }

    private void registerProxy() {
        if (!this.enabled) {
            return;
        }
        try {
            Thread o = Thread.currentThread();
            this.registerRequestBrokerMethod.invoke((Object)o, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendEvent(int id, Object param) {
        if (!this.enabled) {
            return;
        }
        System.err.println("EventRP:" + id + " Param:" + param);
        try {
            Thread o = Thread.currentThread();
            this.sendEventMethod.invoke((Object)o, new Integer(id), param);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void newPageReady() {
        this.sendEvent(101, this.webBrowser.getURL());
        this.sendEvent(1000, null);
    }

    public Object invokeNavigator(String signature, Object[] args) throws Exception {
        Mirror m = new Mirror(this.navigator);
        Method method = m.getMethod(signature);
        return Yield.syncInvoke((Method)method, (Object)this.navigator, (Object[])args);
    }

    public Object invokeTreeManager(String signature, Object[] args) throws Exception {
        ITreeManager treeManager = this.navigator.getTreeManager();
        Mirror m = new Mirror(treeManager);
        Method method = m.getMethod(signature);
        return Yield.syncInvoke((Method)method, (Object)treeManager, (Object[])args);
    }

    public Object invokeITreeItem(Object item, String signature, Object[] args) throws Exception {
        Mirror m = new Mirror(item);
        Method method = m.getMethod(signature);
        return Yield.syncInvoke((Method)method, (Object)item, (Object[])args);
    }

    private void initialize() {
        Thread o = Thread.currentThread();
        Class<?> c = o.getClass();
        try {
            this.registerRequestBrokerMethod = c.getMethod("registerRequestBroker", Object.class);
            this.sendEventMethod = c.getMethod("sendEvent", Integer.TYPE, Object.class);
            this.enabled = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.enabled = false;
        }
    }

    public RequestBroker(WebEventListener webEventListener) {
        this.webEventListener = webEventListener;
        this.initialize();
        this.registerProxy();
    }
}

