/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.proxy;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;
import org.eclipse.actf.util.httpproxy.ExternalProxyConfig;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.proxy.IClientStateManager;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPLocalServer;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPLocalServerFactory;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoder;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPSessionOverrider;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPSessionOverriderFactory;
import org.eclipse.actf.util.httpproxy.util.Logger;
import org.eclipse.actf.util.httpproxy.util.ParseURI;
import org.eclipse.actf.util.internal.httpproxy.core.HTTPResponseInMemoryMessage;
import org.eclipse.actf.util.internal.httpproxy.core.RequestDispatcher;
import org.eclipse.actf.util.internal.httpproxy.core.Session;
import org.eclipse.actf.util.internal.httpproxy.proxy.HTTPProxyConnection;
import org.eclipse.actf.util.internal.httpproxy.proxy.HTTPServerConnection;

public class HTTPRequestDispatcher
extends RequestDispatcher {
    private static final Logger LOGGER = Logger.getLogger(HTTPRequestDispatcher.class);
    private final IClientStateManager clientStateManager;
    private final HTTPProxyConnection fClient;
    private final ExternalProxyConfig fExProxyConf;
    private final int timeout;
    private static final int HTTP_WELL_KNOWN_PORT = 80;
    private static final int HTTPS_WELL_KNOWN_PORT = 443;
    private static CacheConfig[] cacheConfigs = new CacheConfig[]{new CacheConfig("http://.*\\abcnews\\.go\\.com/Video/.*", "no-cache")};
    private IHTTPSessionOverrider overrider = null;
    private IHTTPLocalServer localServer = null;
    private ArrayList<HTTPServerConnection> serverConnectionCache = new ArrayList();
    private IHTTPProxyTranscoder transcoder = null;

    private IHTTPResponseMessage addCacheControl(String uriStr, IHTTPResponseMessage response) {
        int i = 0;
        while (i < cacheConfigs.length) {
            if (uriStr.matches(HTTPRequestDispatcher.cacheConfigs[i].urlPattern)) {
                System.err.println("match-to:" + HTTPRequestDispatcher.cacheConfigs[i].urlPattern);
                response.setHeader(IHTTPHeader.CACHE_CONTROL_A, HTTPRequestDispatcher.cacheConfigs[i].control);
                return response;
            }
            ++i;
        }
        return response;
    }

    public HTTPRequestDispatcher(HTTPProxyConnection client, IClientStateManager clientStateManager, Socket clientSock, int queueSize, int timeout) {
        super("HTTPRequestDispatcher-" + clientSock.getLocalPort(), new Session(), client, clientSock, queueSize);
        this.fClient = client;
        this.fExProxyConf = client.getExternalProxyConfig();
        this.clientStateManager = clientStateManager;
        this.timeout = timeout;
        IHTTPLocalServerFactory localServerFactory = client.getProxy().getLocalServerFactory();
        IHTTPSessionOverriderFactory overriderFactory = client.getProxy().getSessionOverriderFactory();
        if (localServerFactory != null) {
            this.localServer = localServerFactory.newInstance();
        }
        if (overriderFactory != null) {
            this.overrider = overriderFactory.newInstance(this.getDispatcherId());
        }
    }

    private boolean processLocalServerRequest(IHTTPRequestMessage request) throws InterruptedException, IOException {
        if (this.localServer == null) {
            return false;
        }
        return this.localServer.processRequest(this.getDispatcherId(), this.fClient, request, this.transcoder);
    }

    private HTTPServerConnection getConnection(String host, int port) {
        HTTPServerConnection sc;
        int len = this.serverConnectionCache.size();
        int i = 0;
        while (i < len) {
            sc = this.serverConnectionCache.get(i);
            if (host.equals(sc.getHost()) && port == sc.getPort()) {
                if (sc.getStat() < 0) {
                    sc.deactivate();
                    sc = HTTPServerConnection.newConnection(this, host, port, this.timeout);
                    this.serverConnectionCache.set(i, sc);
                }
                return sc;
            }
            if (sc.getStat() < 0) {
                sc.deactivate();
                this.serverConnectionCache.remove(i);
                --len;
                continue;
            }
            ++i;
        }
        sc = HTTPServerConnection.newConnection(this, host, port, this.timeout);
        this.serverConnectionCache.add(sc);
        return sc;
    }

    private HTTPServerConnection newConnectionForServer(IHTTPRequestMessage request, boolean modeConnect) {
        IHTTPHeader pragmaHeader;
        IHTTPHeader pcHeader;
        int port;
        String host;
        String uriStr = request.getRequestURIString();
        String authority = ParseURI.getAuthority(uriStr);
        IHTTPHeader hostHeader = request.getHeader(IHTTPHeader.HOST_A);
        if (modeConnect) {
            host = ParseURI.parseHost(uriStr);
            port = ParseURI.parsePort(uriStr, 443);
        } else if (hostHeader != null) {
            String hostStr = new String(hostHeader.getValue());
            host = ParseURI.parseHost(hostStr);
            port = ParseURI.parsePort(hostStr, 80);
        } else if (authority != null) {
            host = ParseURI.parseHost(authority);
            port = ParseURI.parsePort(authority, 80);
            request.setHeader(IHTTPHeader.HOST_A, host.getBytes());
        } else {
            return null;
        }
        if (authority != null) {
            String absPath = ParseURI.getAbsolutePath(uriStr);
            request.setRequestURIString(absPath);
        }
        if ((pcHeader = request.getHeader(IHTTPHeader.PROXY_CONNECTION_A)) != null) {
            pcHeader.setRemoved(true);
            request.setHeader(IHTTPHeader.CONNECTION_A, pcHeader.getValue());
        }
        if ((pragmaHeader = request.getHeader(IHTTPHeader.PRAGMA_A)) != null) {
            pragmaHeader.setRemoved(true);
        }
        return this.getConnection(host, port);
    }

    private HTTPServerConnection newConnectionForProxy() {
        return this.getConnection(this.fExProxyConf.getExternalProxyHost(), this.fExProxyConf.getExternalProxyPort());
    }

    public void setTranscoder(IHTTPProxyTranscoder transcoder) {
        this.transcoder = transcoder;
    }

    private IHTTPResponseMessage transcode(IHTTPRequestMessage request, IHTTPResponseMessage response) {
        if (this.transcoder != null) {
            return this.transcoder.transcode(this.getDispatcherId(), request, response);
        }
        return response;
    }

    private void sendGatewayTimeout(IHTTPRequestMessage request) throws InterruptedException, IOException {
        this.fClient.sendResponse(new HTTPResponseInMemoryMessage(request.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "504".getBytes(), "Gateway Timeout".getBytes(), IHTTPResponseMessage.EMPTY_BODY));
    }

    private void sendBadGateway(IHTTPRequestMessage request) throws InterruptedException, IOException {
        this.fClient.sendResponse(new HTTPResponseInMemoryMessage(request.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "502".getBytes(), "Bad Gateway".getBytes(), IHTTPResponseMessage.EMPTY_BODY));
    }

    private void sendNotFound(IHTTPRequestMessage request) throws InterruptedException, IOException {
        this.fClient.sendResponse(new HTTPResponseInMemoryMessage(request.getSerial(), IHTTPHeader.HTTP_VERSION_1_0_A, "404".getBytes(), "Not Found".getBytes(), IHTTPResponseMessage.EMPTY_BODY));
    }

    /*
     * Exception decompiling
     */
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [17[DOLOOP]], but top level block is 18[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void close() {
        super.close();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("[id:").append(this.getDispatcherId()).append("] HTTPRequestDispatcher");
        return sb.toString();
    }

    protected final void DEBUG(String msg) {
        if (LOGGER.isDebugEnabled()) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.toString()).append(": ").append(msg);
            LOGGER.debug(sb.toString());
        }
    }

    protected final void WARNING(String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString()).append(": ").append(msg);
        LOGGER.warning(sb.toString());
    }

    protected final void INFO(String msg) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.toString()).append(": ").append(msg);
        LOGGER.info(sb.toString());
    }

    private static class CacheConfig {
        public final String urlPattern;
        public final byte[] control;

        public CacheConfig(String urlPattern, String control) {
            this.urlPattern = urlPattern;
            this.control = control.getBytes();
        }
    }
}

