/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.query.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.actf.ai.query.IQuery;
import org.eclipse.actf.ai.query.impl.FlashQueryImpl;
import org.eclipse.actf.ai.query.impl.MSAAQueryImpl;
import org.eclipse.actf.ai.query.impl.XMLQueryImpl;
import org.eclipse.actf.model.dom.dombycom.IFlashMSAANode;
import org.eclipse.actf.model.dom.dombycom.IFlashNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryImpl
implements IQuery {
    private final XMLQueryImpl xmlQuery;
    private final FlashQueryImpl flashQuery;
    private final MSAAQueryImpl msaaQuery;
    public static final String Fennec_NAMESPACE_URI = "http://www.ibm.com/xmlns/prod/aiBrowser/fennec";
    public static final String Fennec_NODE_ELEMENT_NAME = "node";

    private QueryImpl(XMLQueryImpl xmlQuery, FlashQueryImpl flashQuery, MSAAQueryImpl msaaQuery) {
        this.xmlQuery = xmlQuery;
        this.flashQuery = flashQuery;
        this.msaaQuery = msaaQuery;
    }

    public static QueryImpl parse(Element e, IQuery parentQuery) {
        QueryImpl pq = null;
        pq = parentQuery == null ? null : (QueryImpl)parentQuery;
        XMLQueryImpl xmlParentQuery = pq == null ? null : pq.xmlQuery;
        XMLQueryImpl xmlQuery = XMLQueryImpl.parse(e, xmlParentQuery);
        FlashQueryImpl flashParentQuery = pq == null ? null : pq.flashQuery;
        FlashQueryImpl flashQuery = FlashQueryImpl.parse(e, flashParentQuery);
        MSAAQueryImpl msaaParentQuery = pq == null ? null : pq.msaaQuery;
        MSAAQueryImpl msaaQuery = MSAAQueryImpl.parse(e, msaaParentQuery);
        return new QueryImpl(xmlQuery, flashQuery, msaaQuery);
    }

    public static QueryImpl parseXPath(String xpath) {
        XMLQueryImpl xmlQuery = XMLQueryImpl.parseXPath(xpath);
        return new QueryImpl(xmlQuery, null, null);
    }

    @Override
    public boolean hasTarget() {
        return this.xmlQuery != null && this.xmlQuery.hasTarget() || this.flashQuery != null && this.flashQuery.hasTarget();
    }

    @Override
    public NodeList query(Node base) {
        List<Node> list;
        ArrayList<Node> r;
        List<Node> result = null;
        if (this.xmlQuery != null && this.xmlQuery.hasTarget()) {
            result = this.xmlQuery.query(base);
        }
        if (this.flashQuery != null && this.flashQuery.hasTarget()) {
            if (result == null) {
                result = this.flashQuery.query(base);
            } else {
                r = new ArrayList<Node>();
                for (Node node : result) {
                    if (!(node instanceof IFlashNode) || (list = this.flashQuery.query((Node)((IFlashNode)node))) == null) continue;
                    r.addAll(list);
                }
                result = r;
            }
        }
        if (this.msaaQuery != null && this.msaaQuery.hasTarget()) {
            if (result == null) {
                result = this.msaaQuery.query(base);
            } else {
                r = new ArrayList();
                for (Node node : result) {
                    if (!(node instanceof IFlashNode) || (list = this.msaaQuery.query((Node)((IFlashNode)node).getMSAA())) == null) continue;
                    r.addAll(list);
                }
                result = r;
            }
        }
        return new NodeListImpl(result);
    }

    public static Node serializeQuery(Node domTarget, Node usrParent) {
        List<Attr> attrs = QueryImpl.calcAttrs(domTarget, usrParent);
        Node node = QueryImpl.getNode(usrParent, attrs);
        if (node != null) {
            return node;
        }
        return QueryImpl.createNode(usrParent, attrs);
    }

    private static List<Attr> calcAttrs(Node domTarget, Node usrParent) {
        Attr flashAttr;
        Object xmlNode;
        ArrayList<Attr> attrs = new ArrayList<Attr>(2);
        if (domTarget instanceof IFlashNode) {
            xmlNode = ((IFlashNode)domTarget).getBaseNode();
            flashAttr = FlashQueryImpl.serializeQuery(domTarget, usrParent);
        } else if (domTarget instanceof IFlashMSAANode) {
            xmlNode = ((IFlashMSAANode)domTarget).getBaseNode();
            flashAttr = MSAAQueryImpl.serializeQuery(domTarget, usrParent);
        } else {
            xmlNode = domTarget;
            flashAttr = null;
        }
        Attr xmlAttr = XMLQueryImpl.serializeQuery((Node)xmlNode, usrParent);
        if (xmlAttr != null) {
            attrs.add(xmlAttr);
        }
        if (flashAttr != null) {
            attrs.add(flashAttr);
        }
        return attrs;
    }

    private static boolean match(Node node, List<Attr> attrs) {
        NamedNodeMap map = node.getAttributes();
        if (map == null) {
            return false;
        }
        for (Attr a : attrs) {
            String t;
            Node n = map.getNamedItemNS(a.getNamespaceURI(), a.getLocalName());
            if (n == null) {
                return false;
            }
            String s = a.getNodeValue();
            if (s.equals(t = n.getNodeValue())) continue;
            return false;
        }
        return true;
    }

    private static Node getNode(Node parent, List<Attr> attrs) {
        Node n = parent.getFirstChild();
        while (n != null) {
            if (QueryImpl.match(n, attrs)) {
                return n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    private static Node createNode(Node parent, List<Attr> attrs) {
        Document doc = parent.getOwnerDocument();
        Node node = parent.insertBefore(doc.createElementNS(Fennec_NAMESPACE_URI, Fennec_NODE_ELEMENT_NAME), parent.getFirstChild());
        NamedNodeMap map = node.getAttributes();
        for (Attr a : attrs) {
            map.setNamedItemNS(a);
        }
        return node;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeListImpl
    implements NodeList {
        private List<Node> nodeList;

        @Override
        public Node item(int index) {
            if (index < 0 || index >= this.nodeList.size()) {
                return null;
            }
            return this.nodeList.get(index);
        }

        @Override
        public int getLength() {
            return this.nodeList.size();
        }

        NodeListImpl(List<Node> nodeList) {
            this.nodeList = nodeList == null ? new ArrayList<Node>(0) : nodeList;
        }
    }
}

