/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.tts.protalker.engine;

import org.eclipse.actf.ai.tts.ITTSEngine;
import org.eclipse.actf.ai.tts.protalker.ProTalkerPlugin;
import org.eclipse.actf.ai.tts.protalker.engine.ProTalkerBridge;
import org.eclipse.actf.ai.voice.IVoiceEventListener;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Display;

public class ProTalker
implements ITTSEngine,
IPropertyChangeListener {
    public static final String ID = "org.eclipse.actf.ai.tts.protalker.engine.ProTalker";
    private ProTalkerBridge engine = new ProTalkerBridge(Display.getDefault());
    private boolean isDisposed = false;
    private static IPreferenceStore preferenceStore = ProTalkerPlugin.getDefault().getPreferenceStore();

    public ProTalker() {
        this.setVoice();
        ProTalkerPlugin.getDefault().addPropertyChangeListener(this);
    }

    public void setEventListener(IVoiceEventListener eventListener) {
        this.engine.addIndexListener(eventListener);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (ID.equals(event.getProperty())) {
            this.stop();
            this.setVoice();
        }
    }

    public void speak(String text, int flags, int index) {
        this.engine.speak(text, flags, index);
    }

    public void stop() {
        this.engine.reset();
    }

    public int getSpeed() {
        return this.engine.getSpeed();
    }

    public void setSpeed(int speed) {
        this.engine.setSpeed(speed * 8 / 5 + 100);
    }

    public void setLanguage(String language) {
    }

    private void setVoice() {
        String voiceName = preferenceStore.getString(ID);
        this.setVoice(voiceName);
    }

    public void setVoice(String type) {
        if (type.equals("male")) {
            this.engine.setVoice(0);
        } else if (type.equals("female")) {
            this.engine.setVoice(1);
        }
    }

    public void setGender(String gender) {
        if (gender.equals("male")) {
            this.engine.setVoice(0);
        } else if (gender.equals("female")) {
            this.engine.setVoice(1);
        }
    }

    public boolean isAvailable() {
        return this.engine.isAvailable();
    }

    public void dispose() {
        if (!this.isDisposed) {
            this.isDisposed = true;
            this.engine.dispose();
            if (ProTalkerPlugin.getDefault() != null) {
                ProTalkerPlugin.getDefault().removePropertyChangeListener(this);
            }
        }
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

