/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.screenreader.jaws.script;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.actf.ai.screenreader.jaws.script.Key;
import org.eclipse.actf.ai.screenreader.jaws.script.Keymap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeybindScriptGenerator {
    private String defaultPath = ".";
    private String userPath = ".";
    private String appName;
    private String flagName;
    private String keySettingFile = "keysettings.xml";
    private Vector<Key> keys = new Vector();
    private static final int TYPE_COMMON = 1;
    private static final int TYPE_QUICK = 2;
    private static final int TYPE_VIRTUAL = 4;
    private Vector<Keymap> keymaps_common = new Vector();
    private Vector<Keymap> keymaps_quick = new Vector();
    private Vector<Keymap> keymaps_virtual = new Vector();

    public static void main(String[] args) {
        KeybindScriptGenerator ksg = new KeybindScriptGenerator();
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-dp")) {
                ksg.defaultPath = args[++i];
            } else if (args[i].equals("-up")) {
                ksg.userPath = args[++i];
            } else if (args[i].equals("-name")) {
                ksg.appName = args[++i];
                ksg.flagName = "g_" + ksg.appName.replaceAll(" ", "") + "Flag";
            } else if (args[i].equals("-key")) {
                ksg.keySettingFile = args[++i];
            }
            ++i;
        }
        ksg.generate();
    }

    public void generate() {
        this.readKeySettings();
        this.readDefaultKeymap();
        this.writeScript();
    }

    private void readKeySettings() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            InputSource input = new InputSource(new FileInputStream(this.keySettingFile));
            Document doc = builder.parse(input);
            String[] tags = new String[]{"Commands", "Functions"};
            int i = 0;
            while (i < tags.length) {
                NodeList commandsList = doc.getElementsByTagName(tags[i]);
                int j = 0;
                while (j < commandsList.getLength()) {
                    Node commands = commandsList.item(j);
                    NodeList commandList = commands.getChildNodes();
                    int k = 0;
                    while (k < commandList.getLength()) {
                        Node command = commandList.item(k);
                        if (command.getNodeType() == 1) {
                            Element commandElement = (Element)command;
                            NodeList keyList = command.getChildNodes();
                            int l = 0;
                            while (l < keyList.getLength()) {
                                Node keyNode = keyList.item(l);
                                if ("key".equals(keyNode.getNodeName())) {
                                    Key key = new Key(keyNode, commandElement);
                                    this.keys.add(key);
                                }
                                ++l;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void readDefaultKeymap() {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(String.valueOf(this.defaultPath) + "\\Default.JKM")));
            boolean flag = false;
            int type = 1;
            while ((line = br.readLine()) != null) {
                if (line.length() > 0 && line.charAt(0) == '[') {
                    if (line.toLowerCase().equals("[common keys]")) {
                        flag = true;
                        type = 1;
                    } else if (line.toLowerCase().equals("[quick navigation keys]")) {
                        flag = true;
                        type = 2;
                    } else if (line.toLowerCase().equals("[virtual keys]")) {
                        flag = true;
                        type = 4;
                    } else {
                        flag = false;
                    }
                }
                if (line.length() <= 0 || line.charAt(0) == ';' || line.charAt(0) == '[' || !flag || line.toLowerCase().startsWith("braille")) continue;
                Keymap keymap = new Keymap(line);
                switch (type) {
                    case 1: {
                        this.keymaps_common.add(keymap);
                        break;
                    }
                    case 2: {
                        this.keymaps_quick.add(keymap);
                        break;
                    }
                    case 4: {
                        this.keymaps_virtual.add(keymap);
                    }
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeScript() {
        try {
            File jss = new File(String.valueOf(this.userPath) + "\\" + this.appName + ".jss");
            PrintWriter jssw = new PrintWriter(new FileOutputStream(jss));
            this.writeFunctions(jssw);
            jssw.close();
            File jkm = new File(String.valueOf(this.userPath) + "\\" + this.appName + ".jkm");
            PrintWriter jkmw = new PrintWriter(new FileOutputStream(jkm));
            this.writeKeyMap(jkmw);
            jkmw.close();
            File jsh = new File(String.valueOf(this.userPath) + "\\" + this.appName + ".jsh");
            PrintWriter jshw = new PrintWriter(new FileOutputStream(jsh));
            this.writeGlobals(jshw);
            jshw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void writeGlobals(PrintWriter pw) {
        pw.println("Globals");
        pw.println("  int " + this.flagName + ",");
        pw.println("  int g_aiBrowserSayAllFlag,");
        pw.println("  handle g_aiBrowserSayAllWindow,");
        pw.println("  int g_aiBrowserSayAllMessage");
    }

    private void writeFixedCode(PrintWriter pw) {
        pw.print(";--------------------------------------------------------------------------------\r\nScript AiBrowserSayAllOff ()\r\n  If g_aiBrowserSayAllFlag Then\r\n    let g_aiBrowserSayAllFlag = 0\r\n    StopSpeech()\r\n    Delay(5, 1)\r\n  EndIf\r\nEndScript\r\n\r\nVoid Function FocusChangedEvent(Handle hCurWin, Handle hPrevWin)\r\nIf g_aiBrowserSayAllFlag Then\r\n    return\r\n  Else\r\n    FocusChangedEvent(hCurWin, hPrevWin)\r\n  EndIf\r\nEndFunction\r\n\r\nvoid function FocusChangedEventEx(Handle hwndFocus, int nObject, int nChild,\r\n                                  Handle hwndPrevFocus, int nPrevObject, int nPrevChild,\r\n\t                          int nChangeDepth)\r\n  If g_aiBrowserSayAllFlag Then\r\n    return\r\n  Else\r\n    FocusChangedEventEx(hwndFocus, nObject, nChild, hwndPrevFocus, nPrevObject, nPrevChild, nChangeDepth)\r\n  EndIf\r\nEndFunction\r\n\r\nint function FocusRedirected(Handle focusWindow, Handle prevWindow)\r\n  If g_aiBrowserSayAllFlag Then\r\n    return 1\r\n  Else\r\n    FocusRedirected(focusWindow, prevWindow)\r\n  EndIf\r\nEndFunction\r\n\r\nVoid Function SayTutorialHelp (int iObjType, int IsScriptKey)\r\n  If g_aiBrowserSayAllFlag Then\r\n    return\r\n  Else\r\n    SayTutorialHelp(iObjType, IsScriptKey)\r\n  EndIf\r\nEndFunction\r\n\r\nVoid Function SendaiBrowserMessage (Int param)\r\n  SendMessage(g_aiBrowserSayAllWindow, g_aiBrowserSayAllMessage, param, 0);\r\nEndFunction\r\n\r\nVoid Function SayAllStoppedEvent ()\r\n  PCCursor()\r\n  If (!SayAllInProgress()) Then\r\n    SendaiBrowserMessage(0)\r\n    PCCursor()\r\n  EndIf\r\nEndFunction\r\n\r\nScript JAWSCursor ()\r\nEndScript\r\n\r\nScript InvisibleCursor ()\r\nEndScript\r\n\r\nVoid Function ObserveSpeechFunction ()\r\n    If (SayAllInProgress()) Then\r\n    Else\r\n      If g_aiBrowserSayAllFlag != 1 Then\r\n        let g_aiBrowserSayAllWindow = FindWindow(GetAppMainWindow(GetFocus()), \"Jaws-aiBrowser-Communication\", \"\")\r\n        ;SayInteger(g_aiBrowserSayAllWindow)\r\n        ;SetActiveCursor(1)\r\n        ;MoveToWindow(g_aiBrowserSayAllWindow)\r\n        let g_aiBrowserSayAllMessage = RegisterWindowMessage(\"WM_JAWS_AIBROWSER_MESSAGE\")\r\n        let g_aiBrowserSayAllFlag = 1\r\n        PCCursor()\r\n        SetFocus(g_aiBrowserSayAllWindow)\r\n        PCCursor()\r\n        Delay(5, 0)\r\n      Else\r\n        If (GetFocus() != g_aiBrowserSayAllWindow) Then\r\n          SetFocus(g_aiBrowserSayAllWindow)\r\n        EndIf\r\n        PCCursor()\r\n      EndIf\r\n\r\n      PCCursor()\r\n      SayAll(0)\r\n      ;SkimRead()\r\n      PCCursor()\r\n    EndIf\r\nEndFunction\r\n\r\nScript ObserveSpeech ()\r\n  ObserveSpeechFunction()\r\nEndScript\r\n;--------------------------------------------------------------------------------\r\n");
    }

    private void outputPerformScript(PrintWriter pw, String func, String funcExec) {
        if (func.endsWith(")")) {
            pw.println("    PerformScript " + funcExec);
        } else {
            pw.println("    PerformScript " + func + "()");
        }
    }

    private void outputJawsSayAllStop(PrintWriter pw, Key key) {
        if (key.jawsSayAllStop) {
            pw.println("    If g_aiBrowserSayAllFlag Then");
            if (key.jawsSayAllStopIgnore) {
                pw.println("      return");
            } else {
                pw.println("      PerformScript AiBrowserSayAllOff()");
                pw.println("      SendaiBrowserMessage(1)");
                pw.println("      Delay(5, 1)");
            }
            pw.println("    EndIf");
        }
    }

    private void writeFunctions(PrintWriter pw) {
        pw.println("include \"" + this.appName + ".jsh\"");
        pw.println();
        pw.println("Script JawsOn ()");
        pw.println("  let " + this.flagName + " = 1");
        pw.println("EndScript");
        pw.println();
        pw.println("Script JawsOff ()");
        pw.println("  let " + this.flagName + " = 0");
        pw.println("EndScript");
        pw.println();
        this.writeFixedCode(pw);
        pw.println();
        pw.println();
        HashSet<String> generated = new HashSet<String>();
        int i = 0;
        while (i < this.keys.size()) {
            Key key = this.keys.get(i);
            if (key.jawsScript) {
                String func = this.getFuncName(key, 1);
                if (func != null) {
                    pw.println("Script " + key.toFuncString() + "()");
                    if (key.jawsHandle) {
                        this.outputPerformScript(pw, func, func);
                    } else {
                        pw.println("  If " + this.flagName + " Then");
                        this.outputPerformScript(pw, func, func);
                        pw.println("  Else");
                        this.outputJawsSayAllStop(pw, key);
                        pw.println("    TypeKey(\"" + key.toTypeString() + "\")");
                        pw.println("  EndIf");
                    }
                    pw.println("EndScript");
                    pw.println();
                    pw.println();
                } else {
                    func = this.getFuncName(key, 7);
                    String funcName = "";
                    String funcExec = "";
                    if (func != null) {
                        funcName = func.replaceAll("\\([0-9]\\)", "(int n)");
                        funcExec = func.replaceAll("\\([0-9]\\)", "(n)");
                    }
                    if (!generated.contains(funcName)) {
                        generated.add(funcName);
                        if (func != null) {
                            if (func.endsWith(")")) {
                                pw.println("Script " + funcName);
                            } else {
                                pw.println("Script " + func + "()");
                            }
                            pw.println("  If " + this.flagName + " Then");
                            this.outputPerformScript(pw, func, funcExec);
                            pw.println("  Else");
                            this.outputJawsSayAllStop(pw, key);
                            pw.println("    TypeCurrentScriptKey()");
                            pw.println("  EndIf");
                            pw.println("EndScript");
                            pw.println();
                            pw.println();
                        }
                    }
                    pw.println("Script " + key.toFuncString() + "()");
                    pw.println("  If " + this.flagName + " Then");
                    pw.println("    SayString(\"" + key.toString() + "\")");
                    pw.println("  EndIf");
                    this.outputJawsSayAllStop(pw, key);
                    if (key.jawsKey != null) {
                        if (key.jawsKey.currentScript) {
                            pw.println("  TypeCurrentScriptKey()");
                        } else {
                            pw.println("  TypeKey(\"" + key.jawsKey.toTypeString() + "\")");
                        }
                    } else {
                        pw.println("  TypeKey(\"" + key.toTypeString() + "\")");
                    }
                    pw.println("EndScript");
                    pw.println();
                    pw.println();
                }
            }
            ++i;
        }
    }

    private String getFuncName(Key key, int type) {
        String ret;
        if (this.isIt(type, 1) && (ret = this.getFucnName(this.keymaps_common, key)) != null) {
            return ret;
        }
        if (this.isIt(type, 2) && (ret = this.getFucnName(this.keymaps_quick, key)) != null) {
            return ret;
        }
        if (this.isIt(type, 4) && (ret = this.getFucnName(this.keymaps_virtual, key)) != null) {
            return ret;
        }
        return null;
    }

    private boolean isIt(int type, int mask) {
        return (type & mask) == mask;
    }

    private String getFucnName(Vector<Keymap> keymaps, Key key) {
        int i = 0;
        while (i < keymaps.size()) {
            if (keymaps.get(i).equals(key)) {
                return keymaps.get((int)i).scriptName;
            }
            ++i;
        }
        return null;
    }

    private void writeKeyMap(PrintWriter pw) {
        pw.println("[Common keys]");
        int i = 0;
        while (i < this.keys.size()) {
            Key key = this.keys.get(i);
            if (key.jawsScript) {
                pw.println(String.valueOf(key.toString()) + "=" + key.toFuncString());
            }
            ++i;
        }
    }
}

