/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.spi;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.actf.ai.xmlstore.IXMLInfo;
import org.eclipse.actf.ai.xmlstore.IXMLSelector;
import org.eclipse.actf.ai.xmlstore.IXMLStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStoreAggregator
implements IXMLStore {
    private final ArrayList<IXMLStore> stores;

    @Override
    public IXMLStore specify(IXMLSelector selector) {
        int len = this.stores.size();
        ArrayList<IXMLStore> newStores = new ArrayList<IXMLStore>(len);
        int i = 0;
        while (i < len) {
            IXMLStore st = this.stores.get(i);
            IXMLStore st2 = st.specify(selector);
            if (st2 != null) {
                newStores.add(st2);
            }
            ++i;
        }
        if (newStores.size() > 0) {
            return new XMLStoreAggregator(newStores);
        }
        return null;
    }

    @Override
    public void refleshAll() {
        int len = this.stores.size();
        int i = 0;
        while (i < len) {
            IXMLStore st = this.stores.get(i);
            st.refleshAll();
            ++i;
        }
    }

    public void addStore(IXMLStore store) {
        this.stores.add(store);
    }

    private XMLStoreAggregator(ArrayList<IXMLStore> stores) {
        this.stores = stores;
    }

    XMLStoreAggregator() {
        this.stores = new ArrayList();
    }

    @Override
    public Iterator<IXMLInfo> getInfoIterator() {
        return new AggregatorIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AggregatorIterator
    implements Iterator<IXMLInfo> {
        private int idx = 0;
        private Iterator<IXMLInfo> currentIterator;
        private IXMLInfo next;

        private void setNext() {
            if (this.currentIterator != null && this.currentIterator.hasNext()) {
                this.next = this.currentIterator.next();
                return;
            }
            int size = XMLStoreAggregator.this.stores.size();
            if (this.idx < size) {
                IXMLStore store = (IXMLStore)XMLStoreAggregator.this.stores.get(this.idx);
                this.currentIterator = store.getInfoIterator();
                ++this.idx;
                this.setNext();
                return;
            }
            this.next = null;
        }

        AggregatorIterator() {
            this.setNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public IXMLInfo next() {
            IXMLInfo ret = this.next;
            this.setNext();
            return ret;
        }

        @Override
        public void remove() {
        }
    }
}

