/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.xmlstore.nvdl.reader;

import java.io.IOException;
import java.net.URL;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.eclipse.actf.ai.xmlstore.nvdl.NVDLException;
import org.eclipse.actf.ai.xmlstore.nvdl.model.Location;
import org.eclipse.actf.ai.xmlstore.nvdl.model.NVDLValidateAction;
import org.eclipse.actf.ai.xmlstore.nvdl.reader.SchemaReaderProxy;
import org.eclipse.actf.ai.xmlstore.nvdl.util.Log;
import org.eclipse.actf.ai.xmlstore.nvdl.util.PrefixMapper;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

class SchemaLoader
implements NVDLValidateAction.SchemaLoader {
    private final String baseIRI;
    private String schemaNS;

    private void detectSchema(URL schemaURL) throws NVDLException {
        block3: {
            try {
                this.schemaNS = null;
                XMLReader r = XMLReaderFactory.createXMLReader();
                r.setContentHandler(new DefaultHandler(){

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        SchemaLoader.this.schemaNS = uri;
                        throw new SAXException("stop");
                    }
                });
                r.parse(schemaURL.toString());
            }
            catch (Exception e) {
                if (!(e instanceof IOException)) break block3;
                throw new NVDLException("SchemaLoader.OpenSchemaIOError", new Object[]{e.getLocalizedMessage()});
            }
        }
        if (this.schemaNS == null) {
            throw new NVDLException("SchemaLoader.SchemaTypeDetectionError", new Object[]{schemaURL});
        }
        Log.debug("Detected the schema type:" + this.schemaNS + " in " + schemaURL);
    }

    public Schema load(NVDLValidateAction validateAction, boolean forAttribute) throws NVDLException {
        String schemaIRI = validateAction.getSchemaIRI();
        if (schemaIRI == null) {
            return null;
        }
        try {
            URL baseURL = new URL(this.baseIRI);
            URL schemaURL = new URL(baseURL, schemaIRI);
            this.detectSchema(schemaURL);
            SchemaFactory sf = SchemaFactory.newInstance(this.schemaNS);
            Log.debug("Try to open schema:" + schemaURL);
            PrefixMapper prefixMapper = new PrefixMapper();
            SchemaReaderProxy schemaReaderProxy = SchemaReaderProxy.newProxy(null, prefixMapper);
            SAXLoader loader = new SAXLoader(schemaReaderProxy);
            return loader.getSchema(sf, schemaURL, this.schemaNS, forAttribute);
        }
        catch (Exception e) {
            if (e instanceof IllegalArgumentException) {
                throw new NVDLException("No appropriate validator implementation for " + this.schemaNS);
            }
            throw new NVDLException(e);
        }
    }

    SchemaLoader(String baseIRI, Location loc) {
        this.baseIRI = baseIRI;
    }

    private static class SAXLoader
    implements ContentHandler {
        private final SchemaReaderProxy schemaReaderProxy;

        Schema getSchema(SchemaFactory sf, URL schemaURL, String schemaNS, boolean forAttribute) throws SAXException, IOException {
            String systemId = schemaURL.toString();
            this.schemaReaderProxy.begin(sf, new InputSource(systemId), schemaNS, forAttribute);
            XMLReader r = XMLReaderFactory.createXMLReader();
            r.setFeature("http://xml.org/sax/features/namespaces", true);
            r.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            r.setContentHandler(this);
            r.parse(systemId);
            this.schemaReaderProxy.end();
            return this.schemaReaderProxy.getSchema();
        }

        SAXLoader(SchemaReaderProxy proxy) {
            this.schemaReaderProxy = proxy;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            this.schemaReaderProxy.characters(ch, start, length);
        }

        public void endDocument() throws SAXException {
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            this.schemaReaderProxy.endElement(uri, localName, qName);
        }

        public void endPrefixMapping(String prefix) throws SAXException {
            this.schemaReaderProxy.endPrefixMapping(prefix);
        }

        public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        }

        public void processingInstruction(String target, String data) throws SAXException {
            this.schemaReaderProxy.processingInstruction(target, data);
        }

        public void setDocumentLocator(Locator locator) {
            this.schemaReaderProxy.setDocumentLocator(locator);
        }

        public void skippedEntity(String arg0) throws SAXException {
        }

        public void startDocument() throws SAXException {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            this.schemaReaderProxy.startElement(uri, localName, qName, attributes);
        }

        public void startPrefixMapping(String prefix, String uri) throws SAXException {
            this.schemaReaderProxy.startPrefixMapping(prefix, uri);
        }
    }
}

