/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.treemanager.impl;

import java.util.ArrayList;
import org.eclipse.actf.ai.fennec.FennecException;
import org.eclipse.actf.ai.fennec.FennecInterruptedException;
import org.eclipse.actf.ai.fennec.IFennecService;
import org.eclipse.actf.ai.fennec.treemanager.IAccessKeyList;
import org.eclipse.actf.ai.fennec.treemanager.ILocation;
import org.eclipse.actf.ai.fennec.treemanager.ISoundControl;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.fennec.treemanager.ITreeManager;
import org.eclipse.actf.ai.fennec.treemanager.IVideoControl;
import org.eclipse.actf.ai.fennec.treemanager.TreeManagerException;
import org.eclipse.actf.ai.fennec.treemanager.TreeManagerInterruptedException;
import org.eclipse.actf.ai.fennec.treemanager.impl.LocationImpl;
import org.eclipse.actf.model.dom.dombycom.IFlashNode;
import org.eclipse.actf.util.vocab.IEvalTarget;
import org.eclipse.actf.util.vocab.IProposition;
import org.eclipse.actf.util.vocab.Vocabulary;

public class TreeManagerImpl
implements ITreeManager {
    private IFennecService fennecService;

    public TreeManagerImpl(IFennecService fennecService) {
        this.fennecService = fennecService;
    }

    public int getLevel() throws TreeManagerException {
        int i = 0;
        ITreeItem ita = this.getActiveItem();
        if (ita == null) {
            return 0;
        }
        while ((ita = ita.getParent()) != null) {
            ++i;
        }
        return i;
    }

    public ITreeItem getActiveItem() throws TreeManagerException {
        return this.fennecService.getLastTreeItem();
    }

    public ITreeItem[] getSiblings() throws TreeManagerException {
        ITreeItem item = this.getActiveItem();
        if (item == null) {
            return null;
        }
        ITreeItem parent = item.getParent();
        if (parent == null) {
            ITreeItem[] itas = new ITreeItem[]{this.getActiveItem()};
            return itas;
        }
        return parent.getChildItems();
    }

    private void initFennecService() throws TreeManagerException {
        if (this.fennecService.getStatus() == 1) {
            return;
        }
        try {
            this.fennecService.initialize();
        }
        catch (FennecInterruptedException e) {
            throw new TreeManagerInterruptedException(256, e.getMessage(), e);
        }
        catch (FennecException e) {
            throw new TreeManagerException(65536, e.getMessage(), e);
        }
    }

    public int initialize() throws TreeManagerException {
        this.initFennecService();
        return 0;
    }

    private int moveUpdate(ITreeItem target, boolean update) throws TreeManagerException {
        try {
            return this.fennecService.moveUpdate(target, update);
        }
        catch (FennecInterruptedException e) {
            throw new TreeManagerInterruptedException(256, "Failed to update by move.", e);
        }
        catch (FennecException e) {
            throw new TreeManagerException(65536, "Failed to update by move.", e);
        }
    }

    private int clickUpdate(ITreeItem target) throws TreeManagerException {
        try {
            return this.fennecService.clickUpdate(target);
        }
        catch (FennecInterruptedException e) {
            throw new TreeManagerInterruptedException(256, "Failed to update by click.", e);
        }
        catch (FennecException e) {
            throw new TreeManagerException(65536, "Failed to update by click.", e);
        }
    }

    private int gotoRoot() throws TreeManagerException {
        ITreeItem parent = this.getActiveItem().getParent();
        if (parent == null) {
            return 0;
        }
        while (this.gotoParent() != 0) {
        }
        return 3;
    }

    public int stay() throws TreeManagerException {
        this.initFennecService();
        return this.getActiveItem().stay();
    }

    public int click(boolean doClick) throws TreeManagerException {
        this.initFennecService();
        ITreeItem item = this.getActiveItem();
        if (doClick) {
            item.doClick();
        }
        return this.clickUpdate(item);
    }

    public int gotoParent() throws TreeManagerException {
        this.initFennecService();
        ITreeItem parent = this.getActiveItem().getParent();
        if (parent != null) {
            int st = this.moveUpdate(parent, true);
            if ((st & 1) != 0) {
                st |= 2;
            }
            return st;
        }
        return 0;
    }

    public int gotoFirstChild() throws TreeManagerException {
        this.initFennecService();
        ITreeItem active = this.getActiveItem();
        ITreeItem[] childItems = active.getChildItems();
        if (childItems.length == 0) {
            return 0;
        }
        int st = this.moveUpdate(childItems[0], true);
        if ((st & 1) != 0) {
            st |= 2;
        }
        return st;
    }

    private int gotoLastChild() throws TreeManagerException {
        this.initFennecService();
        ITreeItem active = this.getActiveItem();
        ITreeItem[] childItems = active.getChildItems();
        if (childItems.length == 0) {
            return 0;
        }
        int st = this.moveUpdate(childItems[childItems.length - 1], true);
        if ((st & 1) != 0) {
            st |= 2;
        }
        return st;
    }

    private int gotoSiblingIndex(int idx) throws TreeManagerException {
        this.initFennecService();
        ITreeItem active = this.getActiveItem();
        ITreeItem[] siblingItems = this.getSiblings();
        if (idx < 0 || siblingItems.length <= idx || active.equals(siblingItems[idx])) {
            return 0;
        }
        int st = this.moveUpdate(siblingItems[idx], true);
        return st;
    }

    private int getActiveIndex() throws TreeManagerException {
        this.initFennecService();
        return this.getActiveItem().getNth();
    }

    public int gotoStartOfSiblings() throws TreeManagerException {
        return this.gotoSiblingIndex(0);
    }

    public int gotoEndOfSiblings() throws TreeManagerException {
        this.initFennecService();
        ITreeItem[] siblingItems = this.getSiblings();
        int st = this.moveUpdate(siblingItems[siblingItems.length - 1], true);
        return st | 1;
    }

    public int gotoPreviousSibling() throws TreeManagerException {
        int idx = this.getActiveIndex();
        return this.gotoSiblingIndex(idx - 1);
    }

    public int gotoNextSibling() throws TreeManagerException {
        int idx = this.getActiveIndex();
        return this.gotoSiblingIndex(idx + 1);
    }

    public int gotoStartOfPage() throws TreeManagerException {
        ITreeItem item = this.getCurrentRootItem();
        this.moveUpdate(item, true);
        return 0;
    }

    public int gotoEndOfPageForFind() throws TreeManagerException {
        int st;
        this.gotoStartOfPage();
        do {
            st = this.gotoEndOfSiblings();
        } while (this.gotoFirstChild() != 0);
        if ((st & 1) != 0) {
            st |= 2;
        }
        return st;
    }

    public int gotoEndOfPage() throws TreeManagerException {
        int st;
        this.gotoStartOfPage();
        do {
            st = this.gotoEndOfSiblings();
        } while (this.gotoFirstChild() != 0);
        ITreeItem item = this.getActiveItem();
        while (!Vocabulary.hasReadingContent().eval((IEvalTarget)item)) {
            st = this.traverse(true);
            item = this.getActiveItem();
        }
        if ((st & 1) != 0) {
            st |= 2;
        }
        return st;
    }

    public int gotoPreviousLine() throws TreeManagerException {
        return 0;
    }

    public int gotoNextLine() throws TreeManagerException {
        return 0;
    }

    public int gotoStartOfLine() throws TreeManagerException {
        return 0;
    }

    public int gotoEndOfLine() throws TreeManagerException {
        return 0;
    }

    private int findItem(boolean back, IProposition proposition) throws TreeManagerException {
        try {
            ITreeItem item;
            int rc;
            int[] pos = this.getActivePos();
            int level = pos.length;
            if (back) {
                rc = this.traverse(true);
                item = this.getActiveItem();
                rc = proposition.eval((IEvalTarget)item) ? (rc |= 0x40) : this.fennecService.searchBackward(proposition);
            } else {
                rc = this.traverse(false);
                item = this.getActiveItem();
                rc = proposition.eval((IEvalTarget)item) ? (rc |= 0x40) : this.fennecService.searchForward(proposition);
            }
            if ((rc & 0x40) == 0) {
                this.setActivePos(pos);
                return rc;
            }
            item = this.getActiveItem();
            if (back) {
                int st;
                ITreeItem[] siblings = this.getSiblings();
                int idx = item.getNth();
                if (idx != (st = this.intervalStart(siblings, idx))) {
                    rc |= this.moveUpdate(siblings[st], false);
                }
                item = this.getActiveItem();
            }
            if (!Vocabulary.hasReadingContent().eval((IEvalTarget)item)) {
                this.traverse(false);
            }
            if (level != this.getLevel()) {
                rc |= 2;
            }
            return rc;
        }
        catch (FennecInterruptedException e) {
            throw new TreeManagerInterruptedException(256, "Failed to search.", e);
        }
        catch (FennecException e) {
            throw new TreeManagerException(65536, "Failed to search.", e);
        }
    }

    private int[] getActivePos() throws TreeManagerException {
        int[] ret = new int[this.getLevel()];
        ITreeItem current = this.getActiveItem();
        int count = ret.length;
        while (count > 0) {
            ret[count - 1] = current.getNth();
            --count;
            current = current.getParent();
        }
        return ret;
    }

    private int setActivePos(int[] indexes) throws TreeManagerException {
        this.gotoRoot();
        int st = 0;
        int i = 0;
        while (i < indexes.length) {
            ITreeItem item = this.getActiveItem();
            ITreeItem[] children = item.getChildItems();
            int idx = indexes[i];
            if (children == null || idx >= children.length) break;
            st |= this.moveUpdate(children[idx], true);
            ++i;
        }
        return st;
    }

    public int findNext(IProposition proposition) throws TreeManagerException {
        return this.findItem(false, proposition);
    }

    public int findPrevious(IProposition proposition) throws TreeManagerException {
        return this.findItem(true, proposition);
    }

    private int traverseForward(ITreeItem active) throws TreeManagerException {
        ITreeItem[] childItems = active.getChildItems();
        if (childItems.length != 0) {
            int st = this.moveUpdate(childItems[0], false);
            return st;
        }
        int idx = active.getNth();
        ITreeItem[] siblings = this.getSiblings();
        if (idx >= 0 && idx + 1 < siblings.length) {
            int st = this.moveUpdate(siblings[idx + 1], false);
            return st;
        }
        int upCount = 1;
        while (true) {
            ITreeItem parent;
            if ((parent = (active = this.getActiveItem()).getParent()) == null) {
                while (upCount > 0) {
                    this.gotoLastChild();
                    --upCount;
                }
                return 0;
            }
            if (this.moveUpdate(parent, false) == 0) {
                throw new TreeManagerException(65536, "Internal Error.");
            }
            idx = this.getActiveIndex();
            siblings = this.getSiblings();
            if (idx >= 0 && idx + 1 < siblings.length) {
                int st = this.moveUpdate(siblings[idx + 1], false);
                return st;
            }
            ++upCount;
        }
    }

    private int traverseBackward() throws TreeManagerException {
        ITreeItem active;
        ITreeItem[] childItems;
        int idx = this.getActiveIndex();
        if (idx <= 0) {
            ITreeItem active2 = this.getActiveItem();
            ITreeItem parent = active2.getParent();
            if (parent == null) {
                return 0;
            }
            int st = this.moveUpdate(parent, false);
            return st;
        }
        ITreeItem[] siblings = this.getSiblings();
        int st = this.moveUpdate(siblings[idx - 1], false);
        while ((childItems = (active = this.getActiveItem()).getChildItems()).length != 0) {
            st |= this.moveUpdate(childItems[0], false) | 2;
            siblings = this.getSiblings();
            if (siblings.length <= 1) continue;
            st |= this.moveUpdate(siblings[siblings.length - 1], false);
        }
        return st;
    }

    private int intervalStart(ITreeItem[] siblings, int st) {
        --st;
        while (st >= 0) {
            if (!Vocabulary.isConnectable().eval((IEvalTarget)siblings[st])) {
                return st + 1;
            }
            --st;
        }
        return 0;
    }

    private int intervalEnd(ITreeItem[] siblings, int end) {
        while (end < siblings.length) {
            if (!Vocabulary.isConnectable().eval((IEvalTarget)siblings[end])) {
                return end;
            }
            ++end;
        }
        return end - 1;
    }

    public int traverse(boolean back) throws TreeManagerException {
        ITreeItem orig;
        this.initFennecService();
        ITreeItem current = orig = this.getActiveItem();
        int level = this.getLevel();
        int rc = 0;
        if (back) {
            int st;
            do {
                rc = this.traverseBackward();
                current = this.getActiveItem();
            } while (rc != 0 && !Vocabulary.hasReadingContent().eval((IEvalTarget)current));
            ITreeItem[] siblings = this.getSiblings();
            int idx = current.getNth();
            if (idx != (st = this.intervalStart(siblings, idx))) {
                rc |= this.moveUpdate(siblings[st], false);
            }
        } else {
            ITreeItem[] siblings = this.getSiblings();
            int idx = current.getNth();
            int end = this.intervalEnd(siblings, idx);
            current = siblings[end];
            do {
                rc = this.traverseForward(current);
                current = this.getActiveItem();
            } while (rc != 0 && !Vocabulary.hasReadingContent().eval((IEvalTarget)current));
        }
        if (!orig.equals(current) && level != this.getLevel()) {
            rc |= 2;
        }
        return rc;
    }

    public String[] getActiveStrings() throws TreeManagerException {
        this.initFennecService();
        ArrayList<String> al = new ArrayList<String>();
        ITreeItem[] siblings = this.getSiblings();
        int i = this.getActiveIndex();
        while (i < siblings.length) {
            ITreeItem[] childItems;
            ITreeItem current = siblings[i];
            String str = current.getUIString();
            if (str.length() > 0) {
                al.add(str);
            }
            if ((childItems = current.getChildItems()).length > 0) break;
            ++i;
        }
        return al.toArray(new String[0]);
    }

    public int gotoLeftCell() throws TreeManagerException {
        return 0;
    }

    public int gotoRightCell() throws TreeManagerException {
        return 0;
    }

    public int gotoUpCell() throws TreeManagerException {
        return 0;
    }

    public int gotoDownCell() throws TreeManagerException {
        return 0;
    }

    public int getActiveTableInfo() throws TreeManagerException {
        return 0;
    }

    public int getActiveTableCellInfo() throws TreeManagerException {
        return 0;
    }

    public ITreeItem getCurrentRootItem() throws TreeManagerException {
        ITreeItem parent;
        this.initFennecService();
        ITreeItem current = this.getActiveItem();
        while ((parent = current.getParent()) != null) {
            current = parent;
        }
        return current;
    }

    public ISoundControl getSoundControl() throws TreeManagerException {
        this.initFennecService();
        return this.fennecService.getSoundControl();
    }

    public IVideoControl getVideoControl() throws TreeManagerException {
        this.initFennecService();
        return this.fennecService.getVideoControl();
    }

    public IAccessKeyList getAccessKeyList() throws TreeManagerException {
        this.initFennecService();
        return this.fennecService.getAccessKeyList();
    }

    public int analyze() throws TreeManagerException {
        this.initFennecService();
        try {
            return this.fennecService.analyze();
        }
        catch (FennecException e) {
            throw new TreeManagerException(65536, "Failed to analyze", e);
        }
    }

    public ILocation getCurrentLocation() throws TreeManagerException {
        this.initFennecService();
        return new LocationImpl(this.getActivePos());
    }

    public int moveToLocation(ILocation location) throws TreeManagerException {
        this.initFennecService();
        LocationImpl loc = (LocationImpl)location;
        int[] pos = loc.getPos();
        return this.setActivePos(pos);
    }

    public ITreeItem expandWholeTree() throws TreeManagerException {
        this.initFennecService();
        try {
            return this.fennecService.expandWholeTree();
        }
        catch (FennecException e) {
            throw new TreeManagerException(65536, "Failed to expand the whole tree", e);
        }
    }

    public int skipToAnchor(String target) throws TreeManagerException {
        this.initFennecService();
        try {
            return this.fennecService.skipToAnchor(target);
        }
        catch (FennecException e) {
            throw new TreeManagerException(65536, "Failed to find the target in the anchors", e);
        }
    }

    public void repairFlash() throws TreeManagerException {
        this.initFennecService();
        IFlashNode[] node = this.fennecService.getFlashTopNodes();
        int i = 0;
        while (i < node.length) {
            node[i].repairFlash();
            ++i;
        }
    }
}

