/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.ai.fennec.treemanager;

import org.eclipse.actf.ai.fennec.treemanager.IAccessKeyList;
import org.eclipse.actf.ai.fennec.treemanager.ILocation;
import org.eclipse.actf.ai.fennec.treemanager.ISoundControl;
import org.eclipse.actf.ai.fennec.treemanager.ITreeItem;
import org.eclipse.actf.ai.fennec.treemanager.IVideoControl;
import org.eclipse.actf.ai.fennec.treemanager.TreeManagerException;
import org.eclipse.actf.util.vocab.IProposition;

public interface ITreeManager {
    public static final int NOACTION = 0;
    public static final int MOVED = 1;
    public static final int LEVEL_CHANGED = 2;
    public static final int TRANSFERRED = 4;
    public static final int CLICKED = 8;
    public static final int CHANGED = 16;
    public static final int PARENT_CHANGED = 32;
    public static final int FOUND = 64;
    public static final int UNDONE = 256;
    public static final int ERROR = 65536;

    public int getLevel() throws TreeManagerException;

    public ITreeItem getActiveItem() throws TreeManagerException;

    public ISoundControl getSoundControl() throws TreeManagerException;

    public IVideoControl getVideoControl() throws TreeManagerException;

    public IAccessKeyList getAccessKeyList() throws TreeManagerException;

    public ITreeItem[] getSiblings() throws TreeManagerException;

    public int initialize() throws TreeManagerException;

    public int stay() throws TreeManagerException;

    public int click(boolean var1) throws TreeManagerException;

    public int gotoParent() throws TreeManagerException;

    public int gotoFirstChild() throws TreeManagerException;

    public int gotoStartOfSiblings() throws TreeManagerException;

    public int gotoEndOfSiblings() throws TreeManagerException;

    public int gotoPreviousSibling() throws TreeManagerException;

    public int gotoNextSibling() throws TreeManagerException;

    public int gotoStartOfPage() throws TreeManagerException;

    public int gotoEndOfPage() throws TreeManagerException;

    public int traverse(boolean var1) throws TreeManagerException;

    public int gotoPreviousLine() throws TreeManagerException;

    public int gotoNextLine() throws TreeManagerException;

    public int gotoStartOfLine() throws TreeManagerException;

    public int gotoEndOfLine() throws TreeManagerException;

    public int findNext(IProposition var1) throws TreeManagerException;

    public int findPrevious(IProposition var1) throws TreeManagerException;

    public int skipToAnchor(String var1) throws TreeManagerException;

    public int gotoLeftCell() throws TreeManagerException;

    public int gotoRightCell() throws TreeManagerException;

    public int gotoUpCell() throws TreeManagerException;

    public int gotoDownCell() throws TreeManagerException;

    public int getActiveTableInfo() throws TreeManagerException;

    public int getActiveTableCellInfo() throws TreeManagerException;

    public ITreeItem getCurrentRootItem() throws TreeManagerException;

    public int analyze() throws TreeManagerException;

    public ILocation getCurrentLocation() throws TreeManagerException;

    public int moveToLocation(ILocation var1) throws TreeManagerException;

    public ITreeItem expandWholeTree() throws TreeManagerException;

    public int gotoEndOfPageForFind() throws TreeManagerException;

    public void repairFlash() throws TreeManagerException;
}

