/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.jar;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class InstallJars {
    public static final int BLOCK_SIZE = 512;
    public static final int BLOCK_COUNT = 20;
    public static int bufferSize = 131072;
    protected boolean verbose;
    protected boolean run;
    protected boolean expand;
    protected String propFilename;
    protected String javaParams = "cmd /c java";
    protected static final int OFFSET_NAME = 0;
    protected static final int OFFSET_MODE = 100;
    protected static final int OFFSET_UID = 108;
    protected static final int OFFSET_GID = 116;
    protected static final int OFFSET_SIZE = 124;
    protected static final int OFFSET_MTIME = 136;
    protected static final int OFFSET_CHKSUM = 148;
    protected static final int OFFSET_TYPE = 156;
    protected static final int OFFSET_LINKNAME = 157;
    protected static final int OFFSET_MAGIC = 257;
    protected static final int OFFSET_VERSION = 263;
    protected static final int OFFSET_UNAME = 265;
    protected static final int OFFSET_GNAME = 297;
    protected static final int OFFSET_DEVMAJOR = 329;
    protected static final int OFFSET_DEVMINOR = 337;
    protected static final int OFFSET_PREFIX = 345;
    protected static final int OFFSET_END = 500;
    protected static final String MAGIC = "USTAR";

    public InstallJars() {
        this(true, true, true, "InstallJars.properties", "cmd /c java");
    }

    public InstallJars(boolean expand, boolean verbose, boolean run, String propName, String javaParams) {
        this.setExpand(expand);
        this.setVerbose(verbose);
        this.setRunMode(run);
        this.setPropFilename(propName);
        this.setJavaParams(javaParams);
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean f) {
        this.verbose = f;
    }

    public boolean getRunMode() {
        return this.run;
    }

    public void setRunMode(boolean f) {
        this.run = f;
    }

    public boolean getExpand() {
        return this.expand;
    }

    public void setExpand(boolean f) {
        this.expand = f;
    }

    public String getPropFilename() {
        return this.propFilename;
    }

    public void setPropFilename(String name) {
        this.propFilename = name;
    }

    public String getJavaParams() {
        return this.javaParams;
    }

    public void setJavaParams(String p) {
        this.javaParams = p;
    }

    protected void print(String s) {
        if (this.verbose) {
            System.out.print(s);
        }
    }

    protected void println(String s) {
        if (this.verbose) {
            System.out.println(s);
        }
    }

    protected void println() {
        this.println("");
    }

    public String install() throws IOException {
        StringBuffer classpath = new StringBuffer();
        Properties prop = new Properties();
        prop.load(new BufferedInputStream(new FileInputStream(this.propFilename)));
        for (String string : prop.keySet()) {
            String value = prop.getProperty(string);
            String xurl = null;
            String xdir = null;
            String xcp = null;
            boolean xexpand = this.expand;
            boolean xrun = this.run;
            if (value != null && (value = value.trim()).length() > 0) {
                String delim = value.substring(0, 1);
                StringTokenizer st = new StringTokenizer(value.substring(1), delim);
                xurl = st.nextToken();
                xdir = (st.hasMoreTokens() ? st.nextToken() : ".").trim();
                if (xdir.length() == 0) {
                    xdir = ".";
                }
                if ((xcp = (st.hasMoreTokens() ? st.nextToken() : xdir).trim()).length() == 0) {
                    xcp = xdir;
                }
                classpath.append(xcp);
                classpath.append(";");
                while (st.hasMoreTokens()) {
                    String xoption = st.nextToken().trim();
                    if (xoption.equalsIgnoreCase("expand")) {
                        xexpand = true;
                        continue;
                    }
                    if (xoption.equalsIgnoreCase("noexpand")) {
                        xexpand = false;
                        continue;
                    }
                    if (xoption.equalsIgnoreCase("run")) {
                        xrun = true;
                        continue;
                    }
                    if (xoption.equalsIgnoreCase("norun")) {
                        xrun = false;
                        continue;
                    }
                    throw new IllegalArgumentException("invalid install property - " + string + "=" + value);
                }
            }
            if (xurl == null || xurl.length() == 0) {
                throw new IllegalArgumentException("missing install property - " + string + "=" + value);
            }
            System.out.print("\nInstalling " + string);
            if (this.verbose) {
                System.out.print(" using URL=" + xurl + "; target=" + xdir + "; classpath=" + xcp + "; " + (xexpand ? "expand" : "noexpand") + "; " + (xrun ? "run" : "norun"));
            }
            System.out.println("...");
            this.installFile(xurl, xdir, xexpand, xrun);
        }
        return classpath.toString();
    }

    public void installFile(String fileUrl, String targetPath, boolean doExpand, boolean doRun) throws IOException {
        String targetFilename = new File(targetPath).getCanonicalPath().replace('\\', '/');
        this.println("Installing in " + targetFilename);
        URL url = new URL(fileUrl);
        URLConnection conn = url.openConnection();
        String ctype = conn.getContentType();
        this.println("Content type is " + ctype);
        String extension = this.getExtension(fileUrl);
        if (extension.equals("class")) {
            this.installClass(conn, targetFilename, doExpand, doRun);
        } else if (extension.equalsIgnoreCase("zip")) {
            this.installZip(conn, targetFilename, doExpand, doRun);
        } else if (extension.equalsIgnoreCase("gz")) {
            this.installGZip(conn, targetFilename, doExpand, doRun);
        } else if (extension.equalsIgnoreCase("jar")) {
            this.installJar(conn, targetFilename, doExpand, doRun);
        } else {
            throw new IllegalArgumentException("Unknown extension - " + extension);
        }
    }

    public void installClass(URLConnection conn, String target, boolean doExpand, boolean doRun) throws IOException {
        this.print("Installing class file " + target + " from " + conn.getURL().toExternalForm());
        this.copyStream(conn, target);
        this.println();
        if (doRun) {
            this.runTarget(target, false);
        }
    }

    protected void runTarget(String target, boolean isJar) throws IOException {
        if (isJar) {
            System.out.println("runTarget(" + target + "," + isJar + ") not currently implemented");
        } else {
            try {
                String name = this.removeExtension(this.getFile(target));
                String cp = "-cp " + this.removeFile(target);
                String command = String.valueOf(this.javaParams) + " " + cp + " " + name + " >" + name + ".out 2>" + name + ".err";
                System.out.println("Running " + command + "...");
                Process p = Runtime.getRuntime().exec(command);
                int rc = p.waitFor();
                System.out.println("Return code=" + rc);
            }
            catch (Exception e) {
                System.out.println("Exception - " + e.getMessage());
            }
        }
    }

    public void installJar(URLConnection conn, String target, boolean doExpand, boolean doRun) throws IOException {
        if (doExpand) {
            this.println("Expanding JAR file " + target + " from " + conn.getURL().toExternalForm());
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(conn.getInputStream(), 10240));
            int count = 0;
            this.prepDirs(target, true);
            try {
                while (zis.available() > 0) {
                    ZipEntry ze = zis.getNextEntry();
                    this.copyEntry(target, zis, ze);
                    ++count;
                }
            }
            catch (Throwable throwable) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zis.close();
            }
            catch (IOException iOException) {}
            this.println("Installed " + count + " files/directories");
        } else {
            this.print("Installing JAR file " + target + " from " + conn.getURL().toExternalForm());
            this.copyStream(conn, target);
            this.println();
            if (doRun) {
                this.runTarget(target, true);
            }
        }
    }

    public void installZip(URLConnection conn, String target, boolean doExpand, boolean doRun) throws IOException {
        if (doExpand) {
            String ctype = conn.getContentType();
            if (!ctype.equals("application/zip")) {
                throw new IllegalArgumentException("Unkexpected content type - " + ctype);
            }
            this.println("Expanding ZIP file to " + target + " from " + conn.getURL().toExternalForm());
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(conn.getInputStream(), 10240));
            int count = 0;
            this.prepDirs(target, true);
            try {
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    this.copyEntry(target, zis, ze);
                    ++count;
                    ze = zis.getNextEntry();
                }
            }
            catch (Throwable throwable) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zis.close();
            }
            catch (IOException iOException) {}
            this.println("Installed " + count + " files/directories");
        } else {
            this.print("Installing ZIP file " + target + " from " + conn.getURL().toExternalForm());
            this.copyStream(conn, target);
            this.println();
        }
    }

    public void installGZip(URLConnection conn, String target, boolean doExpand, boolean doRun) throws IOException {
        if (doExpand) {
            String ctype = conn.getContentType();
            if (!ctype.equals("application/x-tar")) {
                throw new IllegalArgumentException("Unkexpected content type - " + ctype);
            }
            this.print("Expanding GZIP file to " + target + " from " + conn.getURL().toExternalForm());
            this.prepDirs(target, false);
            GZIPInputStream zis = new GZIPInputStream(new BufferedInputStream(conn.getInputStream(), 10240));
            try {
                this.pumpGZip(target, zis);
            }
            catch (Throwable throwable) {
                try {
                    zis.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                zis.close();
            }
            catch (IOException iOException) {}
            this.println();
        } else {
            this.print("Installing GZIP file " + target + " from " + conn.getURL().toExternalForm());
            this.copyStream(conn, target);
            this.println();
        }
    }

    protected void copyEntry(String target, ZipInputStream zis, ZipEntry ze) throws IOException {
        String name = ze.getName();
        boolean isDir = false;
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
            isDir = true;
        }
        String path = String.valueOf(target) + File.separator + name;
        path = path.replace('\\', '/');
        String mod = ze.getSize() > 0L ? "[" + ze.getCompressedSize() + ":" + ze.getSize() + "]" : "";
        this.print("Expanding " + ze + mod + " to " + path);
        this.prepDirs(path, isDir);
        if (!isDir) {
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(path), 10240);
            try {
                byte[] buf = new byte[bufferSize];
                int size = zis.read(buf, 0, buf.length);
                int count = 0;
                while (size >= 0) {
                    os.write(buf, 0, size);
                    size = zis.read(buf, 0, buf.length);
                    ++count;
                }
            }
            catch (Throwable throwable) {
                try {
                    os.flush();
                    os.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                os.flush();
                os.close();
            }
            catch (IOException iOException) {}
        }
        this.println();
    }

    public void copyStream(URLConnection conn, String target) throws IOException {
        this.prepDirs(target, false);
        BufferedInputStream is = new BufferedInputStream(conn.getInputStream(), 10240);
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(target), 10240);
        byte[] buf = new byte[bufferSize];
        int size = is.read(buf);
        int count = 0;
        while (size >= 0) {
            os.write(buf, 0, size);
            size = is.read(buf);
            ++count;
        }
        os.flush();
        os.close();
        is.close();
    }

    protected void pumpGZip(String target, GZIPInputStream zis) throws IOException {
        int loaded;
        String curName = null;
        long curSize = 0L;
        long remainingSize = 0L;
        char curType = '\u0000';
        int curMajor = 0;
        int curMinor = 0;
        boolean inFile = false;
        BufferedOutputStream curOs = null;
        int instFiles = 0;
        int instDirs = 0;
        byte[] buf = new byte[bufferSize];
        block2: while ((loaded = this.loadBytes(buf, zis)) >= 0) {
            int index = 0;
            while (index < loaded) {
                if (inFile && remainingSize > 0L) {
                    int xsize = Math.min((int)remainingSize, 512);
                    if (curOs != null) {
                        curOs.write(buf, index, xsize);
                    }
                    remainingSize -= (long)xsize;
                } else {
                    if (inFile) {
                        inFile = false;
                        if (curOs != null) {
                            try {
                                curOs.flush();
                                curOs.close();
                            }
                            catch (IOException iOException) {}
                            this.println();
                        }
                    }
                    if (this.isEmptyBlock(buf, index)) break block2;
                    curName = this.extractString(buf, index + 0, 100);
                    curType = this.extractChar(buf, index + 156);
                    curSize = this.extractLong(buf, index + 124, 12);
                    remainingSize = curSize;
                    if (remainingSize > Integer.MAX_VALUE) {
                        throw new IOException("entry size too large - " + remainingSize);
                    }
                    String mod = "";
                    String magic = this.extractString(buf, index + 257, 6);
                    if (magic.equals(MAGIC)) {
                        curName = String.valueOf(this.extractString(buf, index + 345, 155)) + curName;
                        this.extractInt(buf, index + 263, 2);
                        curMajor = this.extractInt(buf, index + 329, 8);
                        curMinor = this.extractInt(buf, index + 337, 8);
                        if (curMajor > 0 || curMinor > 0) {
                            mod = "[" + curMajor + '.' + curMinor + "]";
                        }
                    }
                    String path = String.valueOf(target) + File.separator + curName;
                    path = path.replace('\\', '/');
                    curOs = null;
                    if (curType == '\u0000' || curType == '0') {
                        this.print("Copying " + curName + mod + " to " + path);
                        this.prepDirs(path, false);
                        curOs = new BufferedOutputStream(new FileOutputStream(path), 10240);
                        inFile = true;
                        ++instFiles;
                    } else if (curType == '1' || curType == '2') {
                        if (curSize > 0L) {
                            throw new IOException("link entries cannot have content - " + curSize);
                        }
                        this.println("Link ignored - " + curName + mod);
                    } else if (curType == '5') {
                        if (path.endsWith("/")) {
                            path = path.substring(0, path.length() - 1);
                        }
                        this.println("Mkdir " + curName + mod + " to " + path);
                        this.prepDirs(path, true);
                        ++instDirs;
                    } else {
                        if (curSize > 0L) {
                            inFile = true;
                        }
                        this.print("Entry type " + curType + " ignored - " + curName + mod);
                    }
                }
                index += 512;
            }
        }
        this.println("Installed " + instFiles + " files and " + instDirs + " directories");
    }

    protected int loadBytes(byte[] buf, GZIPInputStream zis) throws IOException {
        int loaded = -1;
        int size = zis.read(buf, 0, buf.length);
        int count = 0;
        while (size > 0) {
            if (loaded < 0) {
                loaded = 0;
            }
            size = zis.read(buf, loaded += size, buf.length - loaded);
            ++count;
        }
        return loaded;
    }

    protected boolean isEmptyBlock(byte[] buf, int index) {
        boolean r = true;
        int i = 0;
        while (r && i < 512) {
            r = buf[index++] == 0;
            ++i;
        }
        return r;
    }

    protected char extractChar(byte[] buf, int index) throws IOException {
        return (char)buf[index];
    }

    protected int extractInt(byte[] buf, int index, int length) throws IOException {
        return (int)this.extractLong(buf, index, length);
    }

    protected long extractLong(byte[] buf, int index, int length) throws IOException {
        String xsize = this.extractString(buf, index, length);
        long v = 0L;
        int i = 0;
        while (i < xsize.length()) {
            char c = xsize.charAt(i);
            if (c != ' ') {
                if (c < '0' || c > '7') {
                    throw new IOException("non-octal digit found - " + c);
                }
                v = v * 8L + (long)(c - 48);
            }
            ++i;
        }
        return v;
    }

    protected String extractString(byte[] buf, int index, int length) throws IOException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int xindex = index;
        while (i < length) {
            byte c = buf[xindex];
            if (c == 0) break;
            sb.append((char)c);
            ++i;
            ++xindex;
        }
        return sb.toString();
    }

    protected String getFile(String name) {
        int posn = name.lastIndexOf("/");
        return posn > 0 ? name.substring(posn + 1) : name;
    }

    protected String removeFile(String name) {
        int posn = name.lastIndexOf("/");
        return posn > 0 ? name.substring(0, posn) : name;
    }

    protected String removeExtension(String name) {
        int posn1 = name.lastIndexOf("/");
        int posn2 = name.lastIndexOf(".");
        return posn2 > 0 && posn2 > posn1 ? name.substring(0, posn2) : name;
    }

    protected String extraceFile(String name) {
        int posn = name.lastIndexOf(File.separator);
        return posn >= 0 ? name.substring(posn + 1) : null;
    }

    protected String getExtension(String name) {
        int posn = name.lastIndexOf(46);
        return posn >= 0 ? name.substring(posn + 1) : "";
    }

    protected void prepDirs(String name) {
        this.prepDirs(name, this.expand);
    }

    protected void prepDirs(String name, boolean includeLast) {
        File f = new File(includeLast ? name : this.removeFile(name));
        f.mkdirs();
    }

    protected void printUsage() {
        this.println("Effective command: " + this.getClass().getName() + " " + this.propFilename + (this.expand ? " -expand" : " -noexpand") + (this.run ? " -run" : " -norun") + " -java \"" + this.javaParams + "\"" + (this.verbose ? " -verbose" : " -quiet "));
    }

    protected static void printHelp() {
        System.out.println();
        System.out.println("Usage: java " + InstallJars.class.getName() + " {propFilename} {-expand | -noexpand} {-run | -norun} {-quiet | -verbose} {-java <params>}");
        System.out.println("Where:");
        System.out.println("  propFilename    path to properties file (default=InstallJars.properties)");
        System.out.println("  -expand         expand any top level JAR/ZIP/GZIP (default)");
        System.out.println("  -noexpand       do not expand any top level JAR/ZIP/GZIP");
        System.out.println("  -run            run class or JAR files (default)");
        System.out.println("  -norun          do not run class or JAR files");
        System.out.println("  -verbose        output progress messages (default)");
        System.out.println("  -quiet          suppress most messages");
        System.out.println("  -java           sets java runtime paramters");
        System.out.println();
        System.out.println("Properties file entry format: name=!url{!target{!classpath{!option}...}}");
        System.out.println("Where:");
        System.out.println("  name      name displayed while installing");
        System.out.println("  url       source of items to download and install");
        System.out.println("  target    root of install directory or file (default=.)");
        System.out.println("  classpath class path entry to use for this directrory or file (default=target}");
        System.out.println("  option    one of the following options: expand, noexpand, run, norun");
        System.out.println("            if omitted, the command line default is used");
        System.out.println("! is a delimiter, the first non-whitespace character is used.");
        System.out.println("Options expand and run may not apply to all types of files.");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            InstallJars.printHelp();
            System.exit(0);
        }
        String propName = null;
        boolean expand = true;
        boolean verbose = true;
        boolean run = true;
        String params = "cmd /c java";
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.charAt(0) == '-') {
                if ((arg = arg.substring(1)).equalsIgnoreCase("quiet")) {
                    verbose = false;
                } else if (arg.equalsIgnoreCase("verbose")) {
                    verbose = true;
                } else if (arg.equalsIgnoreCase("expand")) {
                    expand = true;
                } else if (arg.equalsIgnoreCase("noexpand")) {
                    expand = false;
                } else if (arg.equalsIgnoreCase("run")) {
                    run = true;
                } else if (arg.equalsIgnoreCase("norun")) {
                    run = false;
                } else if (arg.equalsIgnoreCase("java")) {
                    run = false;
                    if (i < args.length - 1) {
                        params = args[++i];
                    }
                } else {
                    System.err.println("Invalid switch - " + arg);
                    System.exit(1);
                }
            } else if (propName == null) {
                propName = arg;
            } else {
                System.err.println("Too many parameters - " + arg);
                System.exit(1);
            }
            ++i;
        }
        if (propName == null) {
            propName = "InstallJars.properties";
        }
        try {
            InstallJars ij = new InstallJars(expand, verbose, run, propName, params);
            ij.printUsage();
            String cp = ij.install();
            System.out.println("\nRecomended additions to your classpath - " + cp);
        }
        catch (Exception e) {
            System.err.println("\n" + e.getClass().getName() + ": " + e.getMessage());
            if (verbose) {
                e.printStackTrace();
            }
            System.exit(2);
        }
    }
}

