/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.ui.preferences;

import java.util.TreeSet;
import org.eclipse.actf.ui.util.IDialogConstants;
import org.eclipse.actf.visualization.engines.blind.TextChecker;
import org.eclipse.actf.visualization.internal.engines.blind.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class EditNGWordDialog {
    private static final String DIALOG_TITLE = Messages.AltDialog_TITLE;
    private Shell shell;
    private int iReturnCode = 0;
    private String strFilter;
    private Table ngWordTable;
    private TextChecker textChecker = TextChecker.getInstance();

    public EditNGWordDialog(Shell _shell) {
        this.shell = new Shell(_shell, 34912);
        this.shell.setLayout((Layout)new GridLayout());
    }

    private boolean setNewValue() {
        TreeSet<String> newSet = new TreeSet<String>();
        TableItem[] tableItemArray = this.ngWordTable.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String tmpS = item.getText();
            if (tmpS != null && (tmpS = tmpS.trim()).length() > 0) {
                newSet.add(tmpS);
            }
            ++n2;
        }
        this.textChecker.setInappropriateAltSet(newSet);
        return true;
    }

    private void createButtonControls() {
        Composite composite = new Composite((Composite)this.shell, 0);
        GridData gridData = new GridData(136);
        gridData.heightHint = 50;
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 20;
        layout.marginWidth = 20;
        layout.marginHeight = 20;
        composite.setLayout((Layout)layout);
        Button okButton = new Button(composite, 8);
        okButton.setText(IDialogConstants.OK);
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditNGWordDialog.this.setNewValue()) {
                    return;
                }
                EditNGWordDialog.this.iReturnCode = 1;
                EditNGWordDialog.this.shell.close();
            }
        });
        Button cancelButton = new Button(composite, 8);
        cancelButton.setText(IDialogConstants.CANCEL);
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditNGWordDialog.this.iReturnCode = 0;
                EditNGWordDialog.this.shell.close();
            }
        });
        this.shell.setDefaultButton(okButton);
    }

    private void createSettingControls() {
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 2;
        composite.setLayout((Layout)gridLayout1);
        this.ngWordTable = new Table(composite, 68352);
        GridData gridData1 = new GridData(1808);
        gridData1.heightHint = 150;
        gridData1.horizontalSpan = 2;
        this.ngWordTable.setLayoutData((Object)gridData1);
        this.ngWordTable.setHeaderVisible(true);
        this.ngWordTable.setLinesVisible(true);
        TableColumn col = new TableColumn(this.ngWordTable, 0);
        col.setText(Messages.AltDialog_Column_Name);
        col.setWidth(200);
        for (String value : this.textChecker.getInappropriateALTSet()) {
            TableItem item = new TableItem(this.ngWordTable, 0);
            item.setText(value);
        }
        final Text text = new Text(composite, 2048);
        gridData1 = new GridData(768);
        gridData1.horizontalSpan = 2;
        text.setLayoutData((Object)gridData1);
        Button addButton = new Button(composite, 8);
        addButton.setText(IDialogConstants.ADD);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String str = text.getText().toLowerCase();
                if (str.equals("")) {
                    EditNGWordDialog.this.popupMessage(Messages.AltDialog_MSG_No_String);
                    return;
                }
                int count = EditNGWordDialog.this.ngWordTable.getItemCount();
                int i = 0;
                while (i < count) {
                    if (EditNGWordDialog.this.ngWordTable.getItem(i).getText().equals(str)) {
                        EditNGWordDialog.this.popupMessage(Messages.AltDialog_MSG_Existed);
                        return;
                    }
                    ++i;
                }
                TableItem item = new TableItem(EditNGWordDialog.this.ngWordTable, 0);
                item.setText(str);
            }
        });
        Button delButton = new Button(composite, 8);
        delButton.setText(IDialogConstants.DELETE);
        delButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                if (EditNGWordDialog.this.ngWordTable.getSelectionCount() > 0) {
                    EditNGWordDialog.this.ngWordTable.getSelection()[0].dispose();
                }
            }
        });
    }

    private void popupMessage(String str) {
        MessageBox msgBox = new MessageBox(this.shell, 32);
        msgBox.setMessage(str);
        msgBox.open();
    }

    public int open() {
        this.shell.setText(DIALOG_TITLE);
        this.createSettingControls();
        this.createButtonControls();
        this.shell.setLocation(200, 200);
        this.shell.pack();
        this.shell.open();
        Display display = this.shell.getDisplay();
        while (!this.shell.isDisposed() || !display.readAndDispatch()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.iReturnCode;
    }

    public String getStrFilter() {
        return this.strFilter;
    }
}

