/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import org.eclipse.actf.visualization.internal.engines.voicebrowser.Context;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.IElementRenderer;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.MessageCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.OutLoud;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.PacketCollection;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StaticSELECTRenderer
implements IElementRenderer {
    public PacketCollection getPacketCollectionIn(Element element, Context curContext, String url, MessageCollection mc) {
        String result;
        this.setContextIn(element, curContext);
        NodeList children = element.getChildNodes();
        int num = 0;
        int i = 0;
        while (i < children.getLength()) {
            Node node = children.item(i);
            String nodeName = node.getNodeName().toLowerCase();
            if (nodeName.equals("option")) {
                ++num;
            }
            ++i;
        }
        NamedNodeMap attrs = element.getAttributes();
        Node multiNode = attrs.getNamedItem("multiple");
        String type = "select";
        if (multiNode != null) {
            type = "multi-select";
        }
        if (num > 1) {
            result = OutLoud.buildResultString(mc, url, element, "in", "plural", "name=str1", type, "name=num1", Integer.toString(num));
            if (result == null && OutLoud.hprDefltMsg) {
                result = "(Start of " + type + " menu with " + num + " items.)";
            }
        } else {
            result = OutLoud.buildResultString(mc, url, element, "in", "singular", "name=str1", type);
            if (result == null && OutLoud.hprDefltMsg) {
                result = "(Start of " + type + " menu with 1 item.)";
            }
        }
        if (result != null) {
            result = result.trim();
        }
        return new PacketCollection(new Packet(element, result, curContext, true));
    }

    public PacketCollection getPacketCollectionOut(Element element, Context curContext, String url, MessageCollection mc) {
        this.setContextOut(element, curContext);
        String result = OutLoud.buildResultString(mc, url, element, "out", null);
        if (result == null && OutLoud.hprDefltMsg) {
            result = "(End of select menu.)";
        }
        if (result != null) {
            result = result.trim();
        }
        return new PacketCollection(new Packet(element, result, curContext, false));
    }

    public void setContextIn(Element element, Context curContext) {
        curContext.setStartSelect(true);
        curContext.setGoChild(true);
        curContext.setLineDelimiter(true);
        curContext.setLinkTag(false);
    }

    public void setContextOut(Element element, Context curContext) {
        curContext.setStartSelect(false);
        curContext.setGoChild(true);
        curContext.setLineDelimiter(true);
        curContext.setLinkTag(false);
    }
}

