/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.voicebrowser;

import java.util.ArrayList;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacketCollection;
import org.eclipse.actf.visualization.internal.engines.voicebrowser.Packet;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PacketCollection
extends ArrayList<IPacket>
implements IPacketCollection {
    private static final long serialVersionUID = 673397303905161652L;

    public PacketCollection(Packet text) {
        this.add(text);
    }

    public PacketCollection() {
    }

    @Override
    public boolean add(Packet p) {
        return super.add(p);
    }

    public boolean addAll(PacketCollection c) {
        return super.addAll(c);
    }

    @Override
    public boolean isLineDelimiter(int i) {
        try {
            if (i < this.size()) {
                return ((IPacket)this.get(i)).getContext().isLineDelimiter();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isLinkTag(int i) {
        try {
            if (i < this.size()) {
                return ((IPacket)this.get(i)).getContext().isLinkTag();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isInsideForm(int i) {
        try {
            if (i < this.size()) {
                return ((IPacket)this.get(i)).getContext().isInsideForm();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public boolean isInsideAnchor(int i) {
        try {
            if (i < this.size()) {
                return ((IPacket)this.get(i)).getContext().isInsideAnchor();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isStartSelect(int i) {
        try {
            if (i < this.size()) {
                return ((IPacket)this.get(i)).getContext().isStartSelect();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isStringOutput(int i) {
        try {
            if (i < this.size()) {
                return ((IPacket)this.get(i)).getContext().isStringOutput();
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public Node getFirstNode() {
        try {
            int size = this.size();
            int i = 0;
            while (i < size) {
                if (((Packet)this.get(i)).isStartTag()) {
                    return ((IPacket)this.get(i)).getNode();
                }
                ++i;
            }
            return null;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return null;
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            return null;
        }
    }

    @Override
    public Node getLastNode() {
        try {
            int size = this.size();
            int i = size - 1;
            while (i >= 0) {
                if (((Packet)this.get(i)).isStartTag()) {
                    return ((IPacket)this.get(i)).getNode();
                }
                --i;
            }
            return null;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return null;
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            return null;
        }
    }

    @Override
    public int getTopNodePosition() {
        try {
            int size = this.size();
            int i = 0;
            while (i < size) {
                String str = ((IPacket)this.get(i)).getText();
                if (str != null && str.length() > 0) {
                    if (this.isInsideAnchor(i)) {
                        int j = i;
                        while (j >= 0) {
                            if (this.isLinkTag(j)) {
                                return j;
                            }
                            --j;
                        }
                    }
                    return i;
                }
                ++i;
            }
            return -1;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return -1;
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            return -1;
        }
    }

    @Override
    public int getBottomNodePosition() {
        try {
            int size = this.size();
            boolean found = false;
            int i = size - 1;
            while (i >= 0) {
                String str = ((IPacket)this.get(i)).getText();
                if (str != null && str.length() > 0) {
                    found = true;
                }
                if (found && this.isLineDelimiter(i)) {
                    if (i == size - 1) {
                        return i;
                    }
                    if (this.isLinkTag(i + 1) && i + 2 < size && this.isLinkTag(i + 2)) {
                        return i + 2;
                    }
                    return i + 1;
                }
                --i;
            }
            return -1;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return -1;
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            return -1;
        }
    }

    @Override
    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        int size = this.size();
        int i = 0;
        while (i < size) {
            try {
                sbuf.append(((IPacket)this.get(i)).toString());
                sbuf.append("\n");
            }
            catch (ClassCastException classCastException) {
                sbuf.append("error: " + i + "the object is not a packet.\n");
            }
            ++i;
        }
        return sbuf.toString();
    }

    @Override
    public int getNodePosition(Node node) {
        try {
            int size = this.size();
            int i = 0;
            while (i < size) {
                if (node == ((IPacket)this.get(i)).getNode()) {
                    return i;
                }
                ++i;
            }
            return 0;
        }
        catch (NullPointerException npe) {
            npe.printStackTrace();
            return 0;
        }
        catch (ClassCastException cce) {
            cce.printStackTrace();
            return 0;
        }
    }
}

