/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import java.io.IOException;
import java.io.PushbackInputStream;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;

public class SWFUtil {
    private static final byte[] CT_SHOCKWAVE_FLASH = "application/x-shockwave-flash".getBytes();
    private static final byte[] CT_IMAGE = "image".getBytes();
    private static final byte[] CT_VIDEO = "video".getBytes();
    public static final byte[] X_FLASH_VERSION_A = "x-flash-version".getBytes();
    public static final byte[] MIME_TYPE_APPLICATION_X_SHOCKWAVE_FLASH_A = "application/x-shockwave-flash".getBytes();
    public static final byte[] MIME_TYPE_APPLICATION_X_WWW_FORM_URLENCODED_A = "application/x-www-form-urlencoded".getBytes();
    public static final String MSIE = "MSIE";
    public static final String BRIDGE_INIT_SWF_FILENAME = "Eclipse-ACTF-SWF-Initialize-Bridge-Package-1082017309130187472.swf";
    public static final String BRIDGE_INIT_SWF_V9_FILENAME = "bridge_as3.swf";
    public static final String LOADVARS_PROPERTY_FILENAME = "Eclipse-ACTF-SWF-LoadVars-1082017309130187472.txt";
    public static final int FLASH_MAGIC_NUMBER_SIZE = 4;

    public static boolean isContentTypeEqual(byte[] ct, byte[] type) {
        if (ct.length < type.length) {
            return false;
        }
        int i = 0;
        while (i < type.length) {
            if (ct[i] != type[i]) {
                return false;
            }
            ++i;
        }
        return ct[i] == 47 || ct.length == type.length;
    }

    public static boolean isPossiblySWFContentType(IHTTPResponseMessage response) {
        IHTTPHeader contentTypeH = response.getHeader(IHTTPHeader.CONTENT_TYPE_A);
        if (contentTypeH != null) {
            byte[] ct = contentTypeH.getValue();
            if (SWFUtil.isContentTypeEqual(ct, CT_IMAGE)) {
                return false;
            }
            if (SWFUtil.isContentTypeEqual(ct, CT_VIDEO)) {
                return false;
            }
        }
        return true;
    }

    public static boolean isSWFContentType(IHTTPResponseMessage response) {
        IHTTPHeader contentTypeH = response.getHeader(IHTTPHeader.CONTENT_TYPE_A);
        if (contentTypeH != null) {
            return contentTypeH.compareValueIgnoreCase(CT_SHOCKWAVE_FLASH);
        }
        return false;
    }

    public static int isSWF(PushbackInputStream pbis) {
        int returnValue;
        byte[] magicNumber;
        block5: {
            try {
                magicNumber = new byte[4];
                returnValue = -1;
                int size = pbis.read(magicNumber);
                if (size >= 4) break block5;
                if (size > 0) {
                    pbis.unread(magicNumber, 0, size);
                }
                return -1;
            }
            catch (IOException e) {
                e.printStackTrace();
                return -1;
            }
        }
        if ((magicNumber[0] == 67 || magicNumber[0] == 70) && magicNumber[1] == 87 && magicNumber[2] == 83) {
            returnValue = magicNumber[3];
        }
        pbis.unread(magicNumber);
        return returnValue;
    }
}

