/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.flash.proxy;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PushbackInputStream;
import org.eclipse.actf.model.flash.transcoder.ISwfTranscoder;
import org.eclipse.actf.model.flash.transcoder.ISwfTranscoderFactory;
import org.eclipse.actf.model.internal.flash.bridge.WaXcodingConfig;
import org.eclipse.actf.model.internal.flash.proxy.SWFUtil;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;
import org.eclipse.actf.util.httpproxy.core.IHTTPRequestMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponseMessage;
import org.eclipse.actf.util.httpproxy.core.IHTTPResponsePushbackMessage;
import org.eclipse.actf.util.httpproxy.core.IPushbackMessageBody;
import org.eclipse.actf.util.httpproxy.core.TimeoutException;
import org.eclipse.actf.util.httpproxy.proxy.IHTTPProxyTranscoder;
import org.eclipse.actf.util.httpproxy.util.HTTPUtil;
import org.eclipse.actf.util.httpproxy.util.Logger;

public class ProxyTranscoderSWF
implements IHTTPProxyTranscoder {
    private static final Logger LOGGER = Logger.getLogger(ProxyTranscoderSWF.class);
    private static final ISwfTranscoderFactory swfTranscoderFactory = ProxyTranscoderSWF.getSwfTranscoderFactory();
    private final ISwfTranscoder swfTranscoder;
    private static Object imposedSWF;

    private static ISwfTranscoderFactory getSwfTranscoderFactory() {
        try {
            Class<?> clazz = Class.forName("org.eclipse.actf.util.swftranscoder.SwfTranscoderFactory");
            return (ISwfTranscoderFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private ProxyTranscoderSWF(int id) {
        this.swfTranscoder = swfTranscoderFactory.newInstance(id);
    }

    protected static ProxyTranscoderSWF newInstance(int id) {
        if (swfTranscoderFactory == null) {
            return null;
        }
        return new ProxyTranscoderSWF(id);
    }

    public static void setSWFTranscodingImposedFile(InputStream is) {
        if (swfTranscoderFactory == null) {
            return;
        }
        ISwfTranscoder st = swfTranscoderFactory.newInstance(0);
        try {
            imposedSWF = st.parse(is);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private File getTemporaryDestSWF(File src) throws IOException {
        return new File(String.valueOf(src.getAbsolutePath()) + ".out");
    }

    private File getTemporarySrcSWF() throws IOException {
        return File.createTempFile("SWFTC-", ".swf");
    }

    private boolean isTranscodeTarget(int id, IHTTPRequestMessage request, IHTTPResponsePushbackMessage response) {
        if (request.getHeader(SWFUtil.X_FLASH_VERSION_A) == null) {
            return false;
        }
        if (!SWFUtil.isPossiblySWFContentType((IHTTPResponseMessage)response)) {
            return false;
        }
        IPushbackMessageBody body = response.getPushbackMessageBody();
        if (body == null) {
            return false;
        }
        PushbackInputStream bodyInputStream = body.getMessageBodyPushBackInputStream();
        int version = SWFUtil.isSWF(bodyInputStream);
        if (version >= WaXcodingConfig.getInstance().getSWFTranscodingMinimumVersion()) {
            LOGGER.info("[id:" + id + "] SWTTranscoder: SWF to be transcoded (" + request.getOriginalRequestURIString() + ")- Version:" + version);
            return true;
        }
        if (version > 0) {
            LOGGER.info("[id:" + id + "] SWTTranscoder: SWF not to be transcoded (" + request.getOriginalRequestURIString() + ")- Version:" + version);
        }
        return false;
    }

    private void outputFailureLog(StringBuffer buf, IHTTPRequestMessage request, File outFile, Throwable e) {
        buf.append("(");
        buf.append(request.getOriginalRequestURIString());
        buf.append(")\n");
        buf.append(this.stackTraceToString(e));
        if (LOGGER.isDebugEnabled() && outFile != null) {
            buf.append("The SWF file is secured in ");
            buf.append(outFile.getAbsolutePath());
            buf.append("\n");
        }
        LOGGER.fatal(buf.toString());
    }

    private File saveSWFFile(File f, byte[] target) throws IOException {
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(f);
            os.write(target);
            File file = f;
            return file;
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    private String stackTraceToString(Throwable t) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        t.printStackTrace(ps);
        return os.toString();
    }

    public IHTTPResponseMessage transcode(int id, IHTTPRequestMessage request, IHTTPResponseMessage response) {
        byte[] transcoded;
        if (!WaXcodingConfig.getInstance().getSWFTranscodingFlag()) {
            return response;
        }
        if (imposedSWF == null) {
            return response;
        }
        IHTTPResponsePushbackMessage newResponse = HTTPUtil.createHTTPResponsePushbackMessage((IHTTPResponseMessage)response, (int)4);
        if (!this.isTranscodeTarget(id, request, newResponse)) {
            return newResponse;
        }
        File srcSWFFile = null;
        File destSWFFile = null;
        try {
            byte[] targetBytes;
            srcSWFFile = this.getTemporarySrcSWF();
            try {
                targetBytes = newResponse.readBody(0L, false);
            }
            catch (TimeoutException timeoutException) {
                LOGGER.fatal("[id:" + id + "] Message body cannot be read by timeout.");
                return HTTPUtil.createHTTPResponseInMemoryMessage((long)request.getSerial(), (byte[])IHTTPHeader.HTTP_VERSION_1_0_A, (byte[])"504".getBytes(), (byte[])"Gateway Timeout".getBytes(), (byte[])IHTTPResponseMessage.EMPTY_BODY);
            }
            if (targetBytes == null) {
                return response;
            }
            if (LOGGER.isDebugEnabled()) {
                this.saveSWFFile(srcSWFFile, targetBytes);
            }
            Object srcSwf = this.swfTranscoder.parse(new ByteArrayInputStream(targetBytes));
            Object destSwf = this.swfTranscoder.impose(imposedSWF, srcSwf);
            transcoded = this.swfTranscoder.generate(destSwf, false, 8);
            destSWFFile = this.getTemporaryDestSWF(srcSWFFile);
            if (LOGGER.isDebugEnabled()) {
                this.saveSWFFile(destSWFFile, transcoded);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return response;
        }
        catch (Exception e) {
            StringBuffer buf = new StringBuffer("SWF transcoding failed ");
            this.outputFailureLog(buf, request, srcSWFFile, e);
            return response;
        }
        IHTTPResponseMessage msg = HTTPUtil.createHTTPResponseInMemoryMessage((IHTTPResponseMessage)response, (byte[])transcoded);
        return msg;
    }
}

