/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import org.eclipse.actf.model.flash.util.SwfHeaderParser;
import org.eclipse.actf.model.flash.util.SwfInfo;

public class AsVersionChecker {
    public static final int READBUFFER_SIZE = 0x100000;
    private static final Logger LOGGER = Logger.getLogger(AsVersionChecker.class.getName());
    private URL url;
    private InputStream in;

    public void setSwfFile(String path) {
        try {
            File f = new File(path);
            this.url = f.exists() ? f.toURL() : new URL(path);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            this.url = null;
        }
    }

    public void setSwfFile(URL _url) {
        this.url = _url;
    }

    public void setSwfFile(InputStream _in) {
        this.in = _in;
        this.url = null;
    }

    public SwfInfo getSwfInfo() {
        SwfInfo swfInfo = new SwfInfo();
        try {
            InputStream is;
            if (this.url == null) {
                if (this.in == null) {
                    return swfInfo;
                }
                is = this.in;
            } else {
                is = this.url.openConnection().getInputStream();
            }
            MyBufferedInputStream mbis = new MyBufferedInputStream(is, 0x100000);
            SwfHeaderParser shp = new SwfHeaderParser(mbis);
            shp.parse();
            swfInfo.setFrameSizeX(shp.getFrameSizeX());
            swfInfo.setFrameSizeY(shp.getFrameSizeY());
            is = shp.getInputStream();
            LOGGER.fine("searching AS related tag...");
            while (true) {
                byte[] buf = this.readBytes(is, 2);
                int typelen = buf[0] & 0xFF | (buf[1] & 0xFF) << 8;
                LOGGER.fine("**" + Integer.toHexString(typelen));
                int type = typelen >> 6;
                int length = typelen & 0x3F;
                if (length == 63) {
                    buf = this.readBytes(is, 4);
                    length = buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
                }
                LOGGER.fine("type=" + type + ", length=" + length);
                if (type == 0) {
                    this.pushBack(mbis.getBuffer());
                    swfInfo.setAsVersion(-1);
                    return swfInfo;
                }
                if (type == 69) {
                    buf = this.readBytes(is, 1);
                    if ((buf[0] & 8) > 0) {
                        this.pushBack(mbis.getBuffer());
                        swfInfo.setAsVersion(3);
                        return swfInfo;
                    }
                    this.pushBack(mbis.getBuffer());
                    swfInfo.setAsVersion(2);
                    return swfInfo;
                }
                if (type == 59 || type == 12) {
                    this.pushBack(mbis.getBuffer());
                    swfInfo.setAsVersion(2);
                    return swfInfo;
                }
                if (type == 82) {
                    this.pushBack(mbis.getBuffer());
                    swfInfo.setAsVersion(3);
                    continue;
                }
                this.readBytes(is, length);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            swfInfo.setAsVersion(-1);
            return swfInfo;
        }
    }

    private byte[] readBytes(InputStream is, int length) throws IOException {
        byte[] buf = new byte[length];
        int count = 0;
        while (count < length) {
            int read = is.read(buf, count, length - count);
            if (read <= 0) continue;
            count += read;
        }
        return buf;
    }

    private void pushBack(byte[] header) throws IOException {
        if (this.in instanceof PushbackInputStream) {
            PushbackInputStream pis = (PushbackInputStream)this.in;
            pis.unread(header);
        }
    }

    public static void main(String[] args) throws IOException {
        LOGGER.info("started");
        System.out.println("1 - AS3, 2 - AS3 no compress, 3 - AS2\n?");
        BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
        int choice = Integer.parseInt(r.readLine());
        AsVersionChecker checker = new AsVersionChecker();
        if (choice == 1) {
            checker.setSwfFile("checker/f9as3.swf");
        } else if (choice == 2) {
            checker.setSwfFile("checker/f9as3-noc.swf");
        } else {
            checker.setSwfFile("checker/f9as2.swf");
        }
        int ver = checker.getSwfInfo().getAsVersion();
        LOGGER.info("version=" + ver);
    }

    private class MyBufferedInputStream
    extends BufferedInputStream {
        public MyBufferedInputStream(InputStream in, int size) {
            super(in, size);
            super.mark(size);
        }

        public byte[] getBuffer() {
            if (this.markpos == 0) {
                byte[] result = new byte[this.count];
                System.arraycopy(this.buf, 0, result, 0, this.count);
                return result;
            }
            LOGGER.severe("load size over: " + this.buf.length);
            return new byte[0];
        }
    }
}

