/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.operator;

import java.awt.image.BufferedImage;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionType;
import org.eclipse.actf.visualization.internal.engines.lowvision.color.ColorException;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.BlurOp;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.CVDOp;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ColorFilterOp;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.GlareOp;

public class LowVisionFilter {
    LowVisionType type = null;
    Vector<String> simVector = new Vector();
    private static final String TYPE_SENIOR_FILTER = "senior_color";
    private static final String TYPE_CVD = "color";
    private static final String TYPE_EYESIGHT = "focus";
    private static final String TYPE_GLARE = "glare";

    public LowVisionFilter(LowVisionType _t) {
        this.type = _t;
        if (this.type.countTypes() > 0) {
            if (this.type.doColorFilter()) {
                this.simVector.addElement(TYPE_SENIOR_FILTER);
            }
            if (this.type.doGlare()) {
                this.simVector.addElement(TYPE_GLARE);
            }
            if (this.type.doCVD()) {
                this.simVector.addElement(TYPE_CVD);
            }
            if (this.type.doEyesight()) {
                this.simVector.addElement(TYPE_EYESIGHT);
            }
        }
    }

    public BufferedImage filter(BufferedImage _src, BufferedImage _dest) throws LowVisionException {
        if (this.type == null) {
            throw new LowVisionException("LowVisionType must be provided.");
        }
        try {
            int size = this.simVector.size();
            if (size > 1) {
                BufferedImage tmpImg = this.oneFilter(this.simVector.elementAt(0), _src, null);
                int i = 1;
                while (i < size - 1) {
                    BufferedImage tmpImg2;
                    String curType = this.simVector.elementAt(i);
                    tmpImg = tmpImg2 = this.oneFilter(curType, tmpImg, null);
                    ++i;
                }
                String curType = this.simVector.elementAt(size - 1);
                return this.oneFilter(curType, tmpImg, _dest);
            }
            if (size == 1) {
                return this.oneFilter(this.simVector.elementAt(0), _src, _dest);
            }
            return _src;
        }
        catch (ColorException ce) {
            ce.printStackTrace();
            throw new LowVisionException("ColorException occurred while filtering.");
        }
    }

    private BufferedImage oneFilter(String _type, BufferedImage _src, BufferedImage _dest) throws LowVisionException, ColorException {
        if (_type.equals(TYPE_SENIOR_FILTER)) {
            ColorFilterOp cfop = new ColorFilterOp();
            cfop.setRatio(this.type.getColorFilterRGB());
            return cfop.filter(_src, _dest);
        }
        if (_type.equals(TYPE_GLARE)) {
            GlareOp gop = new GlareOp(this.type.getGlareDegree());
            return gop.filter(_src, _dest);
        }
        if (_type.equals(TYPE_CVD)) {
            CVDOp cop = new CVDOp(this.type.getCVDType());
            return cop.filter(_src, _dest);
        }
        if (_type.equals(TYPE_EYESIGHT)) {
            BlurOp bop = new BlurOp(this.type);
            return bop.filter(_src, _dest);
        }
        throw new LowVisionException("Unknown type: " + _type);
    }
}

