/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.image;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.BinaryImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Coord;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.LabeledImage;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Neighbor;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;

public class ConnectedComponent {
    public static final short CONNECTIVITY_UNSET = 0;
    public static final short CONNECTIVITY_4 = 1;
    public static final short CONNECTIVITY_8 = 2;
    public static final short THINNING_HILDITCH = 10;
    public static final short THINNING_DEFAULT = 10;
    int left;
    int top;
    BinaryImage shape;
    private int count;
    short connectivity = 0;

    public ConnectedComponent(int _left, int _top, int _width, int _height, int _count) {
        this.left = _left;
        this.top = _top;
        this.count = _count;
        this.shape = new BinaryImage(_width, _height);
    }

    public ConnectedComponent(int _left, int _top, BinaryImage _bi, short _conn) {
        this.left = _left;
        this.top = _top;
        this.shape = _bi;
        this.connectivity = _conn;
        if (_bi.getArea() == -1) {
            _bi.measureArea();
        }
        this.count = _bi.getArea();
    }

    public ConnectedComponent deepCopy() {
        ConnectedComponent cc = new ConnectedComponent(this.left, this.top, this.shape.width, this.shape.height, this.count);
        cc.shape = this.shape.deepCopy();
        cc.connectivity = this.connectivity;
        return cc;
    }

    public int getLeft() {
        return this.left;
    }

    void setLeft(int _l) {
        this.left = _l;
    }

    public int getTop() {
        return this.top;
    }

    void setTop(int _t) {
        this.top = _t;
    }

    public int getWidth() {
        return this.shape.width;
    }

    public int getHeight() {
        return this.shape.height;
    }

    public BinaryImage getShape() {
        return this.shape;
    }

    public int getCount() {
        return this.count;
    }

    public boolean equals(ConnectedComponent _cc) {
        if (this.left != _cc.left) {
            return false;
        }
        if (this.top != _cc.top) {
            return false;
        }
        return this.shape.equals(_cc.shape);
    }

    public static boolean includes(ConnectedComponent _a, ConnectedComponent _b) {
        if (_a.left > _b.left) {
            return false;
        }
        if (_a.top > _b.top) {
            return false;
        }
        if (_a.left + _a.shape.width < _b.left + _b.shape.width) {
            return false;
        }
        if (_a.top + _a.shape.height < _b.top + _b.shape.height) {
            return false;
        }
        int w = _b.shape.width;
        int h = _b.shape.height;
        int offsetX = _b.left - _a.left;
        int offsetY = _b.top - _a.top;
        int j = 0;
        while (j < h) {
            int i = 0;
            while (i < w) {
                if (_b.shape.data[j][i] != 0 && _a.shape.data[j + offsetY][i + offsetX] == 0) {
                    return false;
                }
                ++i;
            }
            ++j;
        }
        return true;
    }

    public boolean includes(ConnectedComponent _cc) {
        return ConnectedComponent.includes(this, _cc);
    }

    public boolean isIncludedBy(ConnectedComponent _cc) {
        return ConnectedComponent.includes(_cc, this);
    }

    public double getDensity() {
        return (double)this.count / ((double)this.shape.width * (double)this.shape.height);
    }

    public void adjustShape() {
        LabeledImage li = new LabeledImage(this.shape);
        ConnectedComponent cc = li.components[0];
        this.left += cc.left;
        this.top += cc.top;
        this.shape = cc.shape;
    }

    public ConnectedComponent calcContour() throws ImageException {
        if (this.connectivity == 0) {
            throw new ImageException("Information on connectivity is needed to calculate genus");
        }
        int width = this.shape.width;
        int height = this.shape.height;
        if (width <= 2 || height <= 2) {
            return this.deepCopy();
        }
        BinaryImage bi = new BinaryImage(width, height);
        int j = 0;
        while (j < height) {
            if (this.shape.data[j][0] != 0) {
                bi.data[j][0] = 1;
            }
            if (this.shape.data[j][width - 1] != 0) {
                bi.data[j][width - 1] = 1;
            }
            ++j;
        }
        int i = 0;
        while (i < width) {
            if (this.shape.data[0][i] != 0) {
                bi.data[0][i] = 1;
            }
            if (this.shape.data[height - 1][i] != 0) {
                bi.data[height - 1][i] = 1;
            }
            ++i;
        }
        if (this.connectivity == 1) {
            j = 1;
            while (j < height - 1) {
                int i2 = 1;
                while (i2 < width - 1) {
                    if (this.shape.data[j][i2] != 0 && (this.shape.data[j - 1][i2 - 1] == 0 || this.shape.data[j - 1][i2] == 0 || this.shape.data[j - 1][i2 + 1] == 0 || this.shape.data[j][i2 - 1] == 0 || this.shape.data[j][i2 + 1] == 0 || this.shape.data[j + 1][i2 - 1] == 0 || this.shape.data[j + 1][i2] == 0 || this.shape.data[j + 1][i2 + 1] == 0)) {
                        bi.data[j][i2] = 1;
                    }
                    ++i2;
                }
                ++j;
            }
        } else if (this.connectivity == 2) {
            j = 1;
            while (j < height - 1) {
                int i3 = 1;
                while (i3 < width - 1) {
                    if (this.shape.data[j][i3] != 0 && (this.shape.data[j - 1][i3] == 0 || this.shape.data[j + 1][i3] == 0 || this.shape.data[j][i3 - 1] == 0 || this.shape.data[j][i3 + 1] == 0)) {
                        bi.data[j][i3] = 1;
                    }
                    ++i3;
                }
                ++j;
            }
        } else {
            throw new ImageException("Unknown connectivity");
        }
        ConnectedComponent cc = new ConnectedComponent(this.left, this.top, bi, this.connectivity);
        return cc;
    }

    public ConnectedComponent thinning() throws ImageException {
        return this.thinning((short)10);
    }

    public ConnectedComponent thinning(short _method) throws ImageException {
        if (_method == 10) {
            return this.thinningHilditch();
        }
        throw new ImageException("Unknown thinning method: " + _method);
    }

    public ConnectedComponent thinningHilditch() {
        int width = this.shape.width;
        int height = this.shape.height;
        BinaryImage biBefore = new BinaryImage(width + 2, height + 2);
        BinaryImage biAfter = new BinaryImage(width + 2, height + 2);
        int j = 0;
        while (j < height) {
            int i = 0;
            while (i < width) {
                biBefore.data[j + 1][i + 1] = this.shape.data[j][i];
                ++i;
            }
            ++j;
        }
        while (this.scanForThinningHilditch(biBefore, biAfter) > 0) {
            biBefore = biAfter;
            biAfter = new BinaryImage(width + 2, height + 2);
        }
        BinaryImage bi = new BinaryImage(width, height);
        int j2 = 0;
        while (j2 < height) {
            int i = 0;
            while (i < width) {
                bi.data[j2][i] = biBefore.data[j2 + 1][i + 1];
                ++i;
            }
            ++j2;
        }
        return new ConnectedComponent(this.left, this.top, bi, 2);
    }

    private int scanForThinningHilditch(BinaryImage _before, BinaryImage _after) {
        int width = _before.width;
        int height = _before.height;
        int numChanged = 0;
        int j = 1;
        while (j < height - 1) {
            int i = 1;
            while (i < width - 1) {
                if (_before.data[j][i] != 0) {
                    Neighbor nei = new Neighbor(_before, i, j);
                    if (nei.numBackground4() == 0) {
                        _after.data[j][i] = 1;
                    } else if (nei.connectivityNumber8() != 1) {
                        _after.data[j][i] = 1;
                    } else if (nei.numForeground8() < 2) {
                        _after.data[j][i] = 1;
                    } else {
                        Neighbor nei2 = nei.deepCopy();
                        nei2.x[2] = _after.data[j - 1][i + 1];
                        nei2.x[3] = _after.data[j - 1][i];
                        nei2.x[4] = _after.data[j - 1][i - 1];
                        nei2.x[5] = _after.data[j][i - 1];
                        if (nei2.numForeground8() == 0) {
                            _after.data[j][i] = 1;
                        } else {
                            Neighbor nei3 = nei.deepCopy();
                            nei3.x[3] = _after.data[j - 1][i];
                            if (nei3.connectivityNumber8() != 1) {
                                _after.data[j][i] = 1;
                            } else {
                                Neighbor nei4 = nei.deepCopy();
                                nei4.x[5] = _after.data[j][i - 1];
                                if (nei4.connectivityNumber8() != 1) {
                                    _after.data[j][i] = 1;
                                } else {
                                    ++numChanged;
                                }
                            }
                        }
                    }
                }
                ++i;
            }
            ++j;
        }
        return numChanged;
    }

    public Topology calcTopology() throws ImageException {
        return new Topology(this);
    }

    public ConnectedComponent calcConvexHull() throws ImageException {
        ConnectedComponent cont = this.calcContour();
        Coord[] contPoints = cont.shape.extractPoints();
        if (contPoints == null) {
            return null;
        }
        int len = contPoints.length;
        if (len == 0) {
            return null;
        }
        if (len < 5) {
            return this.deepCopy();
        }
        Vector<Coord> vertexVector = new Vector<Coord>();
        Coord p0 = this.shape.topLeftPoint();
        vertexVector.addElement(p0);
        Coord curPoint = p0;
        Coord curVector = new Coord(1, 0);
        Coord nextPoint = this.nextConvexHullVertex(contPoints, curPoint, curVector);
        while (!nextPoint.equals(p0)) {
            vertexVector.addElement(nextPoint);
            curVector.set(nextPoint.x - curPoint.x, nextPoint.y - curPoint.y);
            curPoint = nextPoint;
            nextPoint = this.nextConvexHullVertex(contPoints, curPoint, curVector);
        }
        int numVertex = vertexVector.size();
        Coord[] vertexArray = new Coord[numVertex];
        int i = 0;
        while (i < numVertex) {
            vertexArray[i] = (Coord)vertexVector.elementAt(i);
            ++i;
        }
        BinaryImage newShape = new BinaryImage(this.shape.width, this.shape.height, vertexArray);
        return new ConnectedComponent(this.left, this.top, newShape, this.connectivity);
    }

    private Coord nextConvexHullVertex(Coord[] _all, Coord _origin, Coord _vector) throws ImageException {
        if (_all == null) {
            throw new ImageException("Empty vertex set.");
        }
        int len = _all.length;
        if (len == 0) {
            throw new ImageException("No vertex");
        }
        Coord answer = new Coord(-1, -1);
        Coord curVector = new Coord(-1, -1);
        double maxCos = -2.0;
        double maxDistance = 0.0;
        int i = 0;
        while (i < len) {
            Coord curPoint = _all[i];
            if (!curPoint.equals(_origin)) {
                double curDistance;
                curVector.set(curPoint.x - _origin.x, curPoint.y - _origin.y);
                double curCos = Coord.cosine(_vector, curVector);
                if (maxCos < curCos) {
                    maxCos = curCos;
                    maxDistance = Coord.distance(_origin, curPoint);
                    answer.copy(curPoint);
                } else if (maxCos == curCos && (curDistance = Coord.distance(_origin, curPoint)) > maxDistance) {
                    maxDistance = curDistance;
                    answer.copy(curPoint);
                }
            }
            ++i;
        }
        return answer;
    }

    public int calcGenus() throws ImageException {
        if (this.connectivity == 0) {
            throw new ImageException("Information on connectivity is needed to calculate genus");
        }
        int width = this.shape.width;
        int height = this.shape.height;
        if (width <= 2 || height <= 2) {
            return 1;
        }
        int v = this.shape.measureArea();
        int e = 0;
        int d = 0;
        int t = 0;
        int f = 0;
        if (this.connectivity == 1) {
            int j = 0;
            while (j < height - 1) {
                int i = 0;
                while (i < width - 1) {
                    if (this.shape.data[j][i] != 0) {
                        if (this.shape.data[j + 1][i] != 0) {
                            ++e;
                        }
                        if (this.shape.data[j][i + 1] != 0) {
                            ++e;
                        }
                        if (this.shape.data[j + 1][i] != 0 && this.shape.data[j][i + 1] != 0 && this.shape.data[j + 1][i + 1] != 0) {
                            ++f;
                        }
                    }
                    ++i;
                }
                if (this.shape.data[j][width - 1] != 0 && this.shape.data[j + 1][width - 1] != 0) {
                    ++e;
                }
                ++j;
            }
            int i = 0;
            while (i < width - 1) {
                if (this.shape.data[height - 1][i] != 0 && this.shape.data[height - 1][i + 1] != 0) {
                    ++e;
                }
                ++i;
            }
            return v - e + f;
        }
        if (this.connectivity == 2) {
            int j = 0;
            while (j < height - 1) {
                int i = 0;
                while (i < width - 1) {
                    if (this.shape.data[j][i] != 0) {
                        boolean ne = false;
                        boolean sw = false;
                        boolean se = false;
                        if (this.shape.data[j + 1][i] != 0) {
                            sw = true;
                            ++e;
                        }
                        if (this.shape.data[j][i + 1] != 0) {
                            ne = true;
                            ++e;
                        }
                        if (this.shape.data[j + 1][i + 1] != 0) {
                            se = true;
                            ++d;
                        }
                        if (ne && sw) {
                            ++t;
                        }
                        if (ne && se) {
                            ++t;
                        }
                        if (sw && se) {
                            ++t;
                        }
                        if (ne && sw && se) {
                            ++f;
                        }
                    }
                    if (this.shape.data[j][i + 1] != 0 && this.shape.data[j + 1][i] != 0) {
                        ++d;
                        if (this.shape.data[j + 1][i + 1] != 0) {
                            ++t;
                        }
                    }
                    ++i;
                }
                if (this.shape.data[j][width - 1] != 0 && this.shape.data[j + 1][width - 1] != 0) {
                    ++e;
                }
                ++j;
            }
            int i = 0;
            while (i < width - 1) {
                if (this.shape.data[height - 1][i] != 0 && this.shape.data[height - 1][i + 1] != 0) {
                    ++e;
                }
                ++i;
            }
            return v - e - d + t - f;
        }
        throw new ImageException("Unknown connectivity");
    }

    public void dump(PrintStream _ps) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dump(pw);
    }

    public void dump(PrintWriter _pw) {
        _pw.println("-------------------------------");
        _pw.println("Dumping a ConnectedComponent");
        _pw.println("Left = " + this.left + ", Top = " + this.top + ", Width = " + this.shape.width + ", Height = " + this.shape.height);
        int j = 0;
        while (j < this.shape.height) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.shape.width) {
                if (this.shape.data[j][i] == 0) {
                    sb.append(".");
                } else {
                    sb.append("#");
                }
                ++i;
            }
            _pw.println(sb.toString());
            ++j;
        }
        _pw.println("-------------------------------");
    }

    public void dump(PrintStream _ps, int _left, int _top, int _width, int _height) {
        PrintWriter pw = new PrintWriter(_ps, true);
        this.dump(pw, _left, _top, _width, _height);
    }

    public void dump(PrintWriter _pw, int _left, int _top, int _width, int _height) {
        _pw.println("-------------------------------");
        _pw.println("Dumping a part of a ConnectedComponent");
        _pw.println("Left = " + this.left + ", Top = " + this.top + ", Width = " + this.shape.width + ", Height = " + this.shape.height);
        _pw.println("Start point = ( " + _left + ", " + _top + ")");
        _pw.println("Printed width = " + _width + ", Printed height = " + _height);
        int j = 0;
        while (j < _height) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < _width) {
                if (this.shape.data[j + _top][i + _left] == 0) {
                    sb.append(".");
                } else {
                    sb.append("#");
                }
                ++i;
            }
            _pw.println(sb.toString());
            ++j;
        }
        _pw.println("-------------------------------");
    }

    public Int2D drawShape(Int2D _i2d, int _color) {
        int j = 0;
        while (j < this.shape.height) {
            int i = 0;
            while (i < this.shape.width) {
                if (this.shape.data[j][i] != 0) {
                    _i2d.getData()[j + this.top][i + this.left] = _color;
                }
                ++i;
            }
            ++j;
        }
        return _i2d;
    }
}

