/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.character;

import org.eclipse.actf.visualization.engines.lowvision.image.IPageImage;
import org.eclipse.actf.visualization.engines.lowvision.image.ImageException;
import org.eclipse.actf.visualization.internal.engines.lowvision.character.CandidateCharacter;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ConnectedComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Container;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.IInt2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.PageComponent;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Topology;

public class CharacterSM
extends PageComponent {
    private int foregroundColor = -1;
    private Topology topology = null;
    private int[][] image = null;

    public CharacterSM(CandidateCharacter _cChar, int[][] _pixel) throws ImageException {
        super((short)6, _cChar.getPageImage());
        this.cc = _cChar.cc;
        this.container = _cChar.container;
        this.foregroundColor = _cChar.getForegroundColor();
        this.topology = new Topology(this.cc.thinning());
        if (_pixel != null) {
            int w = this.cc.getShape().getWidth();
            int h = this.cc.getShape().getHeight();
            int offsetX = this.cc.getLeft();
            int offsetY = this.cc.getTop();
            this.image = new int[h][w];
            int j = 0;
            while (j < h) {
                int i = 0;
                while (i < w) {
                    this.image[j][i] = _pixel[j + offsetY][i + offsetX];
                    ++i;
                }
                ++j;
            }
        }
    }

    public CharacterSM(CandidateCharacter _cChar, IInt2D _pixel) throws ImageException {
        this(_cChar, _pixel.getData());
    }

    public CharacterSM(IPageImage _pi, ConnectedComponent _cc, Container _cont, int _color, int[][] _pixel) throws ImageException {
        super((short)6, _pi);
        this.cc = _cc;
        this.container = _cont;
        this.foregroundColor = _color;
        this.topology = new Topology(this.cc.thinning());
        if (_pixel != null) {
            int w = this.cc.getShape().getWidth();
            int h = this.cc.getShape().getHeight();
            int offsetX = this.cc.getLeft();
            int offsetY = this.cc.getTop();
            this.image = new int[h][w];
            int j = 0;
            while (j < h) {
                int i = 0;
                while (i < w) {
                    this.image[j][i] = _pixel[j + offsetY][i + offsetX];
                    ++i;
                }
                ++j;
            }
        }
    }

    public CharacterSM(IPageImage _pi, ConnectedComponent _cc, Container _cont, int _color, IInt2D _pixel) throws ImageException {
        this(_pi, _cc, _cont, _color, _pixel.getData());
    }

    public int getForegroundColor() {
        return this.foregroundColor;
    }

    public int[][] getImage() {
        return this.image;
    }

    public IInt2D getInt2D() throws ImageException {
        return new Int2D(this.cc.getShape().getWidth(), this.cc.getShape().getHeight(), this.image);
    }

    public IInt2D makeMarginedImage(int _margin) throws ImageException {
        int i;
        if (_margin == 0) {
            return this.getInt2D();
        }
        if (_margin < 0) {
            throw new ImageException("The margin must be non-negative.");
        }
        int w = this.cc.getShape().getWidth();
        int h = this.cc.getShape().getHeight();
        int largeW = w + 2 * _margin;
        int largeH = h + 2 * _margin;
        Int2D i2d = new Int2D(largeW, largeH);
        int j = 0;
        while (j < h) {
            i = 0;
            while (i < w) {
                i2d.getData()[j + _margin][i + _margin] = this.image[j][i];
                ++i;
            }
            i = 0;
            while (i < _margin) {
                i2d.getData()[j + _margin][i] = this.image[j][0];
                i2d.getData()[j + _margin][largeW - 1 - i] = this.image[j][w - 1];
                ++i;
            }
            ++j;
        }
        int i2 = 0;
        while (i2 < w) {
            int j2 = 0;
            while (j2 < _margin) {
                i2d.getData()[j2][i2 + _margin] = this.image[0][i2];
                i2d.getData()[largeH - 1 - j2][i2 + _margin] = this.image[h - 1][i2];
                ++j2;
            }
            ++i2;
        }
        j = 0;
        while (j < _margin) {
            i = 0;
            while (i < _margin) {
                i2d.getData()[j][i] = this.image[0][0];
                i2d.getData()[j][largeW - 1 - i] = this.image[0][w - 1];
                i2d.getData()[largeH - 1 - j][i] = this.image[h - 1][0];
                i2d.getData()[largeH - 1 - j][largeW - 1 - i] = this.image[h - 1][w - 1];
                ++i;
            }
            ++j;
        }
        return i2d;
    }

    public Topology getTopology() {
        return this.topology;
    }
}

