/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.lowvision;

import org.eclipse.actf.visualization.engines.lowvision.LowVisionException;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.CVDOp;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.ColorFilterOp;
import org.eclipse.actf.visualization.internal.engines.lowvision.operator.GlareOp;

public class LowVisionType {
    public static final int CVD_PROTAN = 1;
    public static final int CVD_DEUTAN = 2;
    public static final int CVD_TRITAN = 3;
    private static final double EYESIGHT_DEGREE_MARGIN = 0.1;
    private final int DISPLAY_RESOLUTION = 1024;
    private final double DISPLAY_HEIGHT = 20.8;
    private final double EYE_DISPLAY_DISTANCE = 30.0;
    private boolean eyesight = false;
    private float eyesightDegree;
    private int eyesightRadius;
    private double eyesightPixel;
    private double eyesightLength;
    private boolean CVD = false;
    private int CVDType;
    private boolean colorFilter = false;
    private float colorFilterR;
    private float colorFilterG;
    private float colorFilterB;
    private boolean glare = false;
    private float glareDegree = 0.0f;
    private int displayResolution = 1024;
    private double displayHeight = 20.8;
    private double eyeDisplayDistance = 30.0;

    public boolean doEyesight() {
        return this.eyesight;
    }

    public void setEyesight(boolean enable) {
        this.eyesight = enable;
    }

    public float getEyesightDegree() {
        return this.eyesightDegree;
    }

    public void setEyesightDegree(float _deg) throws LowVisionException {
        if ((double)_deg <= 0.0) {
            throw new LowVisionException("Eyesight degree must be positive.");
        }
        this.eyesightDegree = _deg;
        this.eyesightPixel = this.calcUndistinguishablePixel(this.eyesightDegree);
        this.eyesightRadius = this.calcRadius(this.eyesightPixel);
        this.eyesightLength = this.calcUndistinguishableLength(this.eyesightDegree);
    }

    public double getEyesightPixel() {
        return this.eyesightPixel;
    }

    public int getEyesightRadius() {
        return this.eyesightRadius;
    }

    public double getEyesightLength() {
        return this.eyesightLength;
    }

    private double calcUndistinguishablePixel(double _degree) {
        double degree = _degree + 0.1;
        double thetaD = 1.0 / degree;
        double thetaR = thetaD * Math.PI / 10800.0;
        return 2.0 * Math.tan(thetaR / 2.0) * (double)this.displayResolution * this.eyeDisplayDistance / this.displayHeight;
    }

    private int calcRadius(double _pixel) {
        return (int)Math.ceil(_pixel);
    }

    private double calcUndistinguishableLength(double _degree) {
        double degree = _degree + 0.1;
        double thetaD = 1.0 / degree;
        double thetaR = thetaD * Math.PI / 10800.0;
        return 20.0 * Math.tan(thetaR / 2.0) * this.eyeDisplayDistance;
    }

    public boolean doCVD() {
        return this.CVD;
    }

    public void setCVD(boolean enable) {
        this.CVD = enable;
    }

    public int getCVDType() {
        return this.CVDType;
    }

    public void setCVDType(int cvd_type) throws LowVisionException {
        if (cvd_type != 1 && cvd_type != 2 && cvd_type != 3) {
            throw new LowVisionException("CVD type must be 1,2, or 3");
        }
        this.CVDType = cvd_type;
    }

    public boolean doColorFilter() {
        return this.colorFilter;
    }

    public void setColorFilter(boolean enable) {
        this.colorFilter = enable;
    }

    public float[] getColorFilterRGB() {
        float[] rgb = new float[]{this.colorFilterR, this.colorFilterG, this.colorFilterB};
        return rgb;
    }

    private void setColorFilterRGB(float _r, float _g, float _b) throws LowVisionException {
        if ((double)_r < 0.0 || 1.0 < (double)_r) {
            throw new LowVisionException("Value of R(" + _r + ") is out of range.");
        }
        this.colorFilterR = _r;
        if ((double)_g < 0.0 || 1.0 < (double)_g) {
            throw new LowVisionException("Value of G(" + _g + ") is out of range.");
        }
        this.colorFilterG = _g;
        if ((double)_b < 0.0 || 1.0 < (double)_b) {
            throw new LowVisionException("Value of B(" + _b + ") is out of range.");
        }
        this.colorFilterB = _b;
    }

    public void setColorFilterDegree(float _degree) throws LowVisionException {
        float bDegree = _degree;
        float rgDegree = 1.0f - (1.0f - bDegree) / 2.0f;
        this.setColorFilterRGB(rgDegree, rgDegree, bDegree);
    }

    public boolean doGlare() {
        return this.glare;
    }

    public void setGlare(boolean enable) {
        this.glare = enable;
    }

    public float getGlareDegree() {
        return this.glareDegree;
    }

    public void setGlareDegree(float _deg) {
        this.glareDegree = _deg;
    }

    public int countTypes() {
        int num = 0;
        if (this.eyesight) {
            ++num;
        }
        if (this.CVD) {
            ++num;
        }
        if (this.colorFilter) {
            ++num;
        }
        if (this.glare) {
            ++num;
        }
        return num;
    }

    public boolean doBlur() {
        return this.eyesight;
    }

    public boolean doChangeColors() {
        return this.CVD || this.colorFilter || this.glare;
    }

    public int convertColor(int _src) throws LowVisionException {
        int dest = _src;
        if (this.colorFilter) {
            dest = ColorFilterOp.convertColor(dest, this.colorFilterR, this.colorFilterG, this.colorFilterB);
        }
        if (this.glare) {
            dest = GlareOp.convertColor(dest, this.glareDegree);
        }
        if (this.CVD) {
            dest = CVDOp.convertColor(dest, this.CVDType);
        }
        return dest;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.eyesight) {
            sb.append("Eyesight:on Degree=");
            sb.append("" + this.eyesightDegree);
        } else {
            sb.append("Eyesight:off,");
        }
        if (this.CVD) {
            sb.append("  CVD:on Type=" + this.CVDType + ",");
        } else {
            sb.append("  CVD: off,");
        }
        if (this.colorFilter) {
            sb.append("  ColorFilter:on Degree=" + this.colorFilterB);
        } else {
            sb.append("  ColorFilter:off");
        }
        return sb.toString();
    }

    public double getDisplayHeight() {
        return this.displayHeight;
    }

    public int getDisplayResolution() {
        return this.displayResolution;
    }

    public double getEyeDisplayDistance() {
        return this.eyeDisplayDistance;
    }

    public void setDisplayHeight(double height) {
        this.displayHeight = height;
    }

    public void setDisplayResolution(int resolution) {
        this.displayResolution = resolution;
    }

    public void setEyeDisplayDistance(double distance) {
        this.eyeDisplayDistance = distance;
    }
}

