/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.flash;

import com.ibm.icu.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.OverlayIcon;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class FlashImages {
    public static final String OVER_RED = "icons/ovr16/red.gif";
    public static final String OVER_YELLOW = "icons/ovr16/yellow.gif";
    public static final String OVER_GREEN = "icons/ovr16/green.gif";
    public static final String OVER_BLACK = "icons/ovr16/black.gif";
    public static final String FLASH_TYPE = "icons/flash16/type_{0}.gif";
    public static final String TYPE_flash = "flash";
    public static final ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
    public static Map<String, Image> imageMap = new HashMap<String, Image>();

    public static Image getImage(String path) {
        ImageDescriptor descriptor;
        if (path == null) {
            return null;
        }
        Image image = imageMap.get(path);
        if (image == null && (descriptor = FlashImages.getImageDescriptor(path)) != null) {
            image = descriptor.createImage(true);
            imageMap.put(path, image);
        }
        return image;
    }

    public static Image getImage(String basePath, String overlayPath, Point size) {
        if (basePath == null || overlayPath == null) {
            return null;
        }
        String totalPath = String.valueOf(basePath) + "|" + overlayPath;
        Image image = imageMap.get(totalPath);
        if (image == null) {
            ImageDescriptor overlayDescriptor;
            ImageDescriptor descriptor = FlashImages.getImageDescriptor(basePath);
            if (descriptor != null && (overlayDescriptor = FlashImages.getImageDescriptor(overlayPath)) != null) {
                descriptor = new OverlayIcon(descriptor, overlayDescriptor, size);
                image = descriptor.createImage(true);
            }
            imageMap.put(totalPath, image);
        }
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        ImageDescriptor descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.actf.visualization.flash", (String)path);
        if (descriptor != null) {
            return descriptor;
        }
        return GuiImages.getImageDescriptor((String)path);
    }

    public static String flashIcon(String typeString) {
        return FlashImages.getFilename(FLASH_TYPE, typeString);
    }

    public static String getFilename(String format, String name) {
        String path = MessageFormat.format((String)format, (Object[])new Object[]{name.toLowerCase()});
        if (FlashImages.getImageDescriptor(path) != null) {
            return path;
        }
        DebugPrintUtil.devOrDebugPrintln((Object)("Missing Flash icon " + path));
        return null;
    }
}

