/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.flash.ui.views;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.model.flash.ASAccInfo;
import org.eclipse.actf.model.flash.FlashPlayerFactory;
import org.eclipse.actf.model.flash.IASNode;
import org.eclipse.actf.model.flash.IFlashConst;
import org.eclipse.actf.model.flash.IFlashPlayer;
import org.eclipse.actf.model.flash.util.FlashDetect;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.visualization.flash.ui.properties.FlashNodePropertySource;
import org.eclipse.actf.visualization.gui.IGuiViewIDs;
import org.eclipse.actf.visualization.gui.internal.util.GuiImages;
import org.eclipse.actf.visualization.gui.internal.util.Messages;
import org.eclipse.actf.visualization.gui.ui.actions.RefreshRootAction;
import org.eclipse.actf.visualization.gui.ui.views.IFlashDOMView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.actf.visualization.internal.flash.FlashImages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class FlashDOMView
extends ViewPart
implements IFlashDOMView,
IFlashConst {
    private TreeViewer viewer;
    private Action expandAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private RefreshRootAction refreshAction;
    private Action informativeTreeAction;
    private Action visualTreeAction;
    private Action debugTreeAction;
    private Action scanWindowlessAction;
    private Color colorFound = Display.getCurrent().getSystemColor(13);
    private boolean debugMode = false;

    public void createPartControl(Composite parent) {
        this.viewer = new FlashTreeViewer(parent, 772);
        this.viewer.setContentProvider((IContentProvider)new FlashDOMContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FlashDOMLabelProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object selectedItem = ((IStructuredSelection)selection).getFirstElement();
                    if (selectedItem instanceof IASNode) {
                        ((IASNode)selectedItem).setMarker();
                    } else if (!(selectedItem instanceof IFlashPlayer)) {
                        return;
                    }
                    MSAAViewRegistory.showProperties((Object)selectedItem);
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        MSAAViewRegistory.findView((String)IGuiViewIDs.ID_OUTLINEVIEW);
        this.refresh();
    }

    public void refresh() {
        AccessibleObject rootObject = MSAAViewRegistory.getRootObject();
        if (rootObject != null) {
            IFlashPlayer[] players = FlashMSAAUtil.getFlashPlayers((int)rootObject.getWindow());
            int i = 0;
            while (i < players.length) {
                players[i].clearAllMarkers();
                ++i;
            }
            this.viewer.setInput((Object)players);
            FlashDetect.showDialog();
        }
    }

    public void findRectangle(Rectangle flashRect, Object objUnknown) {
        this.viewer.setInput((Object)new Object[]{objUnknown});
        String strMessage = org.eclipse.actf.visualization.internal.flash.Messages.flash_error_no_element;
        RectangleFinder finder = new RectangleFinder(flashRect);
        try {
            finder.find(this.viewer.getTree().getItems());
        }
        catch (Error error) {}
        if (finder.foundCount > 0) {
            strMessage = MessageFormat.format((String)org.eclipse.actf.visualization.internal.flash.Messages.flash_element_found, (Object[])new Object[]{new Integer(finder.foundCount)});
        }
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)org.eclipse.actf.visualization.internal.flash.Messages.flash_flash_dom, (String)strMessage);
    }

    public void addWindowlessElement(final Object objUnknown) {
        if (!this.scanWindowlessAction.isChecked() && objUnknown instanceof AccessibleObject) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    Object currentInput = FlashDOMView.this.viewer.getInput();
                    IFlashPlayer player = FlashPlayerFactory.getPlayerFromPtr((int)((AccessibleObject)objUnknown).getPtr());
                    if (currentInput instanceof IFlashPlayer[]) {
                        List<IFlashPlayer> list = Arrays.asList((IFlashPlayer[])currentInput);
                        for (IFlashPlayer target : list) {
                            if (target != player && target.getAccessible().getPtr() != target.getAccessible().getPtr()) continue;
                            return;
                        }
                        ArrayList<IFlashPlayer> newList = new ArrayList<IFlashPlayer>(list);
                        newList.add(player);
                        FlashDOMView.this.viewer.setInput((Object)newList.toArray());
                    }
                }
            });
        }
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FlashDOMView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.informativeTreeAction);
        manager.add((IAction)this.visualTreeAction);
        manager.add((IAction)this.scanWindowlessAction);
        manager.add((IAction)this.debugTreeAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillContextMenu(IMenuManager manager) {
        Object selected = this.getSelectedItem();
        if (selected != null) {
            manager.add((IAction)this.expandAction);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        manager.add((IAction)this.refreshAction);
    }

    private void makeActions() {
        this.expandAction = new Action(Messages.msaa_expand){

            public void run() {
                try {
                    Object selected = FlashDOMView.this.getSelectedItem();
                    if (selected != null) {
                        FlashDOMView.this.viewer.expandToLevel(selected, -1);
                    }
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
        };
        this.expandAllAction = new Action(Messages.msaa_expand_all){

            public void run() {
                try {
                    FlashDOMView.this.viewer.expandAll();
                }
                catch (Error e) {
                    System.err.println(e.getMessage());
                }
            }
        };
        this.expandAllAction.setToolTipText(Messages.msaa_expand_all);
        this.expandAllAction.setImageDescriptor(GuiImages.IMAGE_EXPAND_ALL);
        this.collapseAllAction = new Action(Messages.msaa_collapse_all){

            public void run() {
                try {
                    FlashDOMView.this.viewer.collapseAll();
                }
                catch (Error e) {
                    e.printStackTrace();
                }
            }
        };
        this.collapseAllAction.setToolTipText(Messages.msaa_collapse_all);
        this.collapseAllAction.setImageDescriptor(GuiImages.IMAGE_COLLAPSE_ALL);
        this.refreshAction = new RefreshRootAction();
        this.informativeTreeAction = new Action(org.eclipse.actf.visualization.internal.flash.Messages.flash_filter_noninformative, 2){

            public void run() {
                FlashDOMContentProvider provider = (FlashDOMContentProvider)FlashDOMView.this.viewer.getContentProvider();
                provider.informativeTree = FlashDOMView.this.informativeTreeAction.isChecked();
                MSAAViewRegistory.refreshRootObject();
            }
        };
        this.visualTreeAction = new Action(org.eclipse.actf.visualization.internal.flash.Messages.flash_show_visual, 2){

            public void run() {
                FlashDOMContentProvider provider = (FlashDOMContentProvider)FlashDOMView.this.viewer.getContentProvider();
                provider.visualTree = FlashDOMView.this.visualTreeAction.isChecked();
                MSAAViewRegistory.refreshRootObject();
            }
        };
        this.debugTreeAction = new Action(org.eclipse.actf.visualization.internal.flash.Messages.flash_debugMode, 2){

            public void run() {
                FlashDOMView.this.debugMode = FlashDOMView.this.debugTreeAction.isChecked();
                FlashNodePropertySource.setDebugMode(FlashDOMView.this.debugMode);
                MSAAViewRegistory.refreshRootObject();
            }
        };
        this.scanWindowlessAction = new Action(org.eclipse.actf.visualization.internal.flash.Messages.flash_scanWindowless, 2){

            public void run() {
                FlashMSAAUtil.setScanAll((boolean)FlashDOMView.this.scanWindowlessAction.isChecked());
                MSAAViewRegistory.refreshRootObject();
            }
        };
    }

    public void setDebugMode(boolean isDebug) {
        this.debugTreeAction.setChecked(isDebug);
        this.scanWindowlessAction.setChecked(isDebug);
        this.debugMode = isDebug;
        FlashNodePropertySource.setDebugMode(isDebug);
        FlashMSAAUtil.setScanAll((boolean)isDebug);
        MSAAViewRegistory.refreshRootObject();
    }

    private Object getSelectedItem() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() == 1) {
            return selection.getFirstElement();
        }
        return null;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private static String getNodeImage(Object element) {
        String iconType = null;
        if (element instanceof IASNode) {
            iconType = ((IASNode)element).getIconType();
            if (iconType.startsWith("accrole_")) {
                try {
                    String tmpS = iconType.substring("accrole_".length());
                    return GuiImages.roleIcon((int)Integer.parseInt(tmpS));
                }
                catch (Exception exception) {}
            }
        } else if (element instanceof IFlashPlayer) {
            iconType = "flash";
        }
        return iconType != null ? FlashImages.flashIcon(iconType) : null;
    }

    private static String getNodeText(Object element) {
        if (element instanceof IASNode) {
            String value;
            String title;
            IASNode flashNode = (IASNode)element;
            StringBuffer sb = new StringBuffer();
            String text = flashNode.getText();
            if (text != null) {
                sb.append(text);
            }
            if ((title = flashNode.getTitle()) != null) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(title);
            }
            if ((value = flashNode.getValue()) != null) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(value);
            }
            if (sb.length() == 0) {
                sb.append(Messages.msaa_NAMELESS);
            }
            String objectName = flashNode.getObjectName();
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(objectName);
            String type = flashNode.getType();
            if (type != null) {
                sb.append("(");
                sb.append(type);
                sb.append(")");
            }
            return sb.toString();
        }
        if (element instanceof IFlashPlayer) {
            return ((IFlashPlayer)element).getStatus();
        }
        if (element == null) {
            return "null";
        }
        return element.toString();
    }

    public String getNodeError(Object element) {
        if (element instanceof IASNode) {
            boolean shouldWarn;
            IASNode flashNode = (IASNode)element;
            if (!flashNode.getPlayer().isVisible()) {
                return "icons/ovr16/black.gif";
            }
            ASAccInfo accInfo = flashNode.getAccInfo();
            if (flashNode.isUIComponent() && (accInfo == null || -1 == accInfo.getRole())) {
                return "icons/ovr16/red.gif";
            }
            boolean bl = shouldWarn = "movieclip".equals(flashNode.getType()) || "Button".equals(flashNode.getClassName());
            if (shouldWarn && accInfo != null && accInfo.isSilent()) {
                return "icons/ovr16/black.gif";
            }
            if (flashNode.getText() != null) {
                return "icons/ovr16/green.gif";
            }
            if (shouldWarn && (accInfo == null || accInfo.getName() == null)) {
                return "icons/ovr16/red.gif";
            }
            if ("Button".equals(flashNode.getClassName())) {
                return "icons/ovr16/yellow.gif";
            }
            String objectName = flashNode.getObjectName();
            if ("onRelease".equals(objectName)) {
                return "icons/ovr16/yellow.gif";
            }
            if ("_accProps".equals(objectName) || "_accImpl".equals(objectName)) {
                return "icons/ovr16/green.gif";
            }
        } else if (element instanceof IFlashPlayer) {
            return "icons/ovr16/black.gif";
        }
        return null;
    }

    private class FlashDOMContentProvider
    implements ITreeContentProvider {
        public boolean visualTree = false;
        public boolean informativeTree = false;

        private FlashDOMContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = new IASNode[]{};
            if (parentElement instanceof IASNode) {
                if (FlashDOMView.this.debugMode) {
                    result = ((IASNode)parentElement).getEntireChildren();
                } else {
                    result = ((IASNode)parentElement).getChildren(this.visualTree);
                    if (this.informativeTree) {
                        Vector<Object> tmpV = new Vector<Object>();
                        Object[] objectArray = result;
                        int n = result.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object node = objectArray[n2];
                            if (!node.isAccProperties()) {
                                if (node.getText() != null || "movieclip".equals(node.getType()) || "Button".equals(node.getClassName()) || "_accProps".equals(node.getObjectName()) || "_accImpl".equals(node.getObjectName()) || "onRelease".equals(node.getObjectName())) {
                                    tmpV.add(node);
                                }
                            } else {
                                tmpV.add(node);
                            }
                            ++n2;
                        }
                        result = new IASNode[tmpV.size()];
                        tmpV.toArray(result);
                    }
                }
            }
            return result;
        }

        public Object getParent(Object element) {
            if (element instanceof IASNode) {
                return ((IASNode)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof IASNode) {
                return ((IASNode)element).hasChild(this.visualTree, FlashDOMView.this.debugMode);
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (inputElement instanceof Object[]) {
                Object[] objects = (Object[])inputElement;
                int i = 0;
                while (i < objects.length) {
                    IFlashPlayer player = null;
                    if (objects[i] instanceof AccessibleObject) {
                        AccessibleObject accObj = (AccessibleObject)objects[i];
                        player = FlashPlayerFactory.getPlayerFromPtr((int)accObj.getPtr());
                    } else if (objects[i] instanceof IFlashPlayer) {
                        player = (IFlashPlayer)objects[i];
                    }
                    if (player != null) {
                        IASNode rootNode = player.getRootNode();
                        if (rootNode != null) {
                            elements.add(rootNode);
                        } else {
                            elements.add(player);
                        }
                    }
                    ++i;
                }
            }
            return elements.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class FlashDOMLabelProvider
    extends LabelProvider
    implements IColorProvider {
        public Image getImage(Object element) {
            String nodeImage = FlashDOMView.getNodeImage(element);
            String nodeError = FlashDOMView.this.getNodeError(element);
            if (nodeImage != null) {
                if (nodeError != null) {
                    return FlashImages.getImage(nodeImage, nodeError, new Point(16, 16));
                }
                return FlashImages.getImage(nodeImage);
            }
            if (nodeError != null) {
                return FlashImages.getImage(nodeError);
            }
            return null;
        }

        public String getText(Object element) {
            return FlashDOMView.getNodeText(element);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            return null;
        }
    }

    private class FlashTreeViewer
    extends TreeViewer {
        public FlashTreeViewer(Composite parent, int style) {
            super(new Tree(parent, style));
        }

        public TreeItem[] getChildItems(TreeItem item) {
            super.createChildren((Widget)item);
            return item.getItems();
        }
    }

    private class RectangleFinder {
        private static final int MARGIN = 10;
        public int foundCount = 0;
        private int errorCount = 0;
        private int flashLeft;
        private int flashTop;
        private int flashRight;
        private int flashBottom;

        public RectangleFinder(Rectangle flashRect) {
            this.flashLeft = flashRect.x;
            this.flashTop = flashRect.y;
            this.flashRight = flashRect.x + flashRect.width;
            this.flashBottom = flashRect.y + flashRect.height;
        }

        public void find(TreeItem[] items) {
            int i = 0;
            while (i < items.length) {
                block9: {
                    TreeItem item = items[i];
                    try {
                        double h;
                        double w;
                        double y;
                        IASNode flashNode = (IASNode)item.getData();
                        if (flashNode.getLevel() >= 40) {
                            throw new Error(String.valueOf(MessageFormat.format((String)org.eclipse.actf.visualization.internal.flash.Messages.flash_error_target_length, (Object[])new Object[]{new Integer(flashNode.getLevel())})) + "\n" + flashNode.getTarget());
                        }
                        double x = flashNode.getX();
                        if (!(x >= (double)(this.flashRight + 10) || (y = flashNode.getY()) >= (double)(this.flashBottom + 10) || x + (w = flashNode.getWidth()) <= (double)(this.flashLeft - 10) || y + (h = flashNode.getHeight()) <= (double)(this.flashTop - 10))) {
                            if (this.isMatch(x, y, w, h)) {
                                item.setBackground(FlashDOMView.this.colorFound);
                                ++this.foundCount;
                                FlashDOMView.this.viewer.reveal((Object)flashNode);
                            }
                            if (!Boolean.TRUE.equals(flashNode.getObject("isOpaqueObject"))) {
                                this.find(((FlashTreeViewer)FlashDOMView.this.viewer).getChildItems(item));
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    catch (FindError e) {
                        throw e;
                    }
                    catch (Error e) {
                        System.err.println(e.getMessage());
                        if (++this.errorCount < 20) break block9;
                        throw new FindError("Error count reached " + this.errorCount);
                    }
                }
                ++i;
            }
        }

        private boolean isMatch(double x, double y, double w, double h) {
            return (double)(this.flashLeft - 10) <= x && x < (double)(this.flashLeft + 10) && (double)(this.flashTop - 10) <= y && y < (double)(this.flashTop + 10) && (double)(this.flashRight - 10) <= x + w && x + w <= (double)(this.flashRight + 10) && (double)(this.flashBottom - 10) <= y + h && y + h <= (double)(this.flashBottom + 10);
        }

        private class FindError
        extends Error {
            private static final long serialVersionUID = -7707451728015676479L;

            public FindError(String message) {
                super(message);
            }
        }
    }
}

