/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.flash.ui.actions;

import org.eclipse.actf.accservice.swtbridge.AccessibleObject;
import org.eclipse.actf.model.flash.util.FlashMSAAUtil;
import org.eclipse.actf.util.win32.VariantUtil;
import org.eclipse.actf.util.win32.comclutch.IDispatch;
import org.eclipse.actf.visualization.gui.ui.views.IFlashDOMView;
import org.eclipse.actf.visualization.gui.ui.views.MSAAViewRegistory;
import org.eclipse.actf.visualization.internal.flash.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.ole.win32.OleAutomation;
import org.eclipse.swt.ole.win32.Variant;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FlashRectFinder {
    private boolean viewVisible = false;
    private AccessibleObject playerWindow = null;
    private Rectangle msaaRect = null;
    private AccessibleObject targetObject = null;

    public FlashRectFinder(Object object) {
        if (object instanceof AccessibleObject && MSAAViewRegistory.findViewReference((String)"org.eclipse.actf.visualization.flash.ui.views.FlashDOMView") != null) {
            boolean bl = this.viewVisible = MSAAViewRegistory.showView((String)"org.eclipse.actf.visualization.flash.ui.views.FlashDOMView", (boolean)false) != null;
            if (this.viewVisible) {
                AccessibleObject accObject = (AccessibleObject)object;
                while (accObject != null) {
                    if (FlashMSAAUtil.isFlash((int)accObject.getPtr())) {
                        this.playerWindow = accObject;
                    }
                    if (this.msaaRect == null) {
                        this.msaaRect = accObject.getAccLocation();
                        this.targetObject = accObject;
                    }
                    accObject = accObject.getCachedParent();
                }
            }
        }
    }

    public void find(Shell shell) {
        if (this.viewVisible) {
            if (this.msaaRect == null) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.flash_flash_dom, (String)Messages.flash_error_no_location);
            } else if (this.playerWindow == null) {
                MessageDialog.openInformation((Shell)shell, (String)Messages.flash_flash_dom, (String)Messages.flash_error_select_flash);
            } else {
                this.reCalculateRect();
                IFlashDOMView flashDOMView = (IFlashDOMView)MSAAViewRegistory.showView((String)"org.eclipse.actf.visualization.flash.ui.views.FlashDOMView", (boolean)true);
                if (flashDOMView != null) {
                    Rectangle playerRect = this.playerWindow.getAccLocation();
                    this.msaaRect.x -= playerRect.x;
                    this.msaaRect.y -= playerRect.y;
                    flashDOMView.findRectangle(this.msaaRect, (Object)this.playerWindow);
                }
            }
        }
    }

    private void reCalculateRect() {
        IDispatch idisp = FlashMSAAUtil.getHtmlElementFromPtr((int)this.playerWindow.getPtr());
        Variant varFlash = VariantUtil.createVariantFromIDispatchAddress((int)((int)idisp.getPtr()));
        if (varFlash != null) {
            int[] idAlignMode;
            OleAutomation automation = varFlash.getAutomation();
            if (automation != null && (idAlignMode = automation.getIDsOfNames(new String[]{"AlignMode"})) != null) {
                AccessibleObject[] siblings = this.targetObject.getCachedParent().getChildren();
                Rectangle[] siblingRects = new Rectangle[siblings.length];
                int i = 0;
                while (i < siblings.length) {
                    if (siblings[i] != null) {
                        siblingRects[i] = siblings[i].getAccLocation();
                    }
                    ++i;
                }
                Variant varAlignMode = automation.getProperty(idAlignMode[0]);
                automation.setProperty(idAlignMode[0], new Variant(5));
                FlashRectFinder.wait(500, 1000);
                Rectangle rect = this.targetObject.getAccLocation();
                if (rect.equals((Object)this.msaaRect)) {
                    int i2 = 0;
                    while (i2 < siblings.length) {
                        if (siblingRects[i2] != null && !(rect = siblings[i2].getAccLocation()).equals((Object)siblingRects[i2])) {
                            this.msaaRect.x += rect.x - siblingRects[i2].x;
                            this.msaaRect.y += rect.y - siblingRects[i2].y;
                            break;
                        }
                        ++i2;
                    }
                } else {
                    this.msaaRect = rect;
                }
                automation.setProperty(idAlignMode[0], varAlignMode);
                FlashRectFinder.wait(500, 1000);
            }
            varFlash.dispose();
        }
    }

    private static void wait(int min, int max) {
        int count = 0;
        int sleep = 1;
        Display display = Display.getCurrent();
        while (count++ < max) {
            if (display.readAndDispatch()) continue;
            if (count >= min) break;
            if (sleep-- <= 0) continue;
            display.sleep();
        }
        if (count > min) {
            System.out.println("wait count=" + count);
        }
    }

    public boolean IsValid() {
        return this.viewVisible && this.playerWindow != null && this.msaaRect != null;
    }
}

