/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.ui.report.table;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.actf.util.comparator.ChainComparator;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.ui.report.table.IResultTableSorter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;

public abstract class ResultTableSorterBase
extends ViewerSorter
implements IResultTableSorter {
    private Pattern pattern = Pattern.compile("\\d+");

    protected int compareScore(IProblemItem item1, IProblemItem item2, int pos) {
        int result;
        block4: {
            Image[] icon2;
            Image[] icon1;
            block5: {
                int[] score1 = item1.getMetricsScores();
                int[] score2 = item2.getMetricsScores();
                try {
                    result = score2[pos] - score1[pos];
                    if (result != 0) break block4;
                    icon1 = item1.getMetricsIcons();
                    icon2 = item2.getMetricsIcons();
                    if (icon1[pos] != null || icon2[pos] == null) break block5;
                    return 1;
                }
                catch (Exception exception) {
                    return 0;
                }
            }
            if (icon1[pos] == null || icon2[pos] != null) break block4;
            return -1;
        }
        return result;
    }

    protected int compareSeverity(IProblemItem item1, IProblemItem item2) {
        return item1.getSeverity() - item2.getSeverity();
    }

    protected int compareGuideline(IProblemItem item1, IProblemItem item2, int pos) {
        String guide1 = item1.getTableDataGuideline()[pos];
        String guide2 = item2.getTableDataGuideline()[pos];
        return this.compareString(guide1, guide2);
    }

    protected int compareLine(IProblemItem tmp1, IProblemItem tmp2) {
        int line1 = tmp1.getLine();
        int line2 = tmp2.getLine();
        if (line1 < 0 && line2 > -1) {
            return 1;
        }
        if (line1 > -1 && line2 < 0) {
            return -1;
        }
        if (line1 == 0 && line2 == 0) {
            return 0;
        }
        int result = tmp1.getLine() - tmp2.getLine();
        if (result == 0) {
            return tmp1.getLineStrMulti().compareTo(tmp2.getLineStrMulti());
        }
        return result;
    }

    protected int compareString(String target1, String target2) {
        if (target1.length() == 0 && target2.length() != 0) {
            return 1;
        }
        if (target1.length() != 0 && target2.length() == 0) {
            return -1;
        }
        return target1.compareTo(target2);
    }

    private int compareEvalItem(String arg1, String arg2) {
        int num2;
        String str2;
        int num1;
        String str1;
        if (arg1.length() == 0) {
            if (arg2.length() > 0) {
                return 1;
            }
            return 0;
        }
        if (arg2.length() == 0) {
            return -1;
        }
        Matcher matcher1 = this.pattern.matcher(arg1);
        Matcher matcher2 = this.pattern.matcher(arg2);
        if (matcher1.find()) {
            str1 = arg1.substring(0, matcher1.start());
            num1 = Integer.parseInt(matcher1.group());
        } else {
            str1 = arg1;
            num1 = Integer.MIN_VALUE;
        }
        if (matcher2.find()) {
            str2 = arg2.substring(0, matcher2.start());
            num2 = Integer.parseInt(matcher2.group());
        } else {
            str2 = arg2;
            num2 = Integer.MIN_VALUE;
        }
        int result = str1.compareTo(str2);
        if (result != 0) {
            return result;
        }
        result = Integer.valueOf(num1).compareTo(num2);
        if (result != 0) {
            return result;
        }
        return this.compareEvalItem(arg1.substring(matcher1.end()), arg2.substring(matcher2.end()));
    }

    protected int compareEvalItem(IEvaluationItem target1, IEvaluationItem target2) {
        return this.compareEvalItem(target1.getTableDataTechniques(), target2.getTableDataTechniques());
    }

    public class DescriptionComparator
    extends StringComparator {
        protected int resolve(Object o1, Object o2) {
            IProblemItem item1 = (IProblemItem)o1;
            IProblemItem item2 = (IProblemItem)o2;
            return super.resolve(item1.getDescription(), item2.getDescription());
        }
    }

    public class ErrorIDComparator
    extends StringComparator {
        protected int resolve(Object o1, Object o2) {
            IProblemItem item1 = (IProblemItem)o1;
            IProblemItem item2 = (IProblemItem)o2;
            String id1 = item1.getId();
            String id2 = item2.getId();
            String[] id1tokens = id1.split("_");
            String[] id2tokens = id2.split("_");
            if (id1tokens.length < 2 || id2tokens.length < 2) {
                return super.resolve(item1.getId(), item2.getId());
            }
            int ret = super.resolve(id1tokens[0], id2tokens[0]);
            if (ret != 0) {
                return ret;
            }
            Double d1 = new Double(id1tokens[1]);
            Double d2 = new Double(id2tokens[1]);
            return d1.compareTo(d2);
        }
    }

    public class GuidelineComparator
    extends ChainComparator {
        private int pos;

        public GuidelineComparator(int pos) {
            this.pos = pos;
        }

        protected int resolve(Object o1, Object o2) {
            return ResultTableSorterBase.this.compareGuideline((IProblemItem)o1, (IProblemItem)o2, this.pos);
        }
    }

    public class LinesComparator
    extends ChainComparator {
        protected int resolve(Object o1, Object o2) {
            return ResultTableSorterBase.this.compareLine((IProblemItem)o1, (IProblemItem)o2);
        }
    }

    public class ScoreCompator
    extends ChainComparator {
        private int pos;

        public ScoreCompator(int pos) {
            this.pos = pos;
        }

        protected int resolve(Object o1, Object o2) {
            return ResultTableSorterBase.this.compareScore((IProblemItem)o1, (IProblemItem)o2, this.pos);
        }
    }

    public class SeverityComparator
    extends ChainComparator {
        protected int resolve(Object o1, Object o2) {
            return ResultTableSorterBase.this.compareSeverity((IProblemItem)o1, (IProblemItem)o2);
        }
    }

    public class StringComparator
    extends ChainComparator {
        protected int resolve(Object o1, Object o2) {
            String target1 = (String)o1;
            String target2 = (String)o2;
            if (target1.length() == 0 && target2.length() != 0) {
                return 1;
            }
            if (target1.length() != 0 && target2.length() == 0) {
                return -1;
            }
            return target1.compareTo(target2);
        }
    }
}

