/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.HTMLParserFactory;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.ui.ImagePositionInfo;
import org.eclipse.actf.model.ui.editor.browser.ICurrentStyles;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.visualization.IVisualizationConst;
import org.eclipse.actf.visualization.lowvision.LowVisionVizPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LowVisionUtil
implements IVisualizationConst {
    static File runtimeHtmlFile = null;

    public static String[] frameAnalyze(IWebBrowserACTF webBrowser) {
        try {
            if (runtimeHtmlFile == null) {
                runtimeHtmlFile = LowVisionVizPlugin.createTempFile("runtime", ".html");
            }
            URL urlBase = new URL(webBrowser.getURL());
            webBrowser.saveDocumentAsHTMLFile(runtimeHtmlFile.getAbsolutePath());
            IHTMLParser htmlParser = HTMLParserFactory.createHTMLParser();
            htmlParser.parse((InputStream)new FileInputStream(runtimeHtmlFile));
            Document document = htmlParser.getDocument();
            Element documentElement = document.getDocumentElement();
            NodeList frameList = documentElement.getElementsByTagName("frame");
            try {
                Element baseE;
                String baseUrlS;
                NodeList baseNL = documentElement.getElementsByTagName("base");
                if (baseNL.getLength() > 0 && (baseUrlS = (baseE = (Element)baseNL.item(baseNL.getLength() - 1)).getAttribute("href")).length() > 0) {
                    URL tmpUrl;
                    urlBase = tmpUrl = new URL(urlBase, baseUrlS);
                }
            }
            catch (Exception exception) {}
            int frameNum = frameList.getLength();
            String[] result = new String[frameNum];
            int i = 0;
            while (i < frameNum) {
                Element frameEl = (Element)frameList.item(i);
                String srcUrl = frameEl.getAttribute("src");
                try {
                    URL url = new URL(urlBase, srcUrl);
                    result[i] = url.toString();
                }
                catch (MalformedURLException e2) {
                    result[i] = "";
                    e2.printStackTrace();
                }
                ++i;
            }
            htmlParser = null;
            return result;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return new String[0];
        }
    }

    public static ImagePositionInfo[] trimInfoImageInHtml(ImagePositionInfo[] target, int height) {
        Vector<ImagePositionInfo> tmpV = new Vector<ImagePositionInfo>();
        int i = 0;
        while (i < target.length) {
            if (target[i].getY() <= height) {
                tmpV.add(target[i]);
            }
            ++i;
        }
        ImagePositionInfo[] result = new ImagePositionInfo[tmpV.size()];
        tmpV.toArray(result);
        return result;
    }

    public static Map<String, ICurrentStyles> trimStyleInfoArray(Map<String, ICurrentStyles> target, int height) {
        HashMap<String, ICurrentStyles> result = new HashMap<String, ICurrentStyles>();
        for (String tmpKey : target.keySet()) {
            try {
                ICurrentStyles tmpS = target.get(tmpKey);
                if (tmpS.getRectangle().y > height) continue;
                result.put(tmpKey, tmpS);
            }
            catch (Exception exception) {}
        }
        return result;
    }
}

