/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.core.config;

import java.io.InputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.actf.core.config.AbstractConfiguration;
import org.eclipse.actf.core.config.ConfigurationException;
import org.eclipse.actf.core.runtime.IRuntimeContext;
import org.eclipse.actf.core.runtime.RuntimeContextFactory;
import org.eclipse.actf.util.resources.ClassLoaderCache;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlConfiguration
extends AbstractConfiguration {
    static final long serialVersionUID = -6983580695767275023L;
    private static final char PATH_SEPARATOR = '.';
    private static final String ROOT_ELEMENT_NAME = "configuration";
    private static final String POOL_ELEMENT = "pool";
    private static final String ATTR_PROPERTY_NAME = "name";
    private static final String ATTR_CONTENT_TYPE = "type";
    private static final String TEXT_CONTENT = ".textContent.";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String POOL_ID = "id";
    private static final String ACTF_XML_PREFIX = "actf";
    private transient String _currentXmlFilePrefix;
    private transient HashMap _attributeMap = new HashMap();
    private transient Logger logger = Logger.getLogger("org.eclipse.actf.core");

    public void addConfigurationData(Object data) throws ConfigurationException {
        if (data instanceof InputStream) {
            InputStream dataStream = (InputStream)data;
            HashSet<String> currentModels = new HashSet<String>();
            if (!this._configMap.isEmpty()) {
                currentModels.addAll(Arrays.asList(this.getModelTypes()));
            }
            this.parseXml(dataStream);
            String[] models = this.getModelTypes();
            int i = 0;
            while (i < models.length) {
                if (!currentModels.contains(models[i])) {
                    this._currentXmlFilePrefix = models[i];
                    this.parseXml(models[i]);
                }
                ++i;
            }
            this._currentXmlFilePrefix = null;
        } else {
            super.addConfigurationData(data);
        }
    }

    protected Map addConfigurationData(Object data, Map configMap) throws ConfigurationException {
        this._configMap = configMap;
        this.addConfigurationData(data);
        return this._configMap;
    }

    public Map getAttributeMap() {
        return (Map)this._attributeMap.get(this.getSymbolPool());
    }

    private void parseXml(InputStream stream) throws ConfigurationException {
        if (stream != null) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse(stream, (DefaultHandler)new ParserHandler());
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "SAXParseException caught while parsing file." + e.getMessage(), e);
                throw new ConfigurationException("Exception caught while trying to parse file." + e.getMessage());
            }
        }
    }

    private void parseXml(String xmlFilePrefix) throws ConfigurationException {
        IRuntimeContext context = RuntimeContextFactory.getInstance().getRuntimeContext();
        InputStream inputStream = context.getResourceLocator().getResourceAsStream(xmlFilePrefix, null, "xml", null);
        if (inputStream != null) {
            this.parseXml(inputStream);
        }
    }

    protected class ParserHandler
    extends DefaultHandler {
        private Locator _locator;
        private Stack _elementStack = new Stack();
        private boolean _readChars;
        private String _key;
        private String _poolName;
        private HashMap _elemAttributeMap;

        protected ParserHandler() {
        }

        public void setDocumentLocator(Locator locator) {
            this._locator = locator;
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this._readChars) {
                HashMap elemAttrs = (HashMap)this._elemAttributeMap.get(this.computeCurrentPath());
                StringBuffer elementData = (StringBuffer)elemAttrs.get(XmlConfiguration.TEXT_CONTENT);
                elementData.append(new String(ch, start, length).trim());
            }
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            if (qName.equals(XmlConfiguration.POOL_ELEMENT)) {
                this._poolName = this.getPoolName(atts.getValue(XmlConfiguration.POOL_ID));
                if (XmlConfiguration.this._configMap.containsKey(this._poolName)) {
                    XmlConfiguration.this.setSymbolPool(this._poolName);
                    this._elemAttributeMap = (HashMap)XmlConfiguration.this._attributeMap.get(this._poolName);
                } else {
                    XmlConfiguration.this.createSymbolPool(this._poolName);
                    this._elemAttributeMap = new HashMap();
                    XmlConfiguration.this._attributeMap.put(this._poolName, this._elemAttributeMap);
                }
            } else if (!qName.equals(XmlConfiguration.ROOT_ELEMENT_NAME)) {
                this._readChars = true;
                if (qName.equals(XmlConfiguration.PROPERTY_ELEMENT)) {
                    this._key = atts.getValue(XmlConfiguration.ATTR_PROPERTY_NAME);
                    if (this._key == null || this._key.length() == 0) {
                        throw new SAXException("No name defined for property in pool " + this._poolName);
                    }
                    this._elementStack.push(".property");
                    HashMap<String, StringBuffer> attributeMap = new HashMap<String, StringBuffer>();
                    attributeMap.put(XmlConfiguration.TEXT_CONTENT, new StringBuffer());
                    this._elemAttributeMap.put(this.computeCurrentPath(), attributeMap);
                } else {
                    this._elementStack.push(qName);
                    String path = this.computeCurrentPath();
                    HashMap<String, CharSequence> attributeMap = (HashMap<String, CharSequence>)this._elemAttributeMap.get(path);
                    if (attributeMap == null) {
                        attributeMap = new HashMap<String, CharSequence>();
                        attributeMap.put(XmlConfiguration.TEXT_CONTENT, new StringBuffer());
                        this._elemAttributeMap.put(path, attributeMap);
                    }
                    if (atts.getLength() > 0) {
                        int i = 0;
                        while (i < atts.getLength()) {
                            attributeMap.put(atts.getQName(i), atts.getValue(i));
                            ++i;
                        }
                    }
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (qName.equals(XmlConfiguration.POOL_ELEMENT)) {
                XmlConfiguration.this._attributeMap.put(this._poolName, this._elemAttributeMap);
                this._readChars = false;
            } else if (!qName.equals(XmlConfiguration.ROOT_ELEMENT_NAME)) {
                HashMap elemAttrs = (HashMap)this._elemAttributeMap.get(this.computeCurrentPath());
                String val = ((StringBuffer)elemAttrs.get(XmlConfiguration.TEXT_CONTENT)).toString();
                String type = (String)elemAttrs.get(XmlConfiguration.ATTR_CONTENT_TYPE);
                this.mapAndSetParameter(val, type);
                ((StringBuffer)elemAttrs.get(XmlConfiguration.TEXT_CONTENT)).setLength(0);
                this._elementStack.pop();
                this._readChars = !this._elementStack.empty();
            }
        }

        public void error(SAXParseException e) throws SAXException {
            XmlConfiguration.this.logger.log(Level.SEVERE, "SAX parse exception -- line: " + this._locator.getLineNumber() + ", column: " + this._locator.getColumnNumber(), e);
            throw e;
        }

        public void warning(SAXParseException e) throws SAXException {
            XmlConfiguration.this.logger.log(Level.WARNING, "SAX parse exception -- line: " + this._locator.getLineNumber() + ", column: " + this._locator.getColumnNumber(), e);
        }

        public void fatalError(SAXParseException e) throws SAXException {
            XmlConfiguration.this.logger.log(Level.SEVERE, "SAX parse exception -- line: " + this._locator.getLineNumber() + ", column: " + this._locator.getColumnNumber(), e);
            throw e;
        }

        private String computeCurrentPath() {
            StringBuffer sb = new StringBuffer();
            Iterator iter = this._elementStack.iterator();
            while (iter.hasNext()) {
                sb.append((String)iter.next());
                if (!iter.hasNext()) continue;
                sb.append('.');
            }
            return sb.toString();
        }

        private String getPoolName(String xmlId) throws SAXException {
            if (xmlId == null || xmlId.length() == 0) {
                throw new SAXException("No id defined for pool");
            }
            String returnValue = XmlConfiguration.this._currentXmlFilePrefix == null || XmlConfiguration.this._currentXmlFilePrefix.equals(XmlConfiguration.ACTF_XML_PREFIX) ? xmlId : String.valueOf(XmlConfiguration.this._currentXmlFilePrefix) + '_' + xmlId;
            return returnValue;
        }

        private void mapAndSetParameter(String val, String type) {
            String path = this.computeCurrentPath();
            if (val == null) {
                val = "";
            }
            if (path.equals(".property")) {
                path = this._key;
            }
            if (type == null || type.equals(String.class.getName())) {
                XmlConfiguration.this.setParameter(path, val);
            } else if (type.equals(Class.class.getName())) {
                Class cls = ClassLoaderCache.getDefault().classForName(val);
                if (cls != null) {
                    XmlConfiguration.this.setParameter(path, cls.getName());
                } else {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Could not find class for value " + val);
                }
            } else if (type.equals(Integer.TYPE.getName()) || type.equals(Integer.class.getName())) {
                try {
                    XmlConfiguration.this.setParameter(path, Integer.parseInt(val));
                }
                catch (NumberFormatException numberFormatException) {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Error parsing value for symbol " + path);
                }
            } else if (type.equals(Double.TYPE.getName()) || type.equals(Double.class.getName())) {
                try {
                    XmlConfiguration.this.setParameter(path, Double.parseDouble(val));
                }
                catch (NumberFormatException numberFormatException) {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Error parsing value for symbol " + path);
                }
            } else if (type.equals(Long.TYPE.getName()) || type.equals(Long.class.getName())) {
                try {
                    XmlConfiguration.this.setParameter(path, Long.parseLong(val));
                }
                catch (NumberFormatException numberFormatException) {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Error parsing value for symbol " + path);
                }
            } else if (type.equals(Float.TYPE.getName()) || type.equals(Float.class.getName())) {
                try {
                    XmlConfiguration.this.setParameter(path, Float.parseFloat(val));
                }
                catch (NumberFormatException numberFormatException) {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Error parsing value for symbol " + path);
                }
            } else if (type.equals(Boolean.TYPE.getName()) || type.equals(Boolean.class.getName())) {
                try {
                    XmlConfiguration.this.setParameter(path, Boolean.valueOf(val));
                }
                catch (NumberFormatException numberFormatException) {
                    XmlConfiguration.this.logger.log(Level.WARNING, "Error parsing value for symbol " + path);
                }
            } else {
                XmlConfiguration.this.setParameter(path, val.toString());
            }
        }
    }
}

