/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.ui.editors.ooo.initializer.util;

import org.eclipse.actf.util.win32.RegistryUtil;
import org.eclipse.ui.PlatformUI;

public class OOoEditorInitUtil {
    private static boolean IS_INITIALIZED = false;
    private static final String ENTRY = "SOFTWARE\\OpenOffice.org\\UNO\\InstallPath";

    public static boolean isOOoInstalled(boolean showHelp) {
        if (IS_INITIALIZED) {
            return true;
        }
        String path = OOoEditorInitUtil.getOpenOfficePath();
        if (path == null) {
            if (showHelp) {
                PlatformUI.getWorkbench().getHelpSystem().displayHelpResource("/org.eclipse.actf.visualization.doc.user/docs/odf/install.html");
            }
            return false;
        }
        IS_INITIALIZED = true;
        System.setProperty("OOo_PROGRAM_PATH", path);
        return true;
    }

    public static String getOpenOfficePath() {
        return RegistryUtil.getRegistryString((int)-2147483646, (String)ENTRY, (String)"");
    }
}

