/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.modelgroup;

import java.util.Hashtable;
import org.eclipse.actf.model.internal.dom.sgml.ISGMLParser;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.CompositeModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.IModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.PlusModelGroup;
import org.eclipse.actf.model.internal.dom.sgml.modelgroup.RepModelGroup;
import org.w3c.dom.Node;

public class AndModelGroup
extends CompositeModelGroup {
    public AndModelGroup(IModelGroup modelGroup) {
        super(modelGroup);
    }

    public void add(IModelGroup modelGroup) {
        this.children[this.childLength++] = modelGroup;
    }

    public String toString() {
        String ret = new String("(");
        int i = 0;
        while (i < this.childLength - 1) {
            ret = String.valueOf(ret) + this.children[i] + '&';
            ++i;
        }
        ret = String.valueOf(ret) + this.children[this.childLength - 1] + ')';
        return ret;
    }

    public boolean match(ISGMLParser parser, Node parent, Node child) {
        Hashtable<Node, AndContext> map = parser.getAndMap();
        AndContext ac = map.get(parent);
        if (ac == null) {
            ac = new AndContext(this);
            map.put(parent, ac);
        } else {
            if (ac.prev != null && ac.prev.match(parser, parent, child)) {
                return true;
            }
            if (ac.prevIndex != -1) {
                ac.mgs[ac.prevIndex] = null;
            }
        }
        int i = this.childLength - 1;
        while (i >= 0) {
            IModelGroup mg = ac.mgs[i];
            if (mg != null && mg.match(parser, parent, child)) {
                ac.prevIndex = i;
                if (mg instanceof RepModelGroup || mg instanceof PlusModelGroup) {
                    ac.prev = mg;
                }
                return true;
            }
            --i;
        }
        return false;
    }

    public boolean optional() {
        int i = this.childLength - 1;
        while (i >= 0) {
            if (!this.children[i].optional()) {
                return false;
            }
            --i;
        }
        return true;
    }

    public class AndContext {
        IModelGroup[] mgs;
        IModelGroup prev = null;
        int prevIndex = -1;

        AndContext(AndModelGroup amg) {
            this.mgs = new IModelGroup[amg.childLength];
            int i = 0;
            while (i < this.mgs.length) {
                this.mgs[i] = amg.children[i];
                ++i;
            }
        }

        void setPrev(IModelGroup mg) {
            this.prev = mg;
        }
    }
}

