/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.html.util;

import java.io.IOException;
import java.io.InputStream;

public class RereadableInputStream
extends InputStream {
    private InputStream in;
    private byte[] buf = new byte[10000];
    private int bufSiz = 0;
    private int index = 0;
    private boolean buffering = true;
    private boolean normal = false;

    public RereadableInputStream(InputStream in) {
        this.in = in;
    }

    public void close() throws IOException {
        if (this.normal) {
            this.in.close();
        }
    }

    public int read() throws IOException {
        if (this.buffering) {
            int ret = this.in.read();
            if (this.bufSiz == this.buf.length) {
                this.buffering = false;
                this.normal = true;
            } else {
                this.buf[this.bufSiz++] = (byte)ret;
            }
            return ret;
        }
        if (this.normal) {
            return this.in.read();
        }
        byte ret = this.buf[this.index++];
        if (this.index == this.bufSiz) {
            this.normal = true;
            this.buf = null;
        }
        return ret;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffering) {
            int ret = this.in.read(b, off, len);
            if (this.bufSiz + ret < this.buf.length) {
                int i = 0;
                while (i < ret) {
                    this.buf[this.bufSiz + i] = b[off + i];
                    ++i;
                }
                this.bufSiz += ret;
            } else {
                this.buffering = false;
                this.normal = true;
            }
            return ret;
        }
        if (this.normal) {
            return this.in.read(b, off, len);
        }
        int ret = 0;
        while (ret < b.length && this.index < this.bufSiz) {
            b[ret] = this.buf[this.index];
            ++ret;
            ++this.index;
        }
        if (this.index == this.bufSiz) {
            this.normal = true;
            this.buf = null;
        }
        return ret;
    }

    public void reset() throws IOException {
        if (!this.buffering) {
            throw new IOException("Cannot reset " + this);
        }
        this.buffering = false;
    }
}

