/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.html.errorhandler;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class FormInserter
implements IErrorHandler {
    private static final String FORM = "FORM";
    private String[] formName = new String[]{"FORM"};
    private String[] formCtrls = new String[]{"INPUT", "SELECT", "TEXTAREA", "LABEL", "BUTTON"};

    public boolean handleError(int code, IParser parser, Node errorNode) throws ParseException, IOException, SAXException {
        if (code != 5) {
            return false;
        }
        if (errorNode instanceof EndTag && errorNode.getNodeName().equalsIgnoreCase(FORM)) {
            Element context = parser.getContext();
            Vector<Node> nodes = new Vector<Node>();
            boolean includeFormCtrl = false;
            Node node = context.getLastChild();
            while (node != null) {
                if (node instanceof Element) {
                    Element element = (Element)node;
                    if (this.hasElement(element, this.formName)) break;
                    if (this.hasFormCtrl(element)) {
                        includeFormCtrl = true;
                    }
                }
                nodes.insertElementAt(node, 0);
                node = node.getPreviousSibling();
            }
            if (!includeFormCtrl) {
                return false;
            }
            Element form = parser.getDocument().createElement(parser.changeDefaultTagCase(FORM));
            Enumeration e = nodes.elements();
            while (e.hasMoreElements()) {
                Node node2 = (Node)e.nextElement();
                context.removeChild(node2);
                form.insertBefore(node2, null);
            }
            context.insertBefore(form, null);
            return true;
        }
        return false;
    }

    private boolean hasFormCtrl(Element top) {
        return this.hasElement(top, this.formCtrls);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean hasElement(Element top, String[] elementNames) {
        Node tmp1 = top;
        while (tmp1 != null) {
            Node tmp2;
            if (tmp1 instanceof Element) {
                int i = 0;
                while (i < elementNames.length) {
                    if (tmp1.getNodeName().equalsIgnoreCase(elementNames[i])) {
                        return true;
                    }
                    ++i;
                }
            }
            if ((tmp2 = tmp1.getFirstChild()) == null) {
                if (tmp1 == top) {
                    return false;
                }
                tmp2 = tmp1.getNextSibling();
            }
            while (tmp2 == null) {
                tmp2 = tmp1.getParentNode();
                if ((tmp1 = tmp2) == top) {
                    return false;
                }
                tmp2 = tmp1.getNextSibling();
            }
            tmp1 = tmp2;
        }
        return false;
    }
}

