/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.html.errorhandler;

import java.io.IOException;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.dom.html.IHTMLParser;
import org.eclipse.actf.model.dom.html.IParser;
import org.eclipse.actf.model.dom.html.NodeUtil;
import org.eclipse.actf.model.dom.html.ParseException;
import org.eclipse.actf.model.dom.html.errorhandler.HTMLErrorHandler;
import org.eclipse.actf.model.internal.dom.html.parser.HTMLParser;
import org.eclipse.actf.model.internal.dom.sgml.impl.EndTag;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class FormExpander
implements IErrorHandler {
    private HTMLErrorHandler htmlErrorHandler;
    private HTMLParser parser;

    public void addTo(IHTMLParser parser) {
        IErrorHandler[] errorHandlers = parser.getErrorHandlers();
        int i = 0;
        while (i < errorHandlers.length) {
            if (errorHandlers[i] instanceof HTMLErrorHandler) {
                this.htmlErrorHandler = (HTMLErrorHandler)errorHandlers[i];
                this.htmlErrorHandler.setKeepForm(false);
                break;
            }
            ++i;
        }
        parser.addErrorHandler(this);
    }

    public void remove() {
        if (this.htmlErrorHandler != null) {
            this.htmlErrorHandler.setKeepForm(true);
            this.parser.removeErrorHandler(this);
        }
    }

    public boolean handleError(int code, IParser parser, Node errorNode) throws ParseException, IOException, SAXException {
        String nodeName = errorNode.getNodeName();
        if (code == 5 && errorNode instanceof EndTag && nodeName.equalsIgnoreCase("FORM")) {
            NodeList forms = parser.getDocument().getElementsByTagName("FORM");
            Element targetForm = (Element)forms.item(forms.getLength() - 1);
            if (targetForm == null || parser.hasEndTag(targetForm)) {
                return false;
            }
            Element targetFirstNode = targetForm;
            Element[] contexts = parser.getContextElements();
            block0: while (targetFirstNode.getParentNode() instanceof Element) {
                Element parent = (Element)targetFirstNode.getParentNode();
                if (targetFirstNode.getElementsByTagName("FORM").getLength() > 1) break;
                int c = contexts.length - 1;
                while (c >= 0) {
                    if (contexts[c] == parent) {
                        Node child = targetFirstNode.getNextSibling();
                        while (child != null) {
                            if (child instanceof Element && ((Element)child).getElementsByTagName("FORM").getLength() > 0) break block0;
                            child = child.getNextSibling();
                        }
                        NodeUtil.remove(targetForm);
                        NodeUtil.add(parent, targetForm, targetFirstNode, parent.getLastChild());
                        if (c != contexts.length - 1) {
                            parser.setContext(parent);
                        }
                        ((EndTag)errorNode).setElement(targetForm);
                        parser.setHasEndTag(targetForm);
                        parser.error(code, "Expanded " + targetForm);
                        return true;
                    }
                    --c;
                }
                targetFirstNode = parent;
            }
        }
        return false;
    }
}

