/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.html;

import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;

public class NodeUtil {
    public static Node commonAncestor(Node anc1, Node anc2) {
        Node p1 = anc1.getParentNode();
        while (p1 != null) {
            Node p2 = anc2.getParentNode();
            while (p2 != null) {
                if (p1 == p2) {
                    return p1;
                }
                p2 = p2.getParentNode();
            }
            p1 = p1.getParentNode();
        }
        return null;
    }

    public static void remove(Node node) {
        Node parent = node.getParentNode();
        if (parent == null) {
            throw new IllegalArgumentException(node + " doesn't have a parent");
        }
        Node child = node.getFirstChild();
        while (child != null) {
            node.removeChild(child);
            parent.insertBefore(child, node);
            child = node.getFirstChild();
        }
        parent.removeChild(node);
    }

    public static void add(Node parent, Node node, Node from, Node to) {
        if (parent == null) {
            throw new IllegalArgumentException("parent=null");
        }
        if (node.getParentNode() != null) {
            throw new IllegalArgumentException(node + " already has its parent");
        }
        if (from != null) {
            if (from.getParentNode() != parent) {
                throw new IllegalArgumentException(from + "'s parent isn't " + parent);
            }
            if (to.getParentNode() != parent) {
                throw new IllegalArgumentException(to + "'s parent isn't " + parent);
            }
            Node child = from;
            while (child != null) {
                if (child == to) {
                    parent.insertBefore(node, from);
                    child = from;
                    while (child != to) {
                        parent.removeChild(child);
                        node.insertBefore(child, null);
                        child = node.getNextSibling();
                    }
                    parent.removeChild(to);
                    node.insertBefore(to, null);
                    return;
                }
                child = child.getNextSibling();
            }
            throw new IllegalArgumentException("No link from " + from + " to " + to);
        }
        parent.insertBefore(node, null);
    }

    public static Node commonAncestor(HTMLCollection ancestors) {
        switch (ancestors.getLength()) {
            case 0: {
                return null;
            }
            case 1: {
                return ancestors.item(0).getParentNode();
            }
        }
        Node ret = NodeUtil.commonAncestor(ancestors.item(0), ancestors.item(1));
        int i = 2;
        while (i < ancestors.getLength()) {
            Node tmp = NodeUtil.commonAncestor(ancestors.item(i - 1), ancestors.item(i));
            if (ret != tmp) {
                ret = NodeUtil.commonAncestor(ret, tmp);
            }
            ++i;
        }
        return ret;
    }
}

