/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.util.accessibility.impl;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.ContentBaseElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.draw.PageElement;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.office.PresentationElement;
import org.eclipse.actf.model.dom.odf.office.SpreadSheetElement;
import org.eclipse.actf.model.dom.odf.office.TextElement;
import org.eclipse.actf.model.dom.odf.presentation.NotesElement;
import org.eclipse.actf.model.dom.odf.range.ITextElementContainer;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.util.accessibility.ScreenReaderSimulator;
import org.eclipse.actf.model.dom.odf.util.converter.impl.TextExtractorImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScreenReaderSimulatorImpl
implements ScreenReaderSimulator {
    private static final String LINE_SEP = System.getProperty("line.separator");
    private ODFElement curElem = null;
    private TextExtractorImpl textExtractor = new TextExtractorImpl();

    public void setDocument(ODFDocument document) {
        this.curElem = (ODFElement)document.getDocumentElement();
        this.textExtractor.setDocument(document, this);
    }

    public void setElement(ODFElement element) {
        this.curElem = element;
        this.textExtractor.setDocument((ODFDocument)element.getOwnerDocument(), this);
    }

    public void setOdfVersion(double odfVersion) {
        this.textExtractor.setOdfVersion(odfVersion);
    }

    private void writePageElementContent(Writer writer, PageElement page) {
        List<ODFElement> children = page.getChildNodesInNavOrder();
        int j = 0;
        while (j < children.size()) {
            String str;
            Node child = children.get(j);
            if (child instanceof ODFElement && !(child instanceof NotesElement) && (str = this.getElementContent((ODFElement)child)) != null) {
                try {
                    writer.write(str);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            ++j;
        }
    }

    public boolean extractContent(Writer writer, File dir, ODFElement elem, boolean enableStyle) {
        return this.textExtractor.extractContent(writer, dir, elem, enableStyle);
    }

    public String getElementContent(ODFElement elem) {
        this.setElement(elem);
        StringWriter writer = new StringWriter();
        if (elem instanceof PageElement) {
            this.writePageElementContent(writer, (PageElement)elem);
        } else {
            this.extractContent(writer, null, elem, false);
        }
        String str = "";
        try {
            writer.flush();
            writer.close();
            str = writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    public String getCurrentElementContent() {
        return this.getElementContent(this.curElem);
    }

    private String getTextDocumentContent(TextElement textElem) {
        StringWriter writer = new StringWriter();
        Iterator<ITextElementContainer> iter = textElem.getChildIterator();
        while (iter.hasNext()) {
            String str;
            Element child = iter.next();
            if (!(child instanceof ODFElement) || (str = this.getElementContent((ODFElement)child)) == null) continue;
            writer.write(str);
        }
        String str = "";
        try {
            writer.flush();
            writer.close();
            str = writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    private String getSpreadsheetDocumentContent(SpreadSheetElement spreadElem) {
        StringWriter writer = new StringWriter();
        int i = 0;
        while ((long)i < spreadElem.getTableSize()) {
            TableElement table = spreadElem.getTable(i);
            String str = this.getElementContent(table);
            if (str != null) {
                writer.write(String.valueOf(str) + LINE_SEP);
            }
            ++i;
        }
        String str = "";
        try {
            writer.flush();
            writer.close();
            str = writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    private String getPresentationDocumentContent(PresentationElement presenElem) {
        StringWriter writer = new StringWriter();
        int i = 0;
        while ((long)i < presenElem.getPageSize()) {
            PageElement page = presenElem.getPage(i);
            NotesElement notes = page.getPresentationNotesElement();
            writer.write("Page ");
            writer.write(i + 1);
            writer.write(LINE_SEP);
            writer.write(this.getElementContent(page));
            writer.write(LINE_SEP);
            writer.write("--------------------------------------");
            writer.write(LINE_SEP);
            writer.write("Speaker Notes");
            writer.write(LINE_SEP);
            writer.write(this.getElementContent(notes));
            ++i;
        }
        String str = "";
        try {
            writer.flush();
            writer.close();
            str = writer.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return str;
    }

    public String getDocumentContent() {
        if (this.curElem == null) {
            return null;
        }
        Element root = this.curElem.getOwnerDocument().getDocumentElement();
        if (root instanceof DocumentContentElement) {
            BodyElement body = ((DocumentContentElement)root).getBodyElement();
            ContentBaseElement content = body.getContent();
            ODFConstants.ContentType type = content.getContentType();
            if (type.equals((Object)ODFConstants.ContentType.WRITE) && content instanceof TextElement) {
                return this.getTextDocumentContent((TextElement)content);
            }
            if (type.equals((Object)ODFConstants.ContentType.SPREADSHEET) && content instanceof SpreadSheetElement) {
                return this.getSpreadsheetDocumentContent((SpreadSheetElement)content);
            }
            if (type.equals((Object)ODFConstants.ContentType.PRESENTATION) && content instanceof PresentationElement) {
                return this.getPresentationDocumentContent((PresentationElement)content);
            }
            new ODFException("invalid content element").printStackTrace();
        } else {
            new ODFException("invalid odf document").printStackTrace();
        }
        return null;
    }
}

