/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.util.accessibility;

import java.util.List;
import org.eclipse.actf.model.dom.odf.ODFConstants;
import org.eclipse.actf.model.dom.odf.base.DrawingObjectBaseElement;
import org.eclipse.actf.model.dom.odf.base.DrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.EmbedDrawingObjectElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.content.IStylable;
import org.eclipse.actf.model.dom.odf.draw.ControlElement;
import org.eclipse.actf.model.dom.odf.draw.FrameElement;
import org.eclipse.actf.model.dom.odf.draw.TextBoxElement;
import org.eclipse.actf.model.dom.odf.form.FormControlElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.office.SpreadSheetElement;
import org.eclipse.actf.model.dom.odf.presentation.NotesElement;
import org.eclipse.actf.model.dom.odf.style.StyleElement;
import org.eclipse.actf.model.dom.odf.style.StylePropertiesBase;
import org.eclipse.actf.model.dom.odf.style.TableCellPropertiesElement;
import org.eclipse.actf.model.dom.odf.table.CoveredTableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableCellElement;
import org.eclipse.actf.model.dom.odf.table.TableColumnElement;
import org.eclipse.actf.model.dom.odf.table.TableElement;
import org.eclipse.actf.model.dom.odf.table.TableRowElement;
import org.eclipse.actf.model.dom.odf.text.PElement;
import org.eclipse.actf.model.dom.odf.text.SequenceElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AccessibilityFixEngine {
    private static final String COLON = ":";
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile("./ancestor::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='section'][attribute::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:text:1.0' and local-name()='display']='none']");
    private static final Object EXP2 = xpathService.compile("./ancestor::*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table-cell') or (namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='covered-table-cell')]");
    private static final Object EXP3 = xpathService.compile("./ancestor::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:table:1.0' and local-name()='table'][parent::*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:office:1.0' and local-name()='spreadsheet']]");
    private double odfVersion = -1.0;

    public AccessibilityFixEngine() {
    }

    public AccessibilityFixEngine(double odfVersion) {
        this.odfVersion = odfVersion;
    }

    public boolean fixShortDesc(ODFElement target, String shortDesc) {
        if (shortDesc == null || shortDesc.length() == 0) {
            return false;
        }
        if (target instanceof DrawingObjectBaseElement) {
            ODFElement shortDescElem = null;
            shortDescElem = this.odfVersion != -1.0 ? ((DrawingObjectBaseElement)target).getShortDescElement(this.odfVersion) : ((DrawingObjectBaseElement)target).getShortDescElement();
            if (shortDescElem == null) {
                Document doc = target.getOwnerDocument();
                if (doc instanceof ODFDocument) {
                    Element newElem = null;
                    ODFDocument odfDoc = (ODFDocument)doc;
                    String svgPrefix = target.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
                    if (svgPrefix == null) {
                        return false;
                    }
                    if (this.odfVersion == 1.0 || this.odfVersion == -1.0 && odfDoc.getODFVersion() == 1.0) {
                        newElem = doc.createElement(String.valueOf(svgPrefix) + COLON + "desc");
                        newElem.setTextContent(shortDesc);
                    } else if (this.odfVersion > 1.0 || this.odfVersion == -1.0 && odfDoc.getODFVersion() > 1.0) {
                        newElem = doc.createElement(String.valueOf(svgPrefix) + COLON + "title");
                        newElem.setTextContent(shortDesc);
                    }
                    if (newElem != null) {
                        if (target instanceof EmbedDrawingObjectElement) {
                            Element parent = (Element)target.getParentNode();
                            parent.appendChild(newElem);
                            return true;
                        }
                        if (target instanceof DrawingObjectElement) {
                            target.appendChild(newElem);
                            return true;
                        }
                    }
                }
            } else {
                shortDescElem.setTextContent(shortDesc);
                return true;
            }
        }
        return false;
    }

    public boolean fixLongDesc(ODFElement target, String longDesc) {
        if (longDesc == null || longDesc.length() == 0) {
            return false;
        }
        if (target instanceof DrawingObjectBaseElement) {
            ODFElement longDescElem = null;
            longDescElem = this.odfVersion != -1.0 ? ((DrawingObjectBaseElement)target).getLongDescElement(this.odfVersion) : ((DrawingObjectBaseElement)target).getLongDescElement();
            if (longDescElem == null) {
                Document doc = target.getOwnerDocument();
                if (doc instanceof ODFDocument) {
                    Element newElem = null;
                    ODFDocument odfDoc = (ODFDocument)doc;
                    Element parent = (Element)target.getParentNode();
                    if (this.odfVersion > 1.0 || this.odfVersion == -1.0 && odfDoc.getODFVersion() > 1.0) {
                        String svgPrefix = target.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:svg-compatible:1.0");
                        if (svgPrefix == null) {
                            return false;
                        }
                        newElem = doc.createElement(String.valueOf(svgPrefix) + COLON + "desc");
                        newElem.setTextContent(longDesc);
                    }
                    if (newElem != null) {
                        if (target instanceof EmbedDrawingObjectElement) {
                            parent.appendChild(newElem);
                            return true;
                        }
                        if (target instanceof DrawingObjectElement) {
                            target.appendChild(newElem);
                            return true;
                        }
                    }
                }
            } else {
                longDescElem.setTextContent(longDesc);
                return true;
            }
        }
        return false;
    }

    private void expandRepeatedTableRow(TableRowElement row) {
        int repeat = row.getAttrTableNumberRowsRepeated();
        if (repeat != -1) {
            Node rowParent = row.getParentNode();
            row.removeAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-rows-repeated");
            int i = 0;
            while (i < repeat - 1) {
                TableRowElement cloneRow = (TableRowElement)row.cloneNode(false);
                rowParent.insertBefore(cloneRow, row);
                ++i;
            }
        }
    }

    public boolean fixTableRowHeader(ODFElement target, int headerNum) {
        if (target instanceof TableElement) {
            NodeList testnl = ((TableElement)target).getTableHeaderRows();
            if (testnl != null && testnl.getLength() > 0) {
                return false;
            }
            Document doc = target.getOwnerDocument();
            if (doc instanceof ODFDocument) {
                String tablePrefix = target.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:table:1.0");
                if (tablePrefix == null) {
                    return false;
                }
                Element headerRow = doc.createElement(String.valueOf(tablePrefix) + COLON + "table-header-rows");
                List<TableRowElement> rowList = ((TableElement)target).getTableRowChildren();
                int i = 0;
                while (i < rowList.size()) {
                    this.expandRepeatedTableRow(rowList.get(i));
                    ++i;
                }
                rowList = ((TableElement)target).getTableRowChildren();
                if (rowList.size() == 0 || headerNum > rowList.size()) {
                    return false;
                }
                Node newHeaderRow = target.insertBefore(headerRow, rowList.get(0));
                int i2 = 0;
                while (i2 < headerNum) {
                    TableRowElement row = rowList.get(i2);
                    newHeaderRow.appendChild(row);
                    ++i2;
                }
                return true;
            }
        }
        return false;
    }

    private void expandRepeatedTableColumn(TableColumnElement col) {
        int repeat = col.getAttrTableNumberColumnsRepeated();
        if (repeat != -1) {
            Node colParent = col.getParentNode();
            col.removeAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "number-columns-repeated");
            int i = 0;
            while (i < repeat - 1) {
                TableColumnElement cloneCol = (TableColumnElement)col.cloneNode(false);
                colParent.insertBefore(cloneCol, col);
                ++i;
            }
        }
    }

    public boolean fixTableColumnHeader(ODFElement target, int headerNum) {
        if (target instanceof TableElement) {
            NodeList testnl = ((TableElement)target).getTableHeaderColumns();
            if (testnl != null && testnl.getLength() > 0) {
                return false;
            }
            Document doc = target.getOwnerDocument();
            if (doc instanceof ODFDocument) {
                String tablePrefix = target.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:table:1.0");
                if (tablePrefix == null) {
                    return false;
                }
                Element headerColumn = doc.createElement(String.valueOf(tablePrefix) + COLON + "table-header-columns");
                List<TableColumnElement> colList = ((TableElement)target).getTableColumnChildren();
                int i = 0;
                while (i < colList.size()) {
                    this.expandRepeatedTableColumn(colList.get(i));
                    ++i;
                }
                colList = ((TableElement)target).getTableColumnChildren();
                if (colList.size() == 0 || headerNum > colList.size()) {
                    return false;
                }
                Node newHeaderColumn = target.insertBefore(headerColumn, colList.get(0));
                int i2 = 0;
                while (i2 < headerNum) {
                    TableColumnElement col = colList.get(i2);
                    newHeaderColumn.appendChild(col);
                    ++i2;
                }
                return true;
            }
        }
        return false;
    }

    public boolean fixTableCaption(ODFElement target, String caption) {
        if (caption == null || caption.length() == 0) {
            return false;
        }
        if (target instanceof TableElement) {
            SequenceElement test = ((TableElement)target).getTextSequenceElement();
            if (test != null) {
                return false;
            }
            Document doc = target.getOwnerDocument();
            if (doc instanceof ODFDocument) {
                Element newPElem = null;
                String textPrefix = target.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:text:1.0");
                if (textPrefix == null) {
                    return false;
                }
                String stylePrefix = target.lookupPrefix("urn:oasis:names:tc:opendocument:xmlns:style:1.0");
                if (stylePrefix == null) {
                    return false;
                }
                Element pElem = doc.createElement(String.valueOf(textPrefix) + COLON + "p");
                pElem.setAttribute(String.valueOf(textPrefix) + COLON + "style-name", "Table");
                Node parent = target.getParentNode();
                Node nextNode = target.getNextSibling();
                newPElem = nextNode == null ? (Element)parent.appendChild(pElem) : (Element)parent.insertBefore(pElem, nextNode);
                if (newPElem != null) {
                    newPElem.appendChild(doc.createTextNode("Table "));
                    Element seqElem = doc.createElement(String.valueOf(textPrefix) + COLON + "sequence");
                    seqElem.setAttribute(String.valueOf(textPrefix) + COLON + "name", "Table");
                    seqElem.setAttribute(String.valueOf(textPrefix) + COLON + "formula", "ooow:Table+1");
                    seqElem.setAttribute(String.valueOf(stylePrefix) + COLON + "num-format", "1");
                    newPElem.appendChild(seqElem);
                    Text captionText = doc.createTextNode(" : " + caption);
                    newPElem.appendChild(captionText);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isFormLabelFixCapable(ODFElement target) {
        FormControlElement formControl;
        String controlImpl;
        return target instanceof ControlElement && ((controlImpl = (formControl = ((ControlElement)target).getFormControlElement()).getAttrFormControlImplementation()).endsWith("com.sun.star.form.component.CheckBox") || controlImpl.endsWith("com.sun.star.form.component.OptionButton") || controlImpl.endsWith("com.sun.star.form.component.PushButton") || controlImpl.endsWith("com.sun.star.form.component.RadioButton") || controlImpl.endsWith("com.sun.star.form.component.GroupBox"));
    }

    public boolean fixFormLabel(ODFElement target, String label) {
        if (label == null || label.length() == 0) {
            return false;
        }
        if (target instanceof ControlElement) {
            FormControlElement formControl = ((ControlElement)target).getFormControlElement();
            if (formControl.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:form:1.0", "label")) {
                formControl.removeAttributeNS("urn:oasis:names:tc:opendocument:xmlns:form:1.0", "label");
            }
            String formPrefix = formControl.getPrefix();
            formControl.setAttribute(String.valueOf(formPrefix) + COLON + "label", label);
            return true;
        }
        return false;
    }

    public boolean fixFormTabStop(ODFElement target, boolean tabStop) {
        if (target instanceof ControlElement) {
            FormControlElement formControl = ((ControlElement)target).getFormControlElement();
            if (formControl.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:form:1.0", "tab-stop")) {
                formControl.removeAttributeNS("urn:oasis:names:tc:opendocument:xmlns:form:1.0", "tab-stop");
            }
            String formPrefix = formControl.getPrefix();
            formControl.setAttribute(String.valueOf(formPrefix) + COLON + "tab-stop", new Boolean(tabStop).toString());
            return true;
        }
        return false;
    }

    public boolean isInvisibleElement(ODFElement elem) {
        NodeList nl = xpathService.evalForNodeList(EXP1, (Node)elem);
        return nl != null && nl.getLength() > 0;
    }

    public String getInvisibleSectionName(ODFElement elem) {
        Element section;
        NodeList nl = xpathService.evalForNodeList(EXP1, (Node)elem);
        if (nl != null && nl.getLength() > 0 && nl.item(0) instanceof Element && (section = (Element)nl.item(0)).hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "name")) {
            return section.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "name");
        }
        return null;
    }

    public boolean isProtectedElement(ODFElement target) {
        Node node;
        ODFConstants.ContentType type = ODFConstants.ContentType.NONE;
        Element content = target.getOwnerDocument().getDocumentElement();
        if (content instanceof DocumentContentElement) {
            type = ((DocumentContentElement)content).getBodyElement().getContent().getContentType();
        }
        if (type != ODFConstants.ContentType.SPREADSHEET) {
            return false;
        }
        if (target instanceof SpreadSheetElement) {
            SpreadSheetElement spreadsheet = (SpreadSheetElement)target;
            return spreadsheet.getAttrTableStructureProtected();
        }
        if (target instanceof TableElement) {
            TableElement table = (TableElement)target;
            return table.getAttrTableProtected();
        }
        SpreadSheetElement spreadsheet = null;
        Node table = null;
        IStylable cell = null;
        if (target instanceof TableCellElement || target instanceof CoveredTableCellElement) {
            cell = (IStylable)((Object)target);
        } else {
            NodeList cellList = xpathService.evalForNodeList(EXP2, (Node)target);
            if (cellList != null && cellList.getLength() == 1 && ((node = cellList.item(0)) instanceof TableCellElement || node instanceof CoveredTableCellElement)) {
                cell = (IStylable)((Object)node);
            }
        }
        if (cell == null) {
            return false;
        }
        NodeList tableList = xpathService.evalForNodeList(EXP3, (Node)target);
        if (tableList != null && tableList.getLength() == 1 && (node = tableList.item(0)) instanceof TableElement) {
            table = (TableElement)node;
        }
        if (table == null) {
            return false;
        }
        Node tableParent = table.getParentNode();
        if (tableParent instanceof SpreadSheetElement) {
            spreadsheet = (SpreadSheetElement)tableParent;
        }
        if (spreadsheet == null) {
            return false;
        }
        if (spreadsheet.getAttrTableStructureProtected() || table.getAttrTableProtected()) {
            int cellProtect = 0;
            StyleElement styleElem = cell.getStyle();
            if (styleElem != null) {
                int i = 0;
                while ((long)i < styleElem.getPropertySize()) {
                    StylePropertiesBase prop = styleElem.getPropertyElement(i);
                    if (prop instanceof TableCellPropertiesElement) {
                        TableCellPropertiesElement cellProp = (TableCellPropertiesElement)prop;
                        cellProtect = cellProp.getAttrStyleCellProtect();
                    }
                    ++i;
                }
            }
            if (cellProtect == 2 || cellProtect == 4) {
                return true;
            }
            if (cellProtect == 0) {
                if (table.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "protected")) {
                    return table.getAttrTableProtected();
                }
                if (spreadsheet.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:table:1.0", "structure-protected")) {
                    return spreadsheet.getAttrTableStructureProtected();
                }
            }
        }
        return false;
    }

    public void setSpeakerNotesContent(NotesElement notes, String content) {
        String[] contentList = content.split("\n");
        NodeList frameList = notes.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "frame");
        if (frameList == null || frameList.getLength() <= 0) {
            return;
        }
        Element notesFrame = null;
        int i = 0;
        while (i < frameList.getLength()) {
            FrameElement frame;
            String presentationClass;
            Node node = frameList.item(i);
            if (node instanceof FrameElement && (presentationClass = (frame = (FrameElement)node).getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:presentation:1.0", "class")) != null && presentationClass.equals("notes")) {
                notesFrame = frame;
            }
            ++i;
        }
        if (notesFrame == null) {
            return;
        }
        NodeList textBoxList = notesFrame.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "text-box");
        if (textBoxList == null || textBoxList.getLength() != 1) {
            return;
        }
        Document doc = notes.getOwnerDocument();
        TextBoxElement textBox = (TextBoxElement)textBoxList.item(0);
        NodeList pList = textBox.getElementsByTagNameNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p");
        int i2 = 0;
        while (i2 < contentList.length) {
            PElement pElem = null;
            pElem = i2 == 0 && pList != null && pList.getLength() == 1 ? (PElement)pList.item(0) : (PElement)doc.createElementNS("urn:oasis:names:tc:opendocument:xmlns:text:1.0", "p");
            textBox.appendChild(pElem);
            Text text = doc.createTextNode(contentList[i2]);
            pElem.appendChild(text);
            ++i2;
        }
    }
}

