/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.internal.dom.odf.OdfPlugin;
import org.eclipse.core.runtime.IPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODFWriter {
    private static final String SLASH = "/";

    private void addFileToZip(ZipOutputStream zos, String inputDir, File file) throws IOException, Exception {
        if (file.isDirectory()) {
            String entry = file.getPath();
            entry = entry.substring(inputDir.length() + 1);
            entry = entry.replaceAll("\\\\", SLASH);
            ZipEntry target = new ZipEntry(String.valueOf(entry) + SLASH);
            target.setSize(0L);
            zos.putNextEntry(target);
            zos.closeEntry();
            File[] fileList = file.listFiles();
            int i = 0;
            while (i < fileList.length) {
                this.addFileToZip(zos, inputDir, fileList[i]);
                ++i;
            }
        } else {
            int count;
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            String entry = file.getPath();
            entry = entry.substring(inputDir.length() + 1);
            entry = entry.replaceAll("\\\\", SLASH);
            ZipEntry target = new ZipEntry(entry);
            zos.putNextEntry(target);
            byte[] buf = new byte[1024];
            while ((count = bis.read(buf, 0, 1024)) != -1) {
                zos.write(buf, 0, count);
            }
            bis.close();
            zos.closeEntry();
        }
    }

    public List<String> unzipODFFile(String odfName, String outputDir) {
        ArrayList<String> outputFileList = new ArrayList<String>();
        FileOutputStream fos = null;
        URL url = null;
        try {
            url = new URL(odfName);
        }
        catch (MalformedURLException malformedURLException) {}
        try {
            ZipFile zipFile = null;
            zipFile = url != null ? new ZipFile(new File(url.toURI())) : new ZipFile(odfName);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry zent = entries.nextElement();
                String fileName = zent.getName();
                if (fileName.contains(SLASH)) {
                    int lastIndex = fileName.lastIndexOf(SLASH);
                    File dir = new File(String.valueOf(outputDir) + File.separator + fileName.substring(0, lastIndex));
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                }
                if (fileName.endsWith(SLASH)) continue;
                BufferedInputStream bis = new BufferedInputStream(zipFile.getInputStream(zent));
                String outputFile = String.valueOf(outputDir) + File.separator + fileName;
                outputFileList.add(outputFile);
                fos = new FileOutputStream(outputFile);
                try {
                    try {
                        int size;
                        byte[] buffer = new byte[8192];
                        while ((size = bis.read(buffer)) != -1) {
                            fos.write(buffer, 0, size);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        fos.close();
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    fos.close();
                    throw throwable;
                }
                fos.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outputFileList;
    }

    public void createODFFile(String inputDir, String outputODFName) {
        File inputDirFile = new File(inputDir);
        if (inputDirFile.isDirectory()) {
            URL url = null;
            try {
                url = new URL(outputODFName);
            }
            catch (MalformedURLException malformedURLException) {}
            try {
                File zipFile = null;
                zipFile = url != null ? new File(url.toURI()) : new File(outputODFName);
                File[] fileList = inputDirFile.listFiles();
                ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));
                int i = 0;
                while (i < fileList.length) {
                    this.addFileToZip(zos, inputDir, fileList[i]);
                    ++i;
                }
                zos.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean rmDir(File deletedDir) {
        File[] files = deletedDir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (!this.rmDir(files[i])) {
                    return false;
                }
                ++i;
            }
        }
        return deletedDir.delete();
    }

    public void saveODFFile(ODFDocument doc, String outFile) {
        String inFile = doc.getURL();
        IPath tmpDir = OdfPlugin.getDefault().getStateLocation().append("tmp");
        File tmpDirFile = tmpDir.toFile();
        tmpDirFile.mkdir();
        String tmpDirPath = tmpDirFile.getPath();
        ODFWriter odfWriter = new ODFWriter();
        odfWriter.unzipODFFile(inFile, tmpDirPath);
        try {
            FileOutputStream writer = new FileOutputStream(String.valueOf(tmpDirPath) + System.getProperty("file.separator") + "content.xml");
            TransformerFactory tFactory = TransformerFactory.newInstance();
            DOMSource source = new DOMSource(doc);
            StreamResult target = new StreamResult(writer);
            try {
                tFactory.newTransformer().transform(source, target);
            }
            catch (TransformerConfigurationException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            writer.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        odfWriter.createODFFile(tmpDirPath, outFile);
        this.rmDir(tmpDirFile);
    }
}

