/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.dom.odf.draw.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.actf.model.dom.odf.ODFException;
import org.eclipse.actf.model.dom.odf.base.ContentBaseElement;
import org.eclipse.actf.model.dom.odf.base.ODFDocument;
import org.eclipse.actf.model.dom.odf.base.ODFElement;
import org.eclipse.actf.model.dom.odf.base.impl.ODFElementImpl;
import org.eclipse.actf.model.dom.odf.draw.PageElement;
import org.eclipse.actf.model.dom.odf.office.BodyElement;
import org.eclipse.actf.model.dom.odf.office.DocumentContentElement;
import org.eclipse.actf.model.dom.odf.presentation.NotesElement;
import org.eclipse.actf.util.xpath.XPathService;
import org.eclipse.actf.util.xpath.XPathServiceFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PageElementImpl
extends ODFElementImpl
implements PageElement {
    private static final long serialVersionUID = 8198841362223795490L;
    private static final XPathService xpathService = XPathServiceFactory.newService();
    private static final Object EXP1 = xpathService.compile("./*[(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='rect') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='line') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='polyline') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='polygon') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='regular-polygon') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='path') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='circle') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='ellipse') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='g') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='page-thumbnail') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='measure') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='caption') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='connector') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='custom-shape') or(namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:dr3d:1.0' and local-name()='scene')]");
    private static final Object EXP2 = xpathService.compile("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:drawing:1.0' and local-name()='page']");
    private static final Object EXP3 = xpathService.compile("./*[namespace-uri()='urn:oasis:names:tc:opendocument:xmlns:presentation:1.0' and local-name()='notes']");
    private ContentBaseElement contentElement = null;

    protected PageElementImpl(ODFDocument odfDoc, Element element) {
        super(odfDoc, element);
    }

    @Override
    public ODFElement createObject(long x, long y, long width, long height) {
        return null;
    }

    @Override
    public int getPageIndex() {
        if (this.odfDoc == null) {
            return -1;
        }
        Element root = this.odfDoc.getDocumentElement();
        if (root instanceof DocumentContentElement) {
            BodyElement body = ((DocumentContentElement)root).getBodyElement();
            this.contentElement = body.getContent();
        }
        if (this.contentElement == null) {
            return -1;
        }
        NodeList list = XPathServiceFactory.newService().evalForNodeList(EXP2, (Node)this.contentElement);
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).equals(this)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public String getAttrDrawName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "name");
        }
        return null;
    }

    @Override
    public String getAttrDrawStyleName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "style-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "style-name");
        }
        return null;
    }

    @Override
    public String getAttrDrawMasterPageName() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "master-page-name")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "master-page-name");
        }
        return null;
    }

    @Override
    public String getAttrDrawNavOrder() {
        if (this.hasAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "nav-order")) {
            return this.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "nav-order");
        }
        return null;
    }

    @Override
    public List<ODFElement> getChildNodesInNavOrder() {
        ArrayList<ODFElement> children = new ArrayList<ODFElement>();
        NodeList nl = this.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            if (nl.item(i) instanceof ODFElement) {
                children.add((ODFElement)nl.item(i));
            }
            ++i;
        }
        String navOrder = this.getAttrDrawNavOrder();
        if (navOrder == null) {
            return children;
        }
        Collections.sort(children, new NavOrderComparator());
        return children;
    }

    @Override
    public NodeList getDrawingObjectElements() {
        return xpathService.evalForNodeList(EXP1, (Node)this);
    }

    @Override
    public NotesElement getPresentationNotesElement() {
        NodeList nl = xpathService.evalForNodeList(EXP3, (Node)this);
        if (nl != null && nl.getLength() == 1) {
            return (NotesElement)nl.item(0);
        }
        if (nl != null && nl.getLength() > 1) {
            new ODFException("draw:page has more than one presentation:notes element").printStackTrace();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NavOrderComparator
    implements Comparator<ODFElement> {
        private NavOrderComparator() {
        }

        private int getNavOrder(ODFElement shape, String navOrders) {
            int index;
            String id = shape.getAttributeNS("urn:oasis:names:tc:opendocument:xmlns:drawing:1.0", "id");
            if (id != null && (index = navOrders.indexOf(id)) >= 0) {
                return index;
            }
            return navOrders.length();
        }

        private int getZOrder(ODFElement shape) {
            Node parent = shape.getParentNode();
            if (!(parent instanceof PageElement)) {
                return -1;
            }
            int index = 0;
            Node preSib = shape.getPreviousSibling();
            while (preSib != null) {
                if (preSib instanceof ODFElement) {
                    ++index;
                }
                preSib = preSib.getPreviousSibling();
            }
            return index;
        }

        @Override
        public int compare(ODFElement a, ODFElement b) {
            int oDelta;
            String navOrders = PageElementImpl.this.getAttrDrawNavOrder();
            if (navOrders != null && (oDelta = this.getNavOrder(a, navOrders) - this.getNavOrder(b, navOrders)) != 0) {
                return oDelta;
            }
            oDelta = this.getZOrder(a) - this.getZOrder(b);
            if (oDelta != 0) {
                return oDelta;
            }
            return 0;
        }
    }
}

