/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.actf.visualization.engines.blind.html.IVisualizeMapData;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.DocumentCleaner;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizeMapDataImpl
implements IVisualizeMapData {
    private Map<Node, Node> orig2resultMap = new HashMap<Node, Node>(1024);
    private Map<Node, Node> result2origMap = new HashMap<Node, Node>(1024);
    private Map<Node, Integer> orig2idMap = new HashMap<Node, Integer>(1024);
    private Map<Node, Integer> result2idMap = new HashMap<Node, Integer>(1024);
    private Map<Integer, Integer> accId2id = new HashMap<Integer, Integer>(1024);
    private Map<Integer, Integer> id2accId = new HashMap<Integer, Integer>(1024);
    private Map<Node, VisualizationNodeInfo> node2infoMap = new HashMap<Node, VisualizationNodeInfo>(1024);
    private Map<Node, Node> removedNodeMap = new HashMap<Node, Node>(512);
    private Map<Node, Node> intraPageLinkMap = new HashMap<Node, Node>(256);
    private List<VisualizationNodeInfo> nodeInfoList = new ArrayList<VisualizationNodeInfo>(1024);

    protected Map<Node, Node> getOrig2ResultMap() {
        return this.orig2resultMap;
    }

    protected Map<Integer, Integer> getAccId2IdMap() {
        return this.accId2id;
    }

    public Map<Integer, Integer> getId2AccIdMap() {
        return this.id2accId;
    }

    @Override
    public Map<Node, Integer> getOrig2idMap() {
        return this.orig2idMap;
    }

    public Map<Node, Integer> getResult2idMap() {
        return this.result2idMap;
    }

    protected Map<Node, Node> getIntraPageLinkMap() {
        return this.intraPageLinkMap;
    }

    public List<VisualizationNodeInfo> getNodeInfoList() {
        return this.nodeInfoList;
    }

    protected Map<Node, VisualizationNodeInfo> getNode2infoMap() {
        return this.node2infoMap;
    }

    protected void addOrigResultMapping(Node orig, Node result) {
        this.orig2resultMap.put(orig, result);
        this.result2origMap.put(result, orig);
    }

    public void addOrigIdAccIdMapping(Integer orig, Integer acc) {
        this.accId2id.put(acc, orig);
        this.id2accId.put(orig, acc);
    }

    @Override
    public void addReplacedNodeMapping(Node result, Node replacement) {
        this.removedNodeMap.put(result, replacement);
    }

    protected void addNodeIdMapping(Node result, Integer id) {
        this.result2idMap.put(result, id);
        this.orig2idMap.put(this.getOrigNode(result), id);
    }

    protected void addNodeInfoMapping(Node result, VisualizationNodeInfo nodeInfo) {
        this.node2infoMap.put(result, nodeInfo);
    }

    protected void addNodeInfoIntoList(VisualizationNodeInfo info) {
        this.nodeInfoList.add(info);
    }

    protected void addIntraPageLinkMapping(Node source, Node dest) {
        this.intraPageLinkMap.put(source, dest);
    }

    @Override
    public Node getOrigNode(Node result) {
        return this.result2origMap.get(result);
    }

    @Override
    public Node getResultNode(Node orig) {
        return this.orig2resultMap.get(orig);
    }

    @Override
    public Node getReplacement(Node result) {
        return this.removedNodeMap.get(result);
    }

    @Override
    public Integer getIdOfNode(Node result) {
        return this.result2idMap.get(result);
    }

    @Override
    public Integer getIdOfOrigNode(Node orig) {
        return this.orig2idMap.get(orig);
    }

    public VisualizationNodeInfo getNodeInfo(Node result) {
        return this.node2infoMap.get(result);
    }

    public void makeIdMapping(String targetIdS) {
        Set<Node> nodeSet = this.getResult2idMap().keySet();
        for (Node node : nodeSet) {
            if (node.getNodeType() != 1) continue;
            Integer targetId = this.getIdOfNode(node);
            Element tmpE = (Element)node;
            tmpE.setAttribute("id", "id" + targetId.toString());
            if (tmpE.hasAttribute(targetIdS)) {
                try {
                    Integer accId = new Integer(tmpE.getAttribute(targetIdS));
                    this.addOrigIdAccIdMapping(targetId, accId);
                }
                catch (Exception exception) {}
            }
            DocumentCleaner.removeOnMouse((Element)node);
        }
    }
}

