/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentCleaner {
    public static Set<String> removeCSS(Document result, String baseUrl) {
        NodeList styleEl;
        HashSet<String> cssSet = new HashSet<String>();
        URL baseURL = null;
        try {
            baseURL = new URL(baseUrl);
        }
        catch (Exception exception) {}
        NodeList linkEl = result.getElementsByTagName("link");
        if (linkEl != null) {
            int xy = linkEl.getLength();
            int i = xy - 1;
            while (i >= 0) {
                Element x = (Element)linkEl.item(i);
                if ("text/css".equals(x.getAttribute("type"))) {
                    String hrefS = DocumentCleaner.getHref(x, baseURL);
                    if (!hrefS.equals("")) {
                        cssSet.add(hrefS);
                    }
                    x.getParentNode().removeChild(x);
                }
                --i;
            }
        }
        if ((styleEl = result.getElementsByTagName("style")) != null) {
            int xy = styleEl.getLength();
            int i = xy - 1;
            while (i >= 0) {
                Element x = (Element)styleEl.item(i);
                if (x.getAttribute("type").equals("text/css")) {
                    NodeList tmpNL = x.getChildNodes();
                    int j = 0;
                    while (j < tmpNL.getLength()) {
                        Node tmpN = tmpNL.item(j);
                        DocumentCleaner.getImportUrl(tmpN.toString(), baseURL, cssSet);
                        ++j;
                    }
                }
                x.getParentNode().removeChild(x);
                --i;
            }
        }
        NodeList bodyNl = result.getElementsByTagName("body");
        int i = 0;
        while (i < bodyNl.getLength()) {
            Element bodyEl = (Element)bodyNl.item(i);
            bodyEl.removeAttribute("style");
            ++i;
        }
        return cssSet;
    }

    private static String createFullPath(URL baseURL, String spec) {
        String result = spec;
        if (baseURL != null) {
            try {
                URL targetUrl = new URL(baseURL, spec);
                result = targetUrl.toString();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    private static String getHref(Element target, URL baseURL) {
        String result = "";
        if (target.hasAttribute("href")) {
            result = target.getAttribute("href");
            result = DocumentCleaner.createFullPath(baseURL, result);
        }
        return result;
    }

    private static void getImportUrl(String target, URL baseURL, Set<String> cssSet) {
        BufferedReader tmpBR = new BufferedReader(new StringReader(target));
        try {
            String tmpS;
            while ((tmpS = tmpBR.readLine()) != null) {
                int index = tmpS.indexOf("@import");
                if (index <= -1 || (index = (tmpS = tmpS.substring(index + 7)).indexOf("url(\"")) <= -1 || (index = (tmpS = tmpS.substring(index + 5)).indexOf("\");")) <= -1) continue;
                tmpS = tmpS.substring(0, index);
                tmpS = DocumentCleaner.createFullPath(baseURL, tmpS);
                cssSet.add(tmpS);
            }
        }
        catch (IOException iOException) {}
    }

    public static void removeBase(Document result) {
        NodeList objectNl = result.getElementsByTagName("base");
        int size = objectNl.getLength();
        int i = size - 1;
        while (i >= 0) {
            Element objectEl = (Element)objectNl.item(i);
            objectEl.getParentNode().removeChild(objectEl);
            --i;
        }
    }

    public static void removeApplet(Document result) {
        NodeList appletNl = result.getElementsByTagName("applet");
        int size = appletNl.getLength();
        int i = size - 1;
        while (i >= 0) {
            Element appletEl = (Element)appletNl.item(i);
            String id = appletEl.getAttribute("id");
            Element divEl = result.createElement("div");
            divEl.setAttribute("id", id);
            Node curChild = appletEl.getLastChild();
            while (curChild != null) {
                Node next = curChild.getPreviousSibling();
                if (!curChild.getNodeName().equals("param")) {
                    if (divEl.hasChildNodes()) {
                        divEl.insertBefore(curChild, divEl.getFirstChild());
                    } else {
                        divEl.appendChild(curChild);
                    }
                }
                curChild = next;
            }
            appletEl.getParentNode().insertBefore(divEl, appletEl);
            appletEl.getParentNode().removeChild(appletEl);
            --i;
        }
    }

    public static void removeObject(Document result) {
        NodeList objectNl = result.getElementsByTagName("object");
        int size = objectNl.getLength();
        int i = size - 1;
        while (i >= 0) {
            Element objectEl = (Element)objectNl.item(i);
            String id = objectEl.getAttribute("id");
            Element divEl = result.createElement("div");
            divEl.setAttribute("id", id);
            Node curChild = objectEl.getLastChild();
            while (curChild != null) {
                Node next = curChild.getPreviousSibling();
                if (!curChild.getNodeName().equals("param")) {
                    if (divEl.hasChildNodes()) {
                        divEl.insertBefore(curChild, divEl.getFirstChild());
                    } else {
                        divEl.appendChild(curChild);
                    }
                }
                curChild = next;
            }
            objectEl.getParentNode().insertBefore(divEl, objectEl);
            objectEl.getParentNode().removeChild(objectEl);
            --i;
        }
    }

    public static void removeEmbed(Document doc) {
        NodeList nl = doc.getElementsByTagName("embed");
        int size = nl.getLength();
        int i = size - 1;
        while (i >= 0) {
            Node startNode;
            Element el = (Element)nl.item(i);
            String id = el.getAttribute("id");
            Element newDiv = doc.createElement("div");
            newDiv.setAttribute("id", id);
            Node parent = el.getParentNode();
            NodeList noembedL = el.getElementsByTagName("noembed");
            Node childNoembed = null;
            boolean hasNoembed = false;
            int j = 0;
            while (j < noembedL.getLength()) {
                childNoembed = noembedL.item(j);
                if (el == childNoembed.getParentNode()) {
                    hasNoembed = true;
                    break;
                }
                ++j;
            }
            if (hasNoembed) {
                NodeList tmpNL = childNoembed.getChildNodes();
                int k = tmpNL.getLength() - 1;
                while (k >= 0) {
                    newDiv.insertBefore(tmpNL.item(k), newDiv.getFirstChild());
                    --k;
                }
                startNode = childNoembed.getNextSibling();
            } else {
                newDiv.appendChild(doc.createTextNode("(Embeded element)"));
                startNode = el.getFirstChild();
            }
            parent.insertBefore(newDiv, el);
            while (startNode != null) {
                Node next = startNode.getNextSibling();
                parent.insertBefore(startNode, el);
                startNode = next;
            }
            parent.removeChild(el);
            --i;
        }
    }

    public static void removeOnMouse(Element element) {
        String str = element.getAttribute("onmouseover");
        if (str != null && str.length() > 0) {
            element.removeAttribute("onmouseover");
        }
        if ((str = element.getAttribute("onmouseout")) != null && str.length() > 0) {
            element.removeAttribute("onmouseout");
        }
        if ((str = element.getAttribute("onmousemove")) != null && str.length() > 0) {
            element.removeAttribute("onmousemove");
        }
        if ((str = element.getAttribute("onclick")) != null && str.length() > 0) {
            element.removeAttribute("onclick");
        }
        if ((str = element.getAttribute("onresize")) != null && str.length() > 0) {
            element.removeAttribute("onresize");
        }
    }

    public static void removeOnLoad(Element element) {
        String str = element.getAttribute("onload");
        if (str != null && str.length() > 0) {
            element.removeAttribute("onload");
        }
    }

    public static void removeDisplayNone(Document doc) {
        NodeList tmpNL = doc.getElementsByTagName("div");
        int i = tmpNL.getLength() - 1;
        while (i >= 0) {
            Node parent;
            Element tmpE = (Element)tmpNL.item(i);
            if (tmpE.getAttribute("style").indexOf("DISPLAY: none") > -1 && (parent = tmpE.getParentNode()) != null) {
                parent.removeChild(tmpE);
            }
            --i;
        }
    }

    public static void removeBgcolor(Document doc) {
        NodeList bodyNl = doc.getElementsByTagName("body");
        if (bodyNl.getLength() > 0) {
            Element bodyEl = (Element)bodyNl.item(0);
            bodyEl.removeAttribute("bgcolor");
        }
    }

    public static void removeMeta(Document doc) {
        NodeList nl = doc.getElementsByTagName("meta");
        int size = nl.getLength();
        int i = 0;
        while (i < size) {
            Element el = (Element)nl.item(i);
            String http_equiv = el.getAttribute("http-equiv");
            if (http_equiv != null && (http_equiv.equalsIgnoreCase("refresh") || http_equiv.equalsIgnoreCase("Content-Type"))) {
                el.removeAttribute("http-equiv");
            }
            ++i;
        }
    }

    public static void removeJavaScript(List<VisualizationNodeInfo> nodeList, Document doc) {
        NodeList nl = doc.getElementsByTagName("script");
        int size = nl.getLength();
        int i = size - 1;
        while (i >= 0) {
            try {
                Element el = (Element)nl.item(i);
                el.getParentNode().removeChild(el);
            }
            catch (Exception exception) {}
            --i;
        }
        nl = doc.getElementsByTagName("body");
        size = nl.getLength();
        i = 0;
        while (i < size) {
            try {
                ((Element)nl.item(i)).removeAttribute("onload");
                ((Element)nl.item(i)).removeAttribute("onunload");
            }
            catch (Exception exception) {}
            ++i;
        }
        size = nodeList.size();
        i = 0;
        while (i < size) {
            Node node = nodeList.get(i).getNode();
            if (node.getNodeType() == 1) {
                try {
                    String onmouseover;
                    Element el = (Element)node;
                    String onload = el.getAttribute("onload");
                    if (onload.length() > 0) {
                        el.removeAttribute("onload");
                    }
                    if ((onmouseover = el.getAttribute("onmouseover")).length() > 0) {
                        el.removeAttribute("onmouseover");
                    }
                }
                catch (Exception exception) {}
            }
            ++i;
        }
    }

    public static void removePI(Document doc) {
        NodeList nl = doc.getChildNodes();
        int i = nl.getLength() - 1;
        while (i > -1) {
            Node n = nl.item(i);
            if (n instanceof ProcessingInstruction) {
                doc.removeChild(n);
            }
            --i;
        }
    }
}

