/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.blind.html;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.blind.html.IBlindProblem;
import org.eclipse.actf.visualization.engines.blind.html.util.Id2LineViaActfId;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetId;
import org.eclipse.actf.visualization.eval.problem.HighlightTargetSourceInfo;
import org.eclipse.actf.visualization.eval.problem.ProblemItemImpl;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapData;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BlindProblem
extends ProblemItemImpl
implements IBlindProblem {
    private static final String ID = "id";
    private List<Node> nodeList = null;
    private int nodeId = -1;
    private boolean isMulti = false;
    private ArrayList<HighlightTargetId> idsList = new ArrayList();

    public BlindProblem(int _subtype) {
        this(_subtype, "");
    }

    public BlindProblem(int _subtype, String targetString) {
        super("B_" + Integer.toString(_subtype));
        this.subType = _subtype;
        this.nodeList = new Vector<Node>();
        this.setTargetString(targetString);
        switch (_subtype) {
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 15: 
            case 18: 
            case 27: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 37: {
                this.targetStringForHPB = targetString;
            }
        }
    }

    public Node getTargetNodeInResultDoc() {
        if (this.nodeList.size() > 0) {
            return this.nodeList.get(0);
        }
        return null;
    }

    public void setNode(Node node) {
        this.nodeList.add(0, node);
    }

    public void addNode(Node node) {
        this.nodeList.add(node);
    }

    public void setNode(Node node, int id) {
        this.nodeList.add(0, node);
        this.nodeId = id;
    }

    public String toString() {
        return "node=" + this.nodeId + ":" + this.getDescription();
    }

    public List<Node> getNodeList() {
        return this.nodeList;
    }

    public boolean setNodeId(int nodeId) {
        if (this.nodeId == -1) {
            this.nodeId = nodeId;
            return true;
        }
        return false;
    }

    public void addNodeIds(HighlightTargetId target) {
        this.isMulti = true;
        this.idsList.add(target);
    }

    public void prepareHighlight() {
        if (this.isMulti) {
            HighlightTargetId[] targets = new HighlightTargetId[this.idsList.size()];
            this.idsList.toArray(targets);
            this.setHighlightTargetIds(targets);
        } else if (this.nodeId > -1) {
            this.setHighlightTargetIds(new HighlightTargetId(this.nodeId, this.nodeId));
        }
    }

    private int getElementId(Element target) {
        int result = -1;
        String tmpId = target.getAttribute(ID);
        if (tmpId.length() > 0 && tmpId.startsWith(ID)) {
            tmpId = tmpId.substring(tmpId.indexOf(ID) + 2);
            try {
                result = Integer.parseInt(tmpId);
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public void setLineNumber(Id2LineViaActfId id2line) {
        switch (this.subType) {
            case 15: {
                try {
                    Html2ViewMapData tmpData;
                    int id;
                    Node tmpN = this.getTargetNodeInResultDoc().getParentNode().getParentNode();
                    if (tmpN == null || tmpN.getNodeType() != 1 || (id = this.getElementId((Element)tmpN)) <= -1 || (tmpData = id2line.getViewMapData(id)) == null) break;
                    this.setHighlightTargetSourceInfo(new HighlightTargetSourceInfo(tmpData, tmpData));
                }
                catch (Exception exception) {}
                break;
            }
            case 2: 
            case 6: 
            case 31: {
                int id;
                Node tmpN = this.getTargetNodeInResultDoc();
                if (tmpN.getNodeType() != 1 || (id = this.getElementId((Element)tmpN)) <= -1) break;
                Html2ViewMapData tmpData = id2line.getViewMapData(id);
                this.setHighlightTargetSourceInfo(new HighlightTargetSourceInfo(tmpData, tmpData));
                break;
            }
            default: {
                if (this.isMulti) {
                    ArrayList<HighlightTargetSourceInfo> tmpArray = new ArrayList<HighlightTargetSourceInfo>();
                    HighlightTargetId[] targets = new HighlightTargetId[this.idsList.size()];
                    this.idsList.toArray(targets);
                    int i = 0;
                    while (i < targets.length) {
                        Html2ViewMapData startData = id2line.getViewMapData(targets[i].getStartId());
                        Html2ViewMapData endData = id2line.getViewMapData(targets[i].getEndId());
                        if (startData == null) {
                            startData = endData;
                        }
                        if (endData == null) {
                            endData = startData;
                        }
                        if (startData != null) {
                            tmpArray.add(new HighlightTargetSourceInfo(startData, endData));
                        }
                        ++i;
                    }
                    HighlightTargetSourceInfo[] sourceInfo = new HighlightTargetSourceInfo[tmpArray.size()];
                    tmpArray.toArray(sourceInfo);
                    this.setHighlightTargetSourceInfo(sourceInfo);
                    break;
                }
                Html2ViewMapData tmpData = id2line.getViewMapData(this.nodeId);
                if (tmpData == null) break;
                this.setHighlightTargetSourceInfo(new HighlightTargetSourceInfo(tmpData, tmpData));
            }
        }
    }
}

