/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl;

import java.util.List;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.model.ui.editor.browser.IWebBrowserACTF;
import org.eclipse.actf.model.ui.util.ModelServiceUtils;
import org.eclipse.actf.visualization.engines.blind.BlindVizResourceUtil;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.IHighlightElementListener;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.CSSViewer;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.ElementLabelAndColorProvider;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.ElementViewerJFace;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.IViewerPanel;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.VisualizeStyleInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationAttributeInfo;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class ViewerPanelJFace
implements IViewerPanel {
    private Shell shell;
    private List<VisualizationAttributeInfo> idList;
    private IHighlightElementListener prb;
    private ElementViewerJFace idViewer;
    private ElementViewerJFace akeyViewer;
    private ElementViewerJFace classViewer;
    private CSSViewer cssViewer;
    private boolean isDisposed = false;

    public ViewerPanelJFace(Shell _shell, VisualizeStyleInfo styleInfo, IHighlightElementListener _prb) {
        if (styleInfo == null) {
            styleInfo = new VisualizeStyleInfo();
            this.idList = null;
        } else {
            this.idList = styleInfo.getOrigIdList();
        }
        this.prb = _prb;
        this.shell = new Shell(_shell, 1232);
        this.shell.setLayout((Layout)new GridLayout());
        this.shell.setText("ID/AccessKey/Class/CSS Inspector");
        this.shell.setImage(BlindVizResourceUtil.getImageDescriptor((String)"icons/excla_squ.png").createImage());
        this.shell.setLocation(100, 100);
        Composite composite = new Composite((Composite)this.shell, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout gridLayout1 = new GridLayout();
        gridLayout1.numColumns = 1;
        composite.setLayout((Layout)gridLayout1);
        TabFolder viewerFolder = new TabFolder(composite, 0);
        GridData gridData = new GridData(1808);
        viewerFolder.setLayoutData((Object)gridData);
        TabItem tabItemEle = new TabItem(viewerFolder, 0);
        tabItemEle.setText("ID");
        this.idViewer = new ElementViewerJFace((Composite)viewerFolder, this.prb);
        this.idViewer.setCategoryColWidth(100);
        this.idViewer.setDescColWidth(0);
        this.idViewer.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.idViewer.setLabelProvider(new ElementLabelAndColorProvider());
        this.idViewer.setElementList(this.idList);
        tabItemEle.setControl((Control)this.idViewer.getComposite());
        TabItem tabItemAKey = new TabItem(viewerFolder, 0);
        tabItemAKey.setText("AccessKey");
        this.akeyViewer = new ElementViewerJFace((Composite)viewerFolder, this.prb);
        this.akeyViewer.setCategoryColWidth(0);
        this.akeyViewer.setDescColWidth(150);
        this.akeyViewer.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.akeyViewer.setLabelProvider(new ElementLabelAndColorProvider());
        this.akeyViewer.setElementList(styleInfo.getAccesskeyList());
        tabItemAKey.setControl((Control)this.akeyViewer.getComposite());
        TabItem tabItemClass = new TabItem(viewerFolder, 0);
        tabItemClass.setText("Class");
        this.classViewer = new ElementViewerJFace((Composite)viewerFolder, this.prb);
        this.classViewer.setCategoryColWidth(0);
        this.classViewer.setDescColWidth(0);
        this.classViewer.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        this.classViewer.setLabelProvider(new ElementLabelAndColorProvider());
        this.classViewer.setElementList(styleInfo.getClassList());
        tabItemClass.setControl((Control)this.classViewer.getComposite());
        TabItem tabItemCss = new TabItem(viewerFolder, 0);
        tabItemCss.setText("CSS");
        this.cssViewer = new CSSViewer((Composite)viewerFolder);
        this.cssViewer.setCssSet(styleInfo.getImportedCssSet());
        tabItemCss.setControl((Control)this.cssViewer.getCompositeCss());
        viewerFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (ViewerPanelJFace.this.idList != null) {
                    ViewerPanelJFace.this.recoveryHighlight();
                }
            }
        });
        Button closeButton = new Button(composite, 0);
        closeButton.setText(CLOSE_BUTTON);
        gridData = new GridData(128);
        closeButton.setLayoutData((Object)gridData);
        closeButton.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                ViewerPanelJFace.this.shell.dispose();
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                if (ViewerPanelJFace.this.idList != null) {
                    ViewerPanelJFace.this.recoveryHighlight();
                }
                ViewerPanelJFace.this.isDisposed = true;
            }
        });
        this.shell.setSize(450, 420);
        this.shell.open();
    }

    private void recoveryHighlight() {
        IModelService dataSource = ModelServiceUtils.getActiveModelService();
        if (dataSource != null && dataSource instanceof IWebBrowserACTF) {
            ((IWebBrowserACTF)dataSource).clearHighlight();
        }
        this.prb.clearHighlight();
    }

    public void asyncUpdateValue(VisualizeStyleInfo styleInfo) {
        final VisualizeStyleInfo _styleInfo = styleInfo;
        this.shell.getDisplay().asyncExec((Runnable)new Thread(){

            public void run() {
                ViewerPanelJFace.this.idList = _styleInfo.getOrigIdList();
                ViewerPanelJFace.this.idViewer.setElementList(ViewerPanelJFace.this.idList);
                ViewerPanelJFace.this.akeyViewer.setElementList(_styleInfo.getAccesskeyList());
                ViewerPanelJFace.this.classViewer.setElementList(_styleInfo.getClassList());
                ViewerPanelJFace.this.cssViewer.setCssSet(_styleInfo.getImportedCssSet());
            }
        });
    }

    public void forceActive() {
        this.shell.setMinimized(false);
        this.shell.setVisible(true);
        this.shell.forceActive();
    }

    public void hide() {
        this.shell.setVisible(false);
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

