/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.html;

import java.io.File;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.actf.util.logging.DebugPrintUtil;
import org.eclipse.actf.visualization.engines.blind.ParamBlind;
import org.eclipse.actf.visualization.engines.blind.TextCheckResult;
import org.eclipse.actf.visualization.engines.blind.TextChecker;
import org.eclipse.actf.visualization.engines.blind.html.IVisualizeMapData;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.VisualizeStyleInfo;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.VisualizeStyleInfoManager;
import org.eclipse.actf.visualization.engines.blind.html.util.Id2LineViaActfId;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacketCollection;
import org.eclipse.actf.visualization.engines.voicebrowser.IVoiceBrowserController;
import org.eclipse.actf.visualization.engines.voicebrowser.VoiceBrowserControllerFactory;
import org.eclipse.actf.visualization.eval.EvaluationUtil;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.html.BlindProblem;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.DocumentCleaner;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.ImgChecker;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.LinkAnalyzer;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.NodeInfoCreator;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationResultCleaner;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeColorUtil;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapUtil;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeViewUtil;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizeEngine {
    public static String ERROR_ICON_NAME = "exclawhite21.gif";
    private static final String errorStyle = "color: #dd0000; background-color: #FFFFFF; border-width: medium; border-style: solid; border-color: #dd0000;";
    private static final String CHECK_ITEM_PATTERN = "B_\\p{Digit}+";
    private static final boolean DEBUG = false;
    private String baseUrl = "";
    private String targetUrl = "";
    private Document orig = null;
    private Document result = null;
    private List<IProblemItem> problems = null;
    private Vector<Html2ViewMapData> html2viewMapV = new Vector();
    private VisualizeMapDataImpl mapData = null;
    private VisualizeStyleInfo styleInfo;
    private IVoiceBrowserController jwatc = null;
    private boolean fIsActivating = false;
    private IPacketCollection allPc = null;
    private boolean servletMode = false;
    private int iMaxTime;
    private int iMaxTimeLeaf;
    private Set<String> invisibleIdSet = new HashSet<String>();
    private TextChecker textChecker;
    private PageData pageData;
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private boolean[] checkItems = new boolean[39];
    private File variantFile;

    public VisualizeEngine() {
        this.jwatInit();
        this.initCheckItems();
        this.textChecker = TextChecker.getInstance();
    }

    private void initCheckItems() {
        Arrays.fill(this.checkItems, false);
        Set itemSet = this.guidelineHolder.getMatchedCheckitemSet();
        for (IEvaluationItem cItem : itemSet) {
            String id = cItem.getId();
            if (!id.matches(CHECK_ITEM_PATTERN)) continue;
            id = id.substring(2);
            try {
                int item = Integer.parseInt(id);
                if (item <= -1 || item >= 39) continue;
                this.checkItems[item] = true;
            }
            catch (Exception exception) {}
        }
    }

    public void setDocument(Document document) {
        DocumentCleaner.removeDisplayNone(document);
        this.orig = document;
        this.result = (Document)document.cloneNode(true);
        this.jwatc.setDocument(this.result);
        this.pageData = new PageData();
        this.mapData = new VisualizeMapDataImpl();
        VisualizeMapUtil.createNode2NodeMap(document, this.result, this.mapData);
    }

    private void cleanupPacketCollection(IPacketCollection pc) {
        if (pc != null) {
            int size = pc.size();
            int i = size - 1;
            while (i >= 0) {
                IPacket p = (IPacket)pc.get(i);
                Node tmpNode = p.getNode();
                while (tmpNode != null) {
                    if (tmpNode.getNodeName().equals("noscript")) {
                        pc.remove(i);
                        break;
                    }
                    tmpNode = tmpNode.getParentNode();
                }
                --i;
            }
        }
    }

    public void visualize() {
        if (this.result == null) {
            return;
        }
        this.problems = new Vector<IProblemItem>();
        this.allPc = this.jwatc.getPacketCollection();
        DebugPrintUtil.debugPrintln((Object)("packet collection\t" + new Date().getTime()));
        this.cleanupPacketCollection(this.allPc);
        DebugPrintUtil.debugPrintln((Object)("cleanup packet collection\t" + new Date().getTime()));
        ParamBlind curParamBlind = ParamBlind.getInstance();
        NodeInfoCreator nodeInfoCreator = new NodeInfoCreator(this.mapData, this.textChecker, this.problems, this.invisibleIdSet, curParamBlind);
        DebugPrintUtil.debugPrintln((Object)("Nodeinfo init\t" + new Date().getTime()));
        nodeInfoCreator.prepareNodeInfo(this.allPc);
        DebugPrintUtil.debugPrintln((Object)("Nodeinfo prep\t" + new Date().getTime()));
        nodeInfoCreator.createAdditionalNodeInfo(this.result);
        DebugPrintUtil.debugPrintln((Object)("Nodeinfo additional\t" + new Date().getTime()));
        LinkAnalyzer linkAnalyzer = new LinkAnalyzer(this.result, this.allPc, this.mapData, this.problems, this.invisibleIdSet, curParamBlind, this.pageData);
        DebugPrintUtil.debugPrintln((Object)("link analyzer\t" + new Date().getTime()));
        this.styleInfo = new VisualizeStyleInfo(this.orig, this.mapData);
        DebugPrintUtil.debugPrintln((Object)("style info\t" + new Date().getTime()));
        this.mapData.makeIdMapping("eclipse-actf-id");
        DebugPrintUtil.debugPrintln((Object)("id mapping\t" + new Date().getTime()));
        this.styleInfo.setImportedCssSet(DocumentCleaner.removeCSS(this.result, this.targetUrl));
        if (this.result.getElementsByTagName("head").getLength() == 0) {
            Element tmpHead = this.result.createElement("head");
            Element tmpHtml = this.result.getDocumentElement();
            if (tmpHtml != null) {
                tmpHtml.insertBefore(tmpHead, tmpHtml.getFirstChild());
            }
        }
        VisualizeColorUtil colorUtil = new VisualizeColorUtil(this.result, this.mapData, curParamBlind);
        colorUtil.setColorAll();
        DebugPrintUtil.debugPrintln((Object)("color\t" + new Date().getTime()));
        this.calMaxTime();
        DebugPrintUtil.debugPrintln((Object)("max time\t" + new Date().getTime()));
        this.problems.addAll(linkAnalyzer.skipLinkCheck(this.iMaxTime, this.iMaxTimeLeaf));
        DebugPrintUtil.debugPrintln((Object)("skiplink check\t" + new Date().getTime()));
        this.replaceImgAndCheck(this.result, this.mapData, curParamBlind.oReplaceImage);
        DebugPrintUtil.debugPrintln((Object)("image check\t" + new Date().getTime()));
        int errorCount = 0;
        int missing = 0;
        int wrong = 0;
        Iterator<IProblemItem> i = this.problems.iterator();
        while (i.hasNext()) {
            IProblemItem tmpBP = i.next();
            if (!(tmpBP instanceof BlindProblem)) continue;
            BlindProblem curBP = (BlindProblem)tmpBP;
            if (this.checkItems[curBP.getSubType()]) {
                if (curBP.getSeverity() != 1) continue;
                switch (curBP.getSubType()) {
                    case 0: 
                    case 1: {
                        ++missing;
                        ++errorCount;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 29: 
                    case 30: 
                    case 38: {
                        ++wrong;
                        ++errorCount;
                    }
                }
                continue;
            }
            i.remove();
        }
        this.pageData.setImageAltErrorNum(errorCount);
        this.pageData.setWrongAltNum(wrong);
        this.pageData.setMissingAltNum(missing);
        VisualizeViewUtil.visualizeError(this.result, this.problems, this.mapData, this.baseUrl);
        DebugPrintUtil.debugPrintln((Object)("error visualization\t" + new Date().getTime()));
        DocumentCleaner.removeJavaScript(this.mapData.getNodeInfoList(), this.result);
        DocumentCleaner.removeMeta(this.result);
        DocumentCleaner.removeObject(this.result);
        DocumentCleaner.removeEmbed(this.result);
        DocumentCleaner.removeApplet(this.result);
        DocumentCleaner.removeBase(this.result);
        DocumentCleaner.removePI(this.result);
        DebugPrintUtil.debugPrintln((Object)("document cleaner\t" + new Date().getTime()));
        VisualizationResultCleaner.clean(this.result, this.targetUrl);
        DebugPrintUtil.debugPrintln((Object)("result cleaner\t" + new Date().getTime()));
        Id2LineViaActfId id2line = null;
        if (EvaluationUtil.isOriginalDOM()) {
            id2line = new Id2LineViaActfId(this.mapData.getId2AccIdMap(), this.html2viewMapV);
        }
        DebugPrintUtil.debugPrintln((Object)("id2line\t" + new Date().getTime()));
        for (IProblemItem i2 : this.problems) {
            BlindProblem tmpBP = (BlindProblem)i2;
            tmpBP.prepareHighlight();
            if (id2line == null) continue;
            tmpBP.setLineNumber(id2line);
        }
        VisualizeStyleInfoManager.getInstance().fireVisualizeStyleInfoUpdate(this.styleInfo);
        if (curParamBlind.visualizeMode.equals(ParamBlind.BLIND_BROWSER_MODE)) {
            VisualizeViewUtil.returnTextView(this.result, this.allPc, this.baseUrl);
            return;
        }
        this.variantFile = VisualizeViewUtil.prepareActions(this.result, this.mapData, this.baseUrl, this.servletMode);
    }

    private void replaceImgAndCheck(Document doc, VisualizeMapDataImpl mapData, boolean remove) {
        NodeList mapList = doc.getElementsByTagName("map");
        HashMap<String, Element> mapMap = new HashMap<String, Element>();
        int mapListsize = mapList.getLength();
        int i = 0;
        while (i < mapListsize) {
            Element mapEl = (Element)mapList.item(i);
            mapMap.put(mapEl.getAttribute("name"), mapEl);
            ++i;
        }
        NodeList nl = doc.getElementsByTagName("img");
        int size = nl.getLength();
        Vector<IProblemItem> problemV = new Vector<IProblemItem>();
        ImgChecker imgChecker = new ImgChecker(mapData, mapMap, this.textChecker, problemV, this.baseUrl, this.checkItems);
        this.pageData.setTotalImageNumber(size);
        int i2 = size - 1;
        while (i2 >= 0) {
            Element img = (Element)nl.item(i2);
            imgChecker.checkAndReplaceImg(img, doc, remove);
            --i2;
        }
        size = problemV.size();
        i2 = size - 1;
        while (i2 >= 0) {
            IProblemItem tmpProblem = problemV.get(i2);
            this.problems.add(tmpProblem);
            --i2;
        }
        nl = doc.getElementsByTagName("iframe");
        size = nl.getLength();
        i2 = size - 1;
        while (i2 >= 0) {
            Element iframe = (Element)nl.item(i2);
            Element div = doc.createElement("div");
            div.setAttribute("comment", iframe.getAttribute("comment"));
            div.setAttribute("id", iframe.getAttribute("id"));
            String title = null;
            boolean error = false;
            NamedNodeMap map = iframe.getAttributes();
            int mapSize = map.getLength();
            Node titleNode = null;
            int j = 0;
            while (j < mapSize) {
                Node node = map.item(j);
                if (node.getNodeName().equals("title")) {
                    titleNode = node;
                    break;
                }
                ++j;
            }
            if (titleNode != null) {
                title = titleNode.getNodeValue();
            } else {
                error = true;
                title = "";
            }
            if (remove) {
                div.setAttribute("width", iframe.getAttribute("width"));
                div.setAttribute("height", iframe.getAttribute("height"));
                if (error) {
                    div.appendChild(doc.createTextNode("[iframe: (without title)]"));
                    div.setAttribute("style", errorStyle);
                } else {
                    div.appendChild(doc.createTextNode("[iframe: title=\"" + title + "\"]"));
                    if (title.matches("^[\\s\u3000]*$")) {
                        div.setAttribute("style", errorStyle);
                    } else {
                        div.setAttribute("style", iframe.getAttribute("style"));
                    }
                }
                Node parent = iframe.getParentNode();
                parent.insertBefore(div, iframe);
                mapData.addReplacedNodeMapping(iframe, div);
                parent.removeChild(iframe);
            }
            --i2;
        }
        nl = doc.getElementsByTagName("input");
        size = nl.getLength();
        Vector<BlindProblem> tmpV = new Vector<BlindProblem>();
        int i3 = size - 1;
        while (i3 >= 0) {
            Element input = (Element)nl.item(i3);
            String typeS = input.getAttribute("type").toLowerCase();
            if (typeS.equalsIgnoreCase("image")) {
                input.setAttribute("type", "button");
                NamedNodeMap map = input.getAttributes();
                int mapSize = map.getLength();
                Node altNode = null;
                int j = 0;
                while (j < mapSize) {
                    Node node = map.item(j);
                    if (node.getNodeName().equals("alt")) {
                        altNode = node;
                        break;
                    }
                    ++j;
                }
                if (altNode != null) {
                    input.setAttribute("value", altNode.getNodeValue());
                } else {
                    BlindProblem prob = new BlindProblem(1);
                    Integer idObj = mapData.getIdOfNode(input);
                    if (idObj != null) {
                        prob.setNode(input, idObj);
                    } else {
                        prob.setNode(input);
                    }
                    prob.setTargetNode(mapData.getOrigNode(input));
                    tmpV.add(prob);
                    input.setAttribute("value", input.getAttribute("src"));
                    input.setAttribute("style", errorStyle);
                }
            } else if (typeS.matches("submit|reset|button")) {
                BlindProblem prob = null;
                String valueS = input.getAttribute("value");
                if (valueS.length() == 0) {
                    if (typeS.equals("button")) {
                        prob = new BlindProblem(36);
                    }
                } else {
                    TextCheckResult result = this.textChecker.checkAlt(valueS);
                    if (result.equals((Object)TextCheckResult.SPACE_SEPARATED) || result.equals((Object)TextCheckResult.SPACE_SEPARATED_JP)) {
                        prob = new BlindProblem(37, valueS);
                    }
                }
                if (prob != null) {
                    Integer idObj = mapData.getIdOfNode(input);
                    if (idObj != null) {
                        prob.setNode(input, idObj);
                    } else {
                        prob.setNode(input);
                    }
                    prob.setTargetNode(mapData.getOrigNode(input));
                    tmpV.add(prob);
                }
            }
            --i3;
        }
        i3 = tmpV.size() - 1;
        while (i3 > -1) {
            this.problems.add((IProblemItem)tmpV.get(i3));
            --i3;
        }
    }

    private void jwatInit() {
        if (this.fIsActivating) {
            return;
        }
        this.fIsActivating = true;
        if (this.jwatc == null) {
            try {
                this.jwatc = VoiceBrowserControllerFactory.createVoiceBrowserController();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Document getResult() {
        return this.result;
    }

    public List<IProblemItem> getProbelems() {
        return this.problems;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public void setTargetUrl(String string) {
        this.targetUrl = string;
    }

    private void calMaxTime() {
        this.iMaxTime = 0;
        this.iMaxTimeLeaf = 0;
        int orgMaxTime = 0;
        List<VisualizationNodeInfo> elementList = this.mapData.getNodeInfoList();
        int size = elementList.size();
        int i = 0;
        while (i < size) {
            VisualizationNodeInfo curInfo = elementList.get(i);
            int time = curInfo.getTime();
            if (time > this.iMaxTime) {
                this.iMaxTime = time;
            }
            if (curInfo.isBlockElement() && !curInfo.isSequence() && time > this.iMaxTimeLeaf) {
                this.iMaxTimeLeaf = time;
            }
            if (orgMaxTime < curInfo.getOrgTime()) {
                orgMaxTime = curInfo.getOrgTime();
            }
            ++i;
        }
        this.pageData.setMaxTime(this.iMaxTime);
        this.pageData.setOrgMaxTime(orgMaxTime);
    }

    public int getMaxTime() {
        return this.iMaxTime;
    }

    public void setInvisibleIdSet(Set<String> invisibleIdSet) {
        this.invisibleIdSet = invisibleIdSet;
    }

    public IVisualizeMapData getVisualizeMapData() {
        return this.mapData;
    }

    public void setHtml2viewMapV(Vector<Html2ViewMapData> html2viewMapV) {
        this.html2viewMapV = html2viewMapV;
    }

    public void setPageData(PageData pageData) {
        this.pageData = pageData;
    }

    public File getVariantFile() {
        return this.variantFile;
    }
}

